#!/Perl
use XML::DOM;
###use Data::Dumper;
require "logfile.pl" or die "Missing logfile.pl ...\n"; # my simple log file
# perl -MCPAN -e shell 'install XML::DOM'
# or Parser' 
#You need the following modules (all available at CPAN): 
# Perl 5.6.0 or higher (can run under earlier versions, simply remove 
# use bytes; from lib/XML/DOM.pm) 
# XML::RegExp 
# XML::Parser (At least version 2.28, 2.30 recommended) 
# If you are using XML::Parser 2.27, then you should download libxml-enno-1.02 from 
# your local CPAN mirror. If you are using Perl 5.8.0 or greater and XML::Parser 2.32 or 
# lesser, you must apply the included XML-Parser-2.31.patch. 
# LWP::UserAgent (It's part of libwww-perl. If you don't have it, some test 
# cases may fail and you can't read files from URLs.) 
# XML::Parser::PerlSAX (It's part of libxml-perl. You need at least version 0.06. 
# set a DEFAULT input file name
my $in_file = 'C:\Documents and Settings\Geoff McLane\Desktop\Maroc - June, 2008.flash\imagelist.xml';
my $in_tag = 'size_0';
###my $in_file = 'F:\FG0910-4\flightgear\projects\VC8\FlightGear.sln';
###my $in_tag = 'File';

my $cnt = 0;
# log file stuff
my ($LF);
my $outfile = 'temp'.$0.'.txt';
open_log($outfile);
###prt( "$0 .. Hello, World...\n" );

#use XML::DOM;
# Read and parse the document
#my $parser = new XML::DOM::Parser;
#my $doc = $parser->parsefile ("filename");

my $parser = XML::DOM::Parser->new();
my $doc = $parser->parsefile($in_file);
$cnt = 0;
my @files = $doc->getElementsByTagName($in_tag);
##foreach my $file ($doc->getElementsByTagName($in_tag)) {
foreach my $file (@files) {
	$cnt++;
  #print $species->getElementsByTagName('common-name')->item(0)
  #          ->getFirstChild->getNodeValue;
  #print ' (' . $species->getAttribute('name') . ') ';
  #print $species->getElementsByTagName('conservation')->item(0)
  #          ->getAttribute('status');
  if ($cnt < 4) {
	  my $ncnt = scalar @$file;
	  #prt( "File # = [".@$file."]\n" );
	  prt( "File # = [".$ncnt."]\n" );	# count of node list
	  #prt( "Node \$ = [".$$file[$ncnt - 1]."]\n" );
	  prt( "Node \$ = [".$$file[-1]."]\n" );
	  prt( "Node getTextContents = [".getTextContents($file,1)."]\n" );
	  prt( "Node \$ = [".traverse_node(0, $file)."]\n" );
	  #foreach my $nd (@$file) {
	  #if ($nd->getNodeType() == TEXT_NODE) {
		  #prt( "Node T = [".$nd->getData()."]\n" );
	  #}
  }
}

prt( "Got $cnt files ...\n" );
my $document_root  = $doc->getDocumentElement();
my $config_node = $document_root->getFirstChild();
$cnt = 0;
foreach my $node ( $config_node->getChildNodes() ) {
	if ($cnt < 5) {
		prt( "Name = ".$node->getName()."\n");
   }
   $cnt++;
}
prt( "Got $cnt nodes ...\n" );

#my $res = findNode($config_node, 'size_1');
#if (defined $res) {
#	prt( "Defined\n" );
#} else {
#	prt( "UNDEFINED!\n" );
#}

# my @matching_tags = $start_node->getElementsByTagName("my_tag");
# my $first_match = $matching_tags[0];
# foreach my $match (@matching_tags) { do_something; }
close_log($outfile,1);
exit(0);

######################
sub is_element_node {
	my ($node) = @_;
	if ($node->getNodeType == ELEMENT_NODE) {
		return 1;
	}
	return 0;
}

sub getTextContents {
	my ($node, $trim)= @_;
	my $contents = '';

	if (! $node ) {
		return "";
	}

	for my $child ($node->getChildNodes()) {
		if ( ! is_element_node($child) ) {
			$contents .= $child->getData();
		}
	}

  if ($trim) {
    $contents =~ s/^\s+//;
    $contents =~ s/\s+$//;
  }

  return $contents;
}

sub findNode {
	my ($node, $xpath) = @_;
	if (! defined($node) || ! defined($xpath) ) {
		return undef;
	}
	my $match = ($node->xql($xpath))[0];
	if (! $match ) {
		return undef;
	}
	return $match;
}

sub getValue {
  my ($node, $xpath) = @_;
  my $match = findNode( $node, $xpath );
  if (! defined($match) ) {
    return undef;
  }
  return getTextContents( $match );
}

sub setValue {
	my ($node, $xpath, $value) = @_;
	my $match = findNode( $node, $xpath );
	if (! defined($match) ) {
		return undef;
	}
  
	foreach my $child ( $match->getChildNodes() ) {
		$match->removeChild ($child);
	}

	$match->addText($value);

	return $match;
}

sub traverse_node {
	my ($all, $node)= @_;
	my $txt = '';
	if ($node->getNodeType == ELEMENT_NODE) {
		if ($all) {
			$txt .= "<". $node->getNodeName. ">";
		}
	    foreach my $child ($node->getChildNodes()) {
			$txt .= traverse_node($all, $child);
		}
		if ($all) {
			$txt .= "</". $node->getNodeName. ">\n";
		}
	} elsif ($node->getNodeType() == TEXT_NODE) {
		$txt .= $node->getData;
	}
	return $txt
}

sub appendText {
	my ($doc, $match, $nodename, $value) = @_;
	if (! $match) {
		return undef;
	}
	my $newnode;
	eval {
		$newnode = $doc->createElement( $nodename );
	};

	if ($@ || (! defined($newnode) )) {
		return undef;
	}

	$match->appendChild( $newnode );

	if ( defined($value) ) {
		$newnode->addText($value);
	}

	return $newnode;
}

sub appendNode {
	my ($doc, $nodename, $xpath, $value) = @_;

	if (! defined($nodename) || ($nodename eq "") ) {
		return undef;
	}

	my $match = findNode( $doc, $xpath );
	if (! defined($match) ) {
		return undef;
	}

	my $newnode;
	eval {
		$newnode = $doc->createElement( $nodename );
	};

	if ($@ || (! defined($newnode) )) {
		return undef;
	}

	$match->appendChild( $newnode );

	if ( defined($value) ) {
		$newnode->addText($value);
	}

	return $newnode;
}

# eof
