#!/perl -w
# NAME: xmldom02.pl
# AIM: Like xmldom01.pl, some more experiments with XML::DOM ...
use strict;
use warnings;
use XML::DOM;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
###prt( "$0 ... Hello, World ...\n" );
###my $in_file = 'C:\Documents and Settings\Geoff McLane\Desktop\Maroc - June, 2008.flash\imagelist.xml';
###my $in_tag1 = 'Image';
###my $in_tag2 = 'size_0';
my $in_file = 'C:\FG\29\Atlas-0.4.9\projects\msvc\mapserv.xml';
my $in_tag1 = 'Layers';
my $in_tag2 = 'TileSet';
my $out_file = 'tempimagelist.xml';

my $do_image_tag = 0;

# forward refs
sub traverse_node($$);

sub traverse_node($$) {
	my ($all, $node)= @_;
	my $txt = '';
	if ($node->getNodeType == ELEMENT_NODE) {
		if ($all) {
			$txt .= "<". $node->getNodeName. ">";
		}
	    foreach my $child ($node->getChildNodes()) {
			$txt .= traverse_node($all, $child);
		}
		if ($all) {
			$txt .= "</". $node->getNodeName. ">\n";
		}
	} elsif ($node->getNodeType() == TEXT_NODE) {
		$txt .= $node->getData;
	}
	return $txt
}

if (! -f $in_file) {
    prt("ERROR: Can NOT find file [$in_file]!\n");
    exit(1);
}

my $parser = XML::DOM::Parser->new();
my $doc = $parser->parsefile($in_file);

my $cnt = 0;
my @files = $doc->getElementsByTagName($in_tag2);

foreach my $file (@files) {
	$cnt++;
	if ($cnt < 5) {
		prt( "$cnt: $in_tag2 = [".traverse_node(1, $file)."]\n" );
	} else {
		###prt( "." );
	}
}
prt( "\nUsing tag $in_tag2, found $cnt files ...\n\n" );

my @images = $doc->getElementsByTagName($in_tag1);
$cnt = 0;
foreach my $chd (@images) {
	foreach my $cnode ( $chd->getChildNodes() ) {
		$cnt++;
		if ($cnt < 5) {
			my $nt = trim_all(traverse_node(1, $cnode));
			###prt( "$cnt: text = [".traverse_node(1, $cnode)."]\n" );
			prt( "$cnt: text = [".$nt."]\n" ) if (length($nt));
		}
	}
}
prt( "\nUsing tag $in_tag1, found $cnt nodes ...\n\n" );

if ($do_image_tag) {
    $cnt = 0;
    foreach my $images ($doc->getElementsByTagName('Image')) {
        $cnt++;
        if ($cnt < 5) {
            prt("size_0: ".$images->getElementsByTagName('size_0')->item(0)->getFirstChild->getNodeValue . "\n");
            prt("size_2: ".$images->getElementsByTagName('size_2')->item(0)->getFirstChild->getNodeValue . "\n");
            #prt("info:   ".$images->getElementsByTagName('info')->item(0)->getFirstChild->getNodeValue . "\n");
            ##my $inf = $images->getElementsByTagName('info');
            my $inf = $images->getElementsByTagName('info')->item(0);
            ##my $inf = $images->getElementsByTagName('info')->item(0)->getFirstChild;
            my $val = "This is $cnt node";
            if (defined $inf) {
                $inf->addText($val);
                #if( setTextValue( $inf, $val ) ) {
                    prt( "Text added ...\n");
                #} else {
                #	prt( "Text failed 1...\n" );
                #}
            } else {
                if ($inf = appendText($doc, $images, 'info', $val)) {
                    prt( "Text appended ...\n");
                } else {
                    prt( "Text failed 2...\n" );
                }
            }
        }
    }

    prt( "\nUsing tag Image, found $cnt nodes ...\n\n" );
}

my $newtxt = $doc->toString();
#prt( "Output ...\n".$newtxt."\n" );
write2file($newtxt, $out_file);
prt( "Written $out_file ...\n" );
close_log($outfile,1);
exit(0);
###############################

sub appendText {
	my ($doc, $match, $nodename, $value) = @_;
	if (! $match) {
		return undef;
	}
	my $newnode;
	eval {
		$newnode = $doc->createElement( $nodename );
	};

	if ($@ || (! defined($newnode) )) {
		return undef;
	}

	$match->appendChild( $newnode );

	if ( defined($value) ) {
		$newnode->addText($value);
	}

	return $newnode;
}

sub setTextValue {
  my ($match, $value) = @_;
  if (! defined($match) ) {
	  return undef;
  }
  
  #foreach my $child ( $match->getChildNodes() ) {
	#  $match->removeChild ($child);
  #}

  $match->addText($value);

  return $match;
}


# eof
