#!/Perl
# XPath information
# Looking at tree-based options
# Four popular modules do tree-based processing of XML with Perl, 
# each with slightly different goals and histories:
# DOM
# Grove
# Twig
# XML::Simple
print "Hello, World...\n";
# $sometag->getFirstChild()->getData();
# my @results = $document_root->getElementsByTagName("name");

# SAX mail - A simple SAX handler that sends e-mail

use strict;
use XML::Parser::PerlSAX;

my $handler = SAXMailHandler->new();
my $parser = XML::Parser::PerlSAX->new(Handler => $handler);
my $file = "mail.xml";

my %parser_args = (Source => {SystemId => $file});
$parser->parse(%parser_args);

exit;

# begin the in-line package
package SAXMailHandler;
use strict;
use Mail::Sendmail;

my (%mail_args, $current_element, $message_count, $sent_count);

sub new {
    my $type = shift;
    return bless {}, $type;
}

sub not_used {
$document_root  = $dom_document->getDocumentElement();
 my $config_node = $document_root->getFirstChild();
 foreach my $node ( $config_node->getChildNodes() ) {
   if ( $node->getName() eq "header") {
     # do something
   }
 }
}

sub getTextContents {
  my ($node, $strip)= @_;
  my $contents;

  if (! $node ) 
  { 
    return; 
  }
  for my $child ($node->getChildNodes()) {
    if ( ! is_element_node($child) ) {
       $contents .= $child->getData();
    }
  }

  if ($strip) {
    $contents =~ s/^\s+//;
    $contents =~ s/\s+$//;
  }

  return $contents;
}

sub findNode {
  my ($node, $xpath) = @_;
  if (! defined($node) || ! defined($xpath) )
  {
    return undef;
  }
  my $match = ($node->xql($xpath))[0];
  if (! $match )
  {
    return undef;
  }
  return $match;
}

sub getValue {
  my ($node, $xpath) = @_;
  my $match = findNode( $node, $xpath );
  if (! defined($match) )
  {
    return undef;
  }
  return getTextContents( $match );
}
