#!/perl -w
# NAME: ExtUtils02.pl
# AIM: To Enumerate the keys and values in 
use strict;
use warnings;
use ExtUtils::MakeMaker::Config;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...Enumerating \%Config hash ...\n" );

my $mincnt = 6;
my $kcnt = scalar keys(%Config);
prt( "Has $kcnt keys ...\n" );
my $cnt = 0;
my $key = '';
my $val = '';
my $maxkl = 0;
my $msg = '';
my $msglen = 0;
my $valcnt = 0;
foreach $key (keys %Config) {
    $maxkl = length($key) if (length($key) > $maxkl);
}

foreach $key (sort keys %Config) {
    $val = $Config{$key};
    $cnt++;
    $msg = "$cnt: ";
    $msglen = $mincnt;
    $msg = (' '.$msg) while (length($msg) < $msglen);
    $msg .= $key;
    $msglen += $maxkl;
    $msg .= ' ' while (length($msg) < $msglen);
    $msg .= ' => ';
    if ($val) {
        $msg .= $val;
        $valcnt++;
    } else {
        $msg .= '<no value>';
    }
    prt( "$msg\n" );
}
prt( "Done $kcnt keys ... $valcnt with value ...\n" );
$cnt = 0;
foreach $key (sort keys %Config) {
    $val = $Config{$key};
    if ($val) {
        $cnt++;
        $msg = "$cnt: ";
        $msglen = $mincnt;
        $msg = (' '.$msg) while (length($msg) < $msglen);
        $msg .= $key;
        $msglen += $maxkl;
        $msg .= ' ' while (length($msg) < $msglen);
        $msg .= ' => ';
        $msg .= $val;
        prt( "$msg\n" );
    }
}
prt( "Done $valcnt keys with value ...\n" );

close_log($outfile,1);
exit(0);

# eof - ExtUtils02.pl

