#!/perl -w
# NAME: Tidy01.pl
# AIM: To test a little, the HTML::Tidy interface ...
use strict;
use warnings;
use HTML::Tidy;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...Testing HTML::Tidy ...\n" );

my $err_file = "temperrors.txt";
my $out_file = "temp.tidied.htm";

my $doc = <<"End_of_doc;";
<html>
<head>
  <title>foo</title>
</head>
<body>
  <p>Hello Tidy!</p>
</body>
</html>
End_of_doc;

# get a new document ...
my $tidy = HTML::Tidy::Document->new();
if (! $tidy) {
    mydie( "ERROR: Failed to load HTML::Tidy ... $! ...\n" );
} else {
    prt( "Got new Tidy document ...\n" );
}

my $stat = $tidy->Create(); # create a context ...
if ($stat < 0) {
    mydie( "ERROR: Failed to Create HTML::Tidy ... $! ...\n" );
} else {
    prt( "Created new context ...\n" );
}

$stat = $tidy->SetErrorFile( $err_file );
if ($stat < 0) {
    mydie( "ERROR: Failed to set error file ... $! ...\n" );
} else {
    prt( "Set error file to $err_file ...\n" );
}

$stat = $tidy->ParseString($doc);
if ($stat < 0) {
    mydie( "ERROR: ParseString Failed ... $! ...\n" );
} else {
    prt( "Parsed string [$doc] ...\n" );
}

$stat = $tidy->CleanAndRepair();
if ($stat < 0) {
    mydie( "ERROR: CleanAndRepair Failed ... $! ...\n" );
} else {
    prt( "Done clean and repare ...\n" );
}

$stat = $tidy->RunDiagnostics();
if ($stat < 0) {
    mydie( "ERROR: RunDiagnostics Failed ... $! ...\n" );
} else {
    prt( "Ran diagnostics ...\n" );
}

$stat = $tidy->SaveFile( $out_file );
if ($stat < 0) {
    mydie( "ERROR: SaveFile Failed ... $! ...\n" );
} else {
    prt( "Tidied text written to $out_file ...\n" );
}

$tidy->Release();

prt( "Loading output into default browser ...\n" );

system ( $out_file );

close_log($outfile,0);
exit(0);

# eof
