#!/perl -w
# NAME: analwarn.pl
# AIM: specialized reading of the MSVC 'warning' list, and sort them into groups
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $in_file = 'C:\FG\22\tempwarn.txt';
my %cerrs = ();
my %cwarns = ();
my @warnings = ();
my $verb3 = 0;

process_file( $in_file );


close_log($outfile,1);
exit(0);

############################

sub process_file {
	my $inf = shift;
	my @lines = ();
	my @list = ();
	my @slist = ();
	my ($lncnt, $line, $num, $ecnt, $key, $val, $warn, $comp, $ind, $i);
	if (open INF, "<$inf") {
		@lines = <INF>;
		close INF;
		$lncnt = scalar @lines;
		prt( "Processing $lncnt line from $inf ...\n" );
		$ecnt = 0;
		foreach $line (@lines) {
			chomp $line;
			if ($line =~ /\s+warning C(\d\d\d\d):/) {
				$num = $1;
				$ecnt++;
				prt( "$ecnt: $num: $line\n" );
				if (defined $cerrs{$num}) {
					$cerrs{$num}++;
				} else {
					$cerrs{$num} = 1;
					$warn = "warning C$num:";
					$ind = index( $line, $warn );
					if ($ind > 0) {
						$comp = substr( $line, ($ind + length($warn)) );
					} else {
						$comp = "WARNING: Did NOT file [$warn] in [$line]!";
						prtw( $comp );
					}
					$cwarns{$num} = $comp;
				}
			}
		}
		prt( "Found $ecnt warnings ...\n" );
		foreach $key (keys %cerrs) {
			$val = $cerrs{$key};
			$comp = $cwarns{$key};
			prt( "$key $val $comp\n" );
			push(@list, [$val, $key, $comp]);
		}
		@slist = sort mycmp_decend @list;
		$lncnt = scalar @slist;
		prt( "Sorted list if $lncnt items ...\n" );
		for ($i = 0; $i < $lncnt; $i++) {
			$val = $slist[$i][0];
			$num = $slist[$i][1];
			$comp = $slist[$i][2];
			prt( "$val $num $comp\n" );
		}
	} else {
		prt( "ERROR: Unable to open $inf ... $! ...\n" );
	}
}

sub prtw {
	my ($msg) = shift;
	push(@warnings,$msg);
	prt( "$msg\n" );
}

sub mycmp_decend {
	if (${$a}[0] < ${$b}[0]) {
		prt( "+[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
		return 1;
	}
	if (${$a}[0] > ${$b}[0]) {
		prt( "-[".${$a}[0]."] > [".${$b}[0]."]\n" ) if $verb3;
		return -1;
	}
	prt( "=[".${$a}[0]."] = [".${$b}[0]."]\n" ) if $verb3;
	return 0;
}

# eof
