#!perl -w
# NAME: ansicolor.pl
# AIM: Test some ANSI coloring - ANSI color sequences
# 12/12/2008 geoff mclane http://geoffair.net/mperl
use strict;
use Win32::Console::ANSI;
use Term::ANSIColor;
# colors, from Term::ANSIColor; module
# clear, reset, bold, dark, underline, underscore, blink, reverse,
# concealed, black, red, green, yellow, blue, magenta, cyan, white,
# on_black, on_red, on_green, on_yellow, on_blue, on_magenta, on_cyan, and
# on_white
print color 'bold blue on_yellow';
print "This text is bold blue on yellow.\n";
print color 'reset';
# but color can also be generated by ANSI escape sequences, like ... see table below
my $clr_lblueb = "\033[36;1m";
my $clr_yell = "\033[33m";
my $clr_blue = "\033[34m";
my $clr_blueb = "\033[34;1m";
my $clr_norm = "\033[m";
my $clr_bold = "\033[1m";
my $clr_byellb = "\033[43;1m";
my $clr_byell = "\033[43m";
my $clr_bwhite = "\033[47m"; # = set background color to white
my $clr_bred = "\033[41m";
my $clr_yellb = "\033[33;1m";
print "$clr_bold$clr_blue$clr_byell";   # set BOLD, blue, with yellow background
print "This text is bold blue on yellow, again.\n"; # out the text
print "$clr_norm";  # clear attributes
# or all in one line
print $clr_lblueb."This should be bold (highlighed) light blue (cyan).".$clr_norm."\n";
print $clr_blueb."This should be bold (highlighed) blue.".$clr_norm."\n";
print $clr_blue.$clr_bwhite."And just plain blue, on white.".$clr_norm."\n";
print $clr_byellb,"This should be bold white (highlighed) on background yellow.",$clr_norm,"\n";
print $clr_yell,$clr_bold,"This should be bold (highlighed) yellow.",$clr_norm,"\n";
print $clr_yell,"This should be low yellow.",$clr_norm,"\n";
print $clr_bred,$clr_yellb,"This should be high yellow, on red background",$clr_norm,"\n";
print "But this should be back to white on black.\n\n";
# Code = Meaning
# [0m  = reset; clears all colors and styles (to white on black)
# [1m  = bold on (see below)
# [3m  = italics on
# [4m  = underline on
# [7m  = inverse on; reverses foreground & background colors
# [9m  = strikethrough on
# [22m = bold off (see below)
# [23m = italics off
# [24m = underline off
# [27m = inverse off
# [29m = strikethrough off
# [30m = set foreground color to black
# [31m = set foreground color to red
# [32m = set foreground color to green
# [33m = set foreground color to yellow
# [34m = set foreground color to blue
# [35m = set foreground color to magenta (purple)
# [36m = set foreground color to cyan
# [37m = set foreground color to white
# [39m = set foreground color to default (white)
# [40m = set background color to black
# [41m = set background color to red
# [42m = set background color to green
# [43m = set background color to yellow
# [44m = set background color to blue
# [45m = set background color to magenta (purple)
# [46m = set background color to cyan
# [47m = set background color to white
# [49m = set background color to default (black)
# 

# eof - ansicolor.pl
