#!C:\Perl -w
# NAME: ascii.pl
# AIM: Ouput an ASCII 255 character chart
# 12/12/2008 - Added OCTAL, and wrap on 4, if ANY parameter added
# and added header lines
my ($i);
my $addoctal = 0;
my $wrap = 8;
my $rows = 8;
if (@ARGV) {
    $addoctal = 1;
    $wrap = 4;
    print "Dec c Hx Oct Dec c Hx Oct Dec c Hx Oct Dec c Hx Oct\n";
} else {
    print "Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx\n";
}
my $row = 0;
for ($i = 1; $i < 256; $i++) {
	print sprintf( "%03d ", $i );
	if ($i == 0) {
		print "z ";
	} elsif ($i == 8 ) {
		print "d ";
	} elsif ($i == 9 ) {
		print "9 ";
	} elsif ($i == 7 ) {
		print "b ";
	} elsif ($i == 10 ) {
		print "c ";
	} elsif ($i == 13 ) {
		print "l ";
	} else {
		print sprintf( "%c ", $i );
	}
	print sprintf( "%02X ", $i );

    if( $addoctal ) {
        print sprintf( "%03o ", $i );
    }

	if ($i && (($i % $wrap) == 0)) {
		print "\n";
        $row++;
        if ($row >= $rows) {
            $row = 0;
            if ($addoctal) {
                print "Dec c Hx Oct Dec c Hx Oct Dec c Hx Oct Dec c Hx Oct\n";
            } else {
                print "Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx\n";
            }
        }
	}
}
print "\n";

if ($addoctal) {
    print "Dec c Hx Oct Dec c Hx Oct Dec c Hx Oct Dec c Hx Oct\n";
} else {
    print "Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx Dec c Hx\n";
}

# eof - ascii.pl
