#!/Perl
# 
use strict;
use Cwd;
use Win32::OLE qw(in with);

my ($file, $tag, $bnode, $att);
my $dobook = 1;

if ($dobook) {
	$file = "books.xml";
	$tag = "author";
	$bnode = "//book";
	$att = "id";
} else {
	$file = "c:\\fgcvs\\flightgear\\source\\projects\\vc8\\flightgear.vcproj";
	$bnode = "//Files";
	$tag = "File";
	$att = "RelativePath";
}


my $cnt = 0;
my $ccnt = 0;
my ($LOG);
my $write_log = 0;
my $outfile = 'tempxml.txt';
if ( open( $LOG, ">$outfile" ) ) {
    $write_log = 1;
} else {
    $write_log = 0;
    prt( "WARNING: Unable to open $outfile LOG ...\n" );
}

prt( "$0 - Hello, World...\n" );

my $xmlDoc = Win32::OLE->new('MSXML2.DOMDocument.3.0') or mydie( "new() failed" );

$xmlDoc->{async} = "False";
$xmlDoc->{validateOnParse} = "False";

prt( "Loading $file document as XML ...\n" );
$xmlDoc->load($file) or mydie( "Failed to load $file ...\n" );

prt("\nUsing getElementsByTagName($tag) ...\n" );
my $objNodeList = $xmlDoc->getElementsByTagName($tag);
my $ncnt = 0; ## keys( %$objNodeList );
foreach my $node (in $objNodeList ) {
	$ncnt++;
}
prt( "Got $ncnt nodes for tag $tag ...\n" );
$cnt = 0;
foreach my $node (in $objNodeList ) {
	my $txt = $node->{Text};
	my $id = $node->getAttribute($att);
	$cnt++;
	if (length($id) > 0 ) {
		prt( "$cnt <$tag $att=\"$id\">$txt</$tag>\n" );
	} else {
		prt( "$cnt <$tag>$txt</$tag>\n" );
	}
	show_node( $node, 1 );
}

prt("\nGetting single node [$bnode] ... and show node ...\n");
my $nodeBook = $xmlDoc->selectSingleNode($bnode); # "//book"
$cnt = 1;
show_node($nodeBook, 1);

prt("\nGetting all nodes [$bnode] ...\n");
my $nodeBooks = $xmlDoc->selectNodes($bnode); # "//book"
$cnt = 0;
foreach my $node (in $nodeBooks) {
	$cnt++;
	my $id = $node->getAttribute($att); # "id"
	if( length($id) > 0 ) {
		prt( "<$bnode $att=\"$id\" />\n" );
	} else {
		prt( "Got NO $att attribute ...\n" );
	}
	show_node($node, 1);
}

prt( "\nEnumerate ALL nodes of document ...\n" );
my $allNodes = $xmlDoc->selectNodes("*");
$cnt = 0;
foreach my $node (in $allNodes) {
	$cnt++;
	show_node($node);
}
prt( "Done ...\n" );

prt( "\nGetting document root ...\n" );
my $root = $xmlDoc->documentElement();
$cnt = 0;
show_node($root, 1);

prt( "\nEnumerate root->childNodes document ...\n" );
my $nodeList = $root->childNodes();
foreach my $node (in $nodeList) {
	$cnt++;
	prt("\n$cnt SHOW NODE ...\n");
	show_node($node, 1);
	$ccnt = 0;
	if (my $cn = $node->childNodes()) {
		foreach my $nn (in $cn) {
			$ccnt++;
			prt( "$ccnt - SHOWING CHILD ...\n" );
			show_node($nn, 1);
		}
	}
}
prt( "Done ...\n" );

###############################################################
### services only below
#######################

sub show_node {
	my ($nd, $lev) = @_;
	my $xml = $nd->xml();
	my $id = $nd->getAttribute($att); # "id"
	my $txt = $nd->{Text};
	my $val = $nd->value();
	my $tn = $nd->tagName();
	if (length($tn) > 0) {
		prt("$cnt tagName=[$tn]\n");
	}
	if (length($txt) > 0) {
		prt("$cnt txt=[$txt]\n");
	}
	if (length($id) > 0) {
		prt("$cnt $att=\"$id\"\n");
	}
	if (length($val) > 0) {
		prt("$cnt val=[$val]\n");
	}
	if (length($xml)) {
		prt("$cnt xml=[$xml]\n");
	}

	if ($lev > 5) {
		return;
	}
	my $cn = $nd->firstChild();
	if ($cn) {
		prt("$cnt HAS FIRST CHILD!\n");
		show_node($cn, $lev+1);
	} else {
		prt("$cnt HAS NO CHILDREN!\n");
	}
	#if (my $cn = $nd->childNodes()) {
	#	foreach my $nn (in $cn) {
	#		show_node($nn, ($lev+1));
	#	}
	#}
}

################################
### output and log file
sub wlog {
	my $ml = shift;
	print $LOG $ml;
}

sub prt {
	my $m = shift;
	if ($write_log) {
		wlog($m);
	}
	print $m;
}

sub mydie {
	my $msg = shift;
	if ($write_log) {
		wlog($msg);
	}
	die $msg;
}
