#!/usr/bin/perl -w
# NAME: chkgdal.pl
# AIM: VERY SPECIFIC scan of bldlog file after gdal build
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2012-01-06";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_xml = '';
my $src_dir = '';

my $debug_on = 1;
my $def_file = 'C:\Projects\workspace\win-gdal\bldlog-1.txt';
my $def_src = 'c:\FG\16\gdal-1.9.1';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub scan_dir($$$$);

sub scan_dir($$$$) {
    my ($dir,$rh,$rhf,$lev) = @_;
    my @dirs = ();
    my ($ff,$file);
    prt("Scanning directory [$dir]\n") if ($lev == 0);
    if (opendir(DIR,$dir)) {
        my @files = readdir(DIR);
        closedir(DIR);
        ut_fix_directory(\$dir);
        ${$rh}{$dir} = 1;
        foreach $file (@files) {
            next if ($file eq '.');
            next if ($file eq '..');
            $ff = $dir.$file;
            if (-d $ff) {
                push(@dirs,$ff);
            } elsif (-f $ff) {
                ${$rhf}{$ff} = 1;
            }
        }
    }
    foreach $file (@dirs) {
        scan_dir($file,$rh,$rhf,$lev+1);
    }
    if ($lev == 0) {
        @dirs = keys(%{$rh});
        $ff = scalar @dirs;
        $lev = scalar keys(%{$rhf});
        prt("Done scan of [$dir], collecting $ff directories, and $lev files...\n");
    }
}

sub find_matching_dir($$$) {
    my ($dir,$rh,$rdir) = @_;
    my ($file);
    foreach $file (keys %{$rh}) {
        if ($file =~ /(\\|\/)$dir(\\|\/)$/) {
            $file =~ s/(\\|\/)$//;
            ${$rdir} = $file;
            return 1;
        }
    }
    return 0;
}

sub find_matching_file($$$) {
    my ($dir,$rh,$rdir) = @_;
    my ($file);
    foreach $file (keys %{$rh}) {
        if ($file =~ /(\\|\/)$dir$/i) {
            ${$rdir} = $file;
            return 1;
        }
    }
    return 0;
}


sub sub_src_dir($) {
    my $ff = shift;
    my $len = length($src_dir);
    my $len2 = length($ff);
    if ($len && (-d $src_dir) && ($len2 > ($len+1))) {
        $ff = substr($ff,$len+1);
    }
    return $ff;
}

# EG 2430: Missed source [cl /nologo /MD /EHsc /Ox 
# /D_CRT_SECURE_NO_DEPRECATE /D_CRT_NONSTDC_NO_DEPRECATE /DNDEBUG 
# /W4 /wd4127 /wd4251 /wd4275 /wd4786 /wd4100 /wd4245 /wd4206 /wd4018 /wd4389 
# -I..\..\port -I..\..\ogr -I..\..\gcore -I..\..\alg -I..\..\ogr\ogrsf_frmts -Isdk -I..\jpeg\libjpeg
# -DOGR_ENABLED -DPCIDSK_INTERNAL -DHAVE_LIBJPEG  /c sdk\segment\cpcidskads40model.cpp 
# /Fosdk\segment\cpcidskads40model.obj] CHECK ME!
sub get_flags_and_source($$$$) {
    my ($lnn,$line,$rflags,$rsrc) = @_;
    my @arr = space_split($line);
    my $max = scalar @arr;
    my ($i,$itm,$flag,$src);
    $flag = '';
    $src = '';
    my @srcs = ();
    for ($i = 0; $i < $max; $i++) {
        $itm = $arr[$i];
        next if ($itm eq 'cl');
        if (($itm =~ /^\//) || ($itm =~ /^-/)) {
            next if ($itm =~ /^\/Fo/);
            $flag .= ' ' if (length($flag));
            $flag .= $itm;
        } elsif (is_c_source($itm)) {
            #if (length($src)) {
            #    prtw("WARNING:$lnn: Found 2nd source in line [$itm]! But already have [$src]\n line [$line]\n");
            #}
            push(@srcs,$itm);
            $src = $itm;
        } elsif ($itm =~ /\.lib$/i) {
            # ignore .lib links for the moment
        } else {
            prtw("WARNING:$lnn: Unhandled item [$itm] FIX ME!\n line [$line]\n");
        }
    }
    if (length($flag) && length($src)) {
        ${$rflags} = $flag;
        #${$rsrc}   = $src;
        push(@{$rsrc},@srcs);
        return 1;
    }
    return 0;
}

sub in_excluded_defines($) {
    my $def = shift;
    my @xdefs = qw(_CRT_NONSTDC_NO_DEPRECATE _CRT_SECURE_NO_DEPRECATE _USE_MATH_DEFINES WIN32 NDEBUG
        _CRT_SECURE_NO_WARNINGS _SCL_SECURE_NO_WARNINGS __CRT_NONSTDC_NO_WARNINGS );
    my ($d);
    foreach $d (@xdefs) {
        return 1 if ($d eq $def);
    }
    return 0;
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($name,$dir) = fileparse($inf);
    $dir = '' if ($dir =~ /^\.(\\:\/)$/);
    my %dirs = ();
    my %dfiles = ();
    if ((length($src_dir))&&(-d $src_dir)) {
        $dir = $src_dir;
        scan_dir($dir,\%dirs,\%dfiles,0);
    }
    ut_fix_directory(\$dir);
    my ($line,$inc,$lnn,$len,$clnn,$form,$ff,$ok,$rel,$cdir,$lenter);
    my (@arr,$line2,$tmp);
    my ($flags,$src,$isinc,$isdef,$iswarn);
    my ($cnt,$i,$gotsrc);
    $lnn = 0;
    $form = '%'.sprintf("%d",length($lncnt)).'d';
    $cdir = $dir;   # first current is SOURCE
    $inc = '';
    my %defd = ();
    my %incd = ();
    my %others = ();
    my %warnd = ();
    my @sources = ();
    my @srcs = ();
    foreach $line (@lines) {
        chomp $line;
        $line = trim_all($line);
        $len = length($line);
        $lnn++;
        next if ($len == 0);
        $clnn = sprintf($form,$lnn);
        @srcs = ();
        if ($line =~ /^for\s+/) {
            # lines will appear below
        } elsif ($line =~ /\s*cl\s+(.+)$/) {
            if ($line =~ /\s*cl\s+(.+)\s+([\w\.]+)$/) {
                $flags = $1;
                $src = $2;
                push(@srcs,$src);
                $gotsrc = 1;
            } elsif (!($line =~ /\s+\/link\b/) && get_flags_and_source($lnn,$line,\$flags,\@srcs)) {
                $gotsrc = 1;
            } 
            if ($gotsrc) {
                foreach $src (@srcs) {
                    $ff = $cdir.$src;
                    $ok = "NF [$ff]";
                    my ($tn,$td) = fileparse($src);
                    if (-f $ff) {
                        $ok = 'ok';
                        $src = sub_src_dir($ff);
                    } elsif (find_matching_file($tn,\%dfiles,\$tmp)) {
                        $ok = 'ok2';
                        $ff = $tmp;
                        $src = sub_src_dir($tmp);
                    }
                    if ($ok =~ /^ok/) {
                        push(@sources,$src);
                        prt("$clnn: SOURCE: $src $ok\n") if (VERB9());
                        my ($n,$d) = fileparse($ff);
                        @arr = space_split($flags);
                        $cnt = scalar @arr;
                        for ($i = 0; $i < $cnt; $i++) {
                            $tmp = $arr[$i];
                            if (($tmp =~ /^\//)||($tmp =~ /^-/)) {
                                $isinc = 0;
                                $isdef = 0;
                                $iswarn = 0;
                                if ($tmp =~ /^\/I/) {
                                    $tmp =~ s/^\/I//;
                                    $isinc = 1;
                                } elsif ($tmp =~ /^-I/) {
                                    $tmp =~ s/^-I//;
                                    $isinc = 1;
                                } elsif ($tmp =~ /^-D/) {
                                    $tmp =~ s/^-D//;
                                    $isdef = 1;
                                } elsif ($tmp =~ /^\/D/) {
                                    $tmp =~ s/^\/D//;
                                    $isdef = 1;
                                } elsif ($tmp =~ /^\/wd(\d+)$/) {
                                    $tmp = $1;
                                    $iswarn = 1;
                                }

                                if ($isinc) {
                                    # is INCLUDE, maybe relative to HERE
                                    ### $tmp =~ s/^(\/|-)//;
                                    $tmp = $d.$tmp;
                                    $tmp = fix_rel_path($tmp);
                                    $tmp = path_d2u($tmp);
                                    $tmp = sub_src_dir($tmp);
                                    ###$tmp = '-I'.$tmp;
                                    $incd{$tmp} = 1;
                                } elsif ($isdef) {
                                    if (!in_excluded_defines($tmp)) {
                                        $defd{$tmp} = 1;
                                    }
                                } elsif ($iswarn) {
                                    $warnd{$tmp} = 1;
                                } else {
                                    $others{$tmp} = 1;
                                }
                            }
                        }
                    } else {
                        prtw("WARNING: $clnn: NOT FOUND: $src $ok\n"); # if (VERB9());
                    }
                }
            } else {
                if ($line =~ /\s+\/link\b/) {
                    prt("$clnn: Compile and link line\n[$line]!\n");
                } else {
                    prt("$clnn: Missed source [$line] CHECK ME!\n");
                }
            }
        } elsif ($line =~ /cd\s+/) {
            @arr = split("&&",$line);
            foreach $line2 (@arr) {
                if ($line2 =~ /cd\s+/) {
                    if ($line2 =~ /cd\s+([-\.\\\/\w\d]+)\s*/) {
                        $lenter = $inc;
                        $inc = $1;
                        #if (($lenter eq 'gtiff')&&($inc eq '..')) {
                        #    push(@defd,$inc);
                        #    next;
                        #}
                        $rel = $cdir.$inc;
                        $ff = fix_rel_path($rel);
                        $ok = 'NF';
                        if (-d $ff) {
                            $ok = 'ok';
                        } else {
                            $tmp = $cdir.'gtiff'.$PATH_SEP.$inc;
                            $tmp = fix_rel_path($tmp);
                            if (-d $tmp) {
                                $ok = 'ok1';
                                $ff = $tmp;
                            } else {
                                $tmp = $cdir.'..'.$PATH_SEP.$inc;
                                $tmp = fix_rel_path($tmp);
                                if (-d $tmp) {
                                    $ok = 'ok2';
                                    $ff = $tmp;
                                } elsif (find_matching_dir($inc,\%dirs,\$tmp)) {
                                    if (-d $tmp) {
                                        $ok = 'ok3';
                                        $ff = $tmp;
                                    }
                                }
                            }
                        }
                        if ($ok =~ /^ok/) {
                            prt("$clnn:1: cd $inc [$ff] $ok\n") if (VERB9());
                        } else {
                            prt("$clnn:1: cd $inc [$ff] $ok\n");
                        }
                        $cdir = $ff;
                        ut_fix_directory(\$cdir);
                    } else {
                        prt("$clnn:2: $line2\n");
                    }

                }
            }
        }
    }

    my ($msg);
    @arr = sort keys(%defd);
    $cnt = scalar @arr;
    prt("# Got $cnt Defintion compile flags...\n");
    $msg = "add_definitions(\n";
    #prt(join(" ",@arr)."\n");
    $line = '';
    foreach $src  (sort @arr) {
        $line .= ' ' if (length($line));
        $line .= "-D$src";
        if (length($line) > 65) {
            $msg .= "   $line\n";
            $line = '';
        }
    }
    if (length($line)) {
        $msg .= "   $line )\n";
    } else {
        $msg =~ s/\n$//;
        $msg .= " )\n";
    }
    prt($msg);

    @arr = sort keys(%incd);
    $cnt = scalar @arr;
    prt("# Got $cnt Include compile flags...\n");
    $msg = "include_directories(\n";
    $line = '';
    foreach $src (sort @arr) {
        $line .= ' ' if (length($line));
        $line .= $src;
        if (length($line) > 65) {
            $msg .= "   $line\n";
            $line = '';
        }
    }
    if (length($line)) {
        $msg .= "   $line )\n";
    } else {
        $msg =~ s/\n$//;
        $msg .= " )\n";
    }
    prt($msg);

    # foreach(warning 4244 4251 4267 4275 4290 4786 4305)
    #     set(WARNING_FLAGS "\${WARNING_FLAGS} /wd\${warning}")
    # endforeach(warning)
    @arr = sort keys(%warnd);
    $cnt = scalar @arr;
    prt("# Got $cnt disable warnings compile flags...\n");
    $msg = "foreach(warning ".join(" ",@arr)." )\n";
    $msg .= "    set(WARNING_FLAGS \"\${WARNING_FLAGS} /wd\${warning}\")\n";
    $msg .= "endforeach(warning)\n";
    prt($msg);

    @arr = sort keys(%others);
    $cnt = scalar @arr;
    prt("# Got $cnt other compile flags...\n");
    $msg = "other_items(\n";
    $line = '';
    foreach $src (@arr) {
        $line .= ' ' if (length($line));
        $line .= $src;
        if (length($line) > 65) {
            $msg .= "   $line\n";
            $line = '';
        }
    }
    if (length($line)) {
        $msg .= "   $line )\n";
    } else {
        $msg =~ s/\n$//;
        $msg .= " )\n";
    }
    prt($msg);
    
    $cnt = scalar @sources;
    prt("# Found $cnt sources...\n");
    $msg = "set( gdal_SOURCES\n";
    $line = '';
    foreach $src (sort @sources) {
        $line .= ' ' if (length($line));
        $src = path_d2u($src);
        $src .= '"'.$src.'"' if ($src =~ /\s+/);
        $line .= $src;
        if (length($line) > 65) {
            $msg .= "   $line\n";
            $line = '';
        }
    }
    if (length($line)) {
        $msg .= "   $line )\n";
    } else {
        $msg =~ s/\n$//;
        $msg .= " )\n";
    }
    prt($msg);

}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                $load_log = 1;
                prt("Set to load log at end.\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_xml = $sarg;
                prt("Set out file to [$out_xml].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
        prt("Set DEFAULT input to [$in_file]\n");

    }
    if ((length($src_dir) ==  0) && $debug_on) {
        $src_dir = $def_src;
        prt("Set DEFAULT source directory to [$src_dir]\n");
        ###$load_log = 2;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --src dir     (-s) = Set the base source directory.\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
