#!/perl -w
# NAME: chkmanifest.pl
# AIM: Given a MANIFEST file, check that the directory structure and files
# within match that manifest ...
# 07/08/2008 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $in_file = 'C:\DTEMP\Data-Section-0.004\MANIFEST';

prt( "$0 ... Checking $in_file ...\n" );

if (-f $in_file) {
    process_file( $in_file );
} else {
    prt( "Error: Can NOT locate $in_file ... check name, location ...\n" );
}

close_log($outfile,0);
exit(0);
########################################

sub unix_2_dos {
	my ($f) = shift;
	$f =~ s/\//\\/g;
	return $f;
}

sub process_file {
    my ($inf) = shift;
    my (@lines, $line, $lncnt, $nm, $dir, $ext);
    my ($i, @files, $ff, $fnd, $failed);
    ($nm, $dir, $ext) = fileparse( $inf, qr/\.[^.]*/ );
    if (open INF, "<$inf") {
        @lines = <INF>;
        close INF;
        $lncnt = scalar @lines;
        prt( "Processing $lncnt lines from $nm$ext ($dir) ...\n" );
        $fnd = 0;
        $failed = 0;
        for ($i = 0; $i < $lncnt; $i++) {
            $line = unix_2_dos(trim_all($lines[$i]));
            if (length($line)) {
                $ff = $dir.$line;
                if (-f $ff) {
                    prt( "$ff - ok\n" );
                    $fnd++;
                } else {
                    prt( "$ff - NOT FOUND\n" );
                    $failed++;
                }
                push(@files, $ff);
            }
        }
        if ($failed) {
            prt( "Found $fnd, BUT $failed WERE NOT FOUND ...\n" );
        } else {
            prt( "SUCCESS: All $fnd files found ...\n" );
        }
    } else {
        prt( "ERROR: Failed to open $inf ... $! ...\n" );
    }
}

# eof
