#!/perl -w
# NAME: cmparrays.pl
# AIM: VERY SPECIFIC - load a log file, and compare triangle listings
# 09/12/2009 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $load_log = 1;
my $add_try_harder = 0;

my $in_file = 'C:\FG\27\terragear-cs\projects\msvc\temparr.txt';

# debug
my $dbg_01 = 0;   # prt("$typ: $lon1,$lat1,$ele1\n") if ($dbg_01);
my $dbg_02 = 1;   # prt("SAME PT: $lon1,$lat1 ($ele1 vs $ele2) ($i:$j)[$fnd]\n") if ($dbg_02);

my $TYPE_ARR = 1;
my $TYPE_FIT = 2;

# program vars
my $typ_1 = 0;
my $typ_2 = 0;
my $t1_less_than_1 = 0;
my $t2_less_than_1 = 0;


sub process_file($) {
   my ($fil) = @_;
   my @list = ();
   prt("Processing file [$fil]... moment...\n");
   if (open INF, "<$fil") {
      my @lines = <INF>;
      close INF;
      my ($line,$tri,$typ,$v1,$v2,$v3,@arr);
      my ($lat1,$lon1,$lat2,$lon2,$lat3,$lon3,$last_type,$lnn,$max);
      $last_type = 0;
      $lnn = 0;
      $max = scalar @lines;
      prt("Loaded: $max lines to process... moment...\n");
      foreach $line (@lines) {
         $lnn++;
         chomp $line;
         $line = trim_all($line);
         $typ = 0;

         if ($line =~ /^F\s+(.+)$/) {
            $tri = $1;  # like -52.7397,47.6247 -52.7396,47.6247 -52.7398,47.625
            prt("-: $tri\n") if ($dbg_01);
            $typ = $TYPE_FIT;
            $typ_2++;
         } elsif ($line =~ /^A\s+(.+)$/) {
            $tri = $1;  # like -52.7197,47.5581 -52.7158,47.5598 -52.7213,47.5609
            prt("-: $tri\n") if ($dbg_01);
            $typ = $TYPE_ARR;
            $typ_1++;
         } else {
            prt("Unused line [$line]\n");
         }
         if ($typ) {
            if ($last_type != $typ) {
               prt("NT:$typ:$lnn [$line]\n");
               $last_type = $typ;
            }
            @arr = split(" ",$tri);
            if (scalar @arr >= 3) {
               $v1 = $arr[0];
               $v2 = $arr[1];
               $v3 = $arr[2];
               prt("$typ: $v1,$v2,$v3\n") if ($dbg_01);
               push(@list, [$typ,$v1,$v2,$v3,0,0]);
               if ($v3 < 1) {
                  if ($typ == 1) {
                     $t1_less_than_1++;
                  } else {
                     $t2_less_than_1++;
                  }
               }
            } else {
               prt("WARNING: Did not split into 3 or GT! Got ".scalar @arr."\n");
            }
         }
      }
      prt("Done file [$fil]... \ntype 1 (arr) = $typ_1, type 2 (fit) = $typ_2\n");
      prt("Less than 1: arr = $t1_less_than_1, fit = $t2_less_than_1\n");
   } else {
      prt("ERROR: Failed ot open $fil\n");
   }
   return \@list;
}

sub compare_very_near($$$$$$) {
   my ($lon1,$lat1,$ele1,$lon2,$lat2,$ele2) = @_;
   if ( ($lon1 == $lon2) && ($lat1 == $lat2) ) {
      return 1;
   }
   my ($ilon1,$ilat1,$ilon2,$ilat2);
   $ilon1 = int($lon1 * 1000);
   $ilat1 = int($lat1 * 1000);
   $ilon2 = int($lon2 * 1000);
   $ilat2 = int($lat2 * 1000);
   if ( ($ilon1 == $ilon2) && ($ilat1 == $ilat2) ) {
      return 2;
   }

   return 0;
}

sub find_closest_point($$$$$$$) {
   my ($typ, $lon1, $lat1, $ele1, $ra, $max, $off ) = @_;
   my ($i,$dn,$typ2);
   my ($lon2,$lat2,$ele2);
   my ($abslon,$abslat,$diff);
   my $mindist = 9999999;
   my $minoff = 0;
   for ($i = 0; $i < $max; $i++) {
      next if ($i == $off);
      $typ2 = ${$ra}[$i][0];
      next if ($typ == $typ2);
      $lon2 = ${$ra}[$i][1];
      $lat2 = ${$ra}[$i][2];
      $ele2 = ${$ra}[$i][3];
      $abslon = abs($lon1 - $lon2);
      $abslat = abs($lat1 - $lat2);
      $diff = ($abslon + $abslat);
      if ($diff < $mindist) {
         $mindist = $diff;
         $minoff = $i;
      }
   }

   $i = $minoff;
   $typ2 = ${$ra}[$i][0];
   $lon2 = ${$ra}[$i][1];
   $lat2 = ${$ra}[$i][2];
   $ele2 = ${$ra}[$i][3];
   $dn   = ${$ra}[$i][4];
   prt("Closest:$typ2: $lon2,$lat2,$ele2 ($i) done=$dn\n");
}

sub show_ref_arr($) {
   my ($ra) = @_;
   my $max = scalar @{$ra};
   prt("Got list of $max 3D points, type 1 (arr) = $typ_1, type 2 (fit) = $typ_2 to compare...\n");
   my ($typ,$lon1,$lat1,$ele1,$i,$dn1);
   my ($typ2,$lon2,$lat2,$ele2,$j,$dn2);
   my $fnd = 0;
   my $miss = 0;
   my $mtyp1 = 0;
   my $mtyp2 = 0;
   my $cmp = 0;
   #               0    1   2   3   4 5
   #  push(@list, [$typ,$v1,$v2,$v3,0,0]);
   for ($i = 0; $i < $max; $i++) {
      $fnd = 0;
      $typ  = ${$ra}[$i][0];
      $dn1  = ${$ra}[$i][4];
      next if ($dn1);
      next if ($typ == $TYPE_ARR);
      $lon1 = ${$ra}[$i][1];
      $lat1 = ${$ra}[$i][2];
      $ele1 = ${$ra}[$i][3];
      for ($j = 0; $j < $max; $j++) {
         $typ2  = ${$ra}[$j][0];
         $dn2   = ${$ra}[$j][4];
         next if ($typ == $typ2);
         #next if ($dn2);
         $lon2 = ${$ra}[$j][1];
         $lat2 = ${$ra}[$j][2];
         $ele2 = ${$ra}[$j][3];
         $cmp = compare_very_near($lon1,$lat1,$ele1,$lon2,$lat2,$ele2);
         if ($cmp) {
            ${$ra}[$i][4] = ($j + 1);
            ${$ra}[$j][4] = ($i + 1);
            $fnd++;
            prt("SAME PT:$cmp: $lon1,$lat1 ($ele1 vs $ele2) off=$i:$j [$fnd]\n") if ($dbg_02);
         }
      }
      if (!$fnd) {
         $miss++;
         #    Closest:
         prt("NOT FND:$typ: $lon1,$lat1,$ele1 ($i)\n");
         find_closest_point( $typ, $lon1, $lat1, $ele1, $ra, $max, $i );
      }
   }
   if ($add_try_harder) {
      $fnd = 0;
      for ($i = 0; $i < $max; $i++) {
         $dn1  = ${$ra}[$i][4];
         next if ($dn1);
         $typ  = ${$ra}[$i][0];
         $fnd++;
         if ($typ == 1) {
            $mtyp1++;
         } else {
            $mtyp2++;
         }
      }
   }

}

my $ref_arr = process_file($in_file);
show_ref_arr($ref_arr);

close_log($outfile,$load_log);
exit(0);

# eof - cmparrays.pl

