#!/perl -w
# NAME: cmpfgpl.pl
# AIM: Specialized to COMPARE two folders
# 21/11/2008 geoff mclane http://geoffair.net/mperl
# localtime() - a 9-element array with the time analyzed for the local time zone
# my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
#@f = (localtime)[3..5]; # grabs day/month/year values
# printf "%02d/%02d/%02d\n", $f[2] + 1900, $f[1] +1, $f[0] ;
use strict;
use warnings;
use File::stat;
unshift(@INC, 'C:/GTools/perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $in_fold1 = "C:\\FG\\20";
my $in_fold2 = ".";
my @warnings = ();

my %excluded = (
    'fgunused.pl' => 1
);

my @samedate = ();
my @different = ();
my @missing = ();

# debug
my $dbg_s01 = 0;    # show SAME files

parse_args(@ARGV);

prt( "$0 ... Hello, comparing Perl in [$in_fold1], with that in [$in_fold2] ...\n" );

compare_perl_files( $in_fold1, $in_fold2 );

show_missing();

show_warnings(0);

close_log($outfile,1);
exit(0);

################
### SUB ONLY ###

sub show_missing {
    my ($fil);
    foreach $fil (@missing) {
        prt( "copy $fil\n" );
    }
}

sub get_YYYYMMDD_hhmmss {
    my ($tm) = shift;
    my @f = (localtime($tm))[0..5];
    my $m = sprintf( "%04d/%02d/%02d %02d:%02d:%02d", $f[5] + 1900, $f[4] +1, $f[3], $f[2], $f[1], $f[0]);
    return $m;
}

sub get_diff_text {
    my ($inf1, $inf2) = @_;
    my $txt = '';
    if (open DIF, "diff -u $inf1 $inf2 |") {
        my @arr = <DIF>;
        close DIF;
        $txt = join(/\n/,@arr);
    } else {
        $txt = "ERROR: FAILED TO GET DIFF!";
    }
    return $txt;
}


sub compare_files {
    my ($f1,$f2) = @_;
    my $sb1 = stat($f1);
    my $sb2 = stat($f2);
    my ($msg, @f, $dt);
    if ($sb1 && $sb2) {
        if ($sb1->mtime == $sb2->mtime) {
            # same DATE/TIME
            prt( "File: $f1 $f2 SAME DATE/TIME ".get_YYYYMMDD_hhmmss($sb1->mtime)."\n" ) if ($dbg_s01);
            push(@samedate,$f1);
        } else {
            $msg = "file: $f1 dated ";
            $msg .= get_YYYYMMDD_hhmmss($sb1->mtime);
            $msg .= " $f2 dated ";
            $msg .= get_YYYYMMDD_hhmmss($sb2->mtime);
            if ($sb1->mtime < $sb2->mtime) {
                $msg .= " EARLIER";
                $dt = get_diff_text($f1, $f2);
            } else {
                $msg = "file: $f2 dated ";
                $msg .= get_YYYYMMDD_hhmmss($sb2->mtime);
                $msg .= " $f1 dated ";
                $msg .= get_YYYYMMDD_hhmmss($sb1->mtime);
                $msg .= " LATER";
                $dt = get_diff_text($f2, $f1);
            }
            prt( "$msg\n" );
            push(@different,$f1);
            ###$dt = get_diff_text($f1, $f2);
            prt("====================================\n");
            prt("$dt\n");
            prt("====================================\n");
        }
    } else {
        if ($sb1) {
            prtw("WARNING: stat of [$f2] FAILED ...\n");
        } else {
            prtw("WARNING: stat of [$f1] FAILED ...\n");
        }
    }
}

sub compare_perl_files {
    my ($inf1, $inf2 ) = @_;
    my (@dir1, @dir2, $cnt1, $cnt2, $f1, $f2, $ff1, $ff2);
    my %hash1 = ();
    my %hash2 = ();
    prt( "Processing [$inf1], with [$inf2] ...\n" );
    if (opendir(DIR1,$inf1)) {
        @dir1 = readdir(DIR1);
        closedir(DIR1);
        if (opendir(DIR2,$inf2)) {
            @dir2 = readdir(DIR2);
            closedir(DIR2);
            $cnt1 = scalar @dir1;
            $cnt2 = scalar @dir2;
            prt("Comparing $cnt1 with $cnt2 ...\n");
            $cnt1 = 0;
            $cnt2 = 0;
            # build HASH 1
            foreach $f1 (@dir1) {
                next if (($f1 eq '.')||($f1 eq '..'));
                $ff1 = $inf1."\\".$f1;
                next if (-d $ff1);
                next if ($f1 =~ /^temp.*$/);
                next if !($f1 =~ /\.pl$/i);
                next if (defined $excluded{$f1});
                $hash1{$f1} = 1;
                $cnt1++;
            }
            # build HASH 2
            foreach $f2 (@dir2) {
                next if (($f2 eq '.')||($f2 eq '..'));
                $ff2 = $inf2."\\".$f2;
                next if (-d $ff2);
                next if ($f2 =~ /^temp.*$/);
                next if !($f2 =~ /\.pl$/i);
                next if (defined $excluded{$f2});
                $hash2{$f2} = 1;
                $cnt2++;
            }
            prt("Comparing $cnt1, with $cnt2 perl files ...\n");
            # process HASH 1
            # #####################################
            foreach $f1 (keys %hash1) {
                $ff1 = $inf1."\\".$f1;
                if (defined $hash2{$f1}) {
                    $ff2 = $inf2."\\".$f1;
                    compare_files($ff1, $ff2); 
                } else {
                    prt( "FILE: $ff1 is NOT in 1 ...\n" );
                    push(@missing, $ff1);
                }
            }

        } else {
            prtw("WARNING: Cna NOT open $inf2 directory ... $! ...\n");
        }
    } else {
        prtw("WARNING: Can NOT open $inf1 directory ... $! ...\n");
    }
}

sub parse_args {
    my (@av) = @_;
    my $cnt = 0;
    while(@av)
    {
        my $arg = $av[0];
        if ($cnt == 0) {
            $in_fold1 = $arg;
        } elsif ($cnt == 1) {
            $in_fold2 = $arg;
        } else {
            mydie("ERROR: Only 2 arguments allowed, giving folder names ...\n");
        }
        shift @av;
        $cnt++;
    }
}


sub prtw {
    my ($tx) = shift;
    $tx =~ s/\n$// if ($tx =~ /\n$/);
    prt("$tx\n");
    push(@warnings,$tx);
}

sub show_warnings {
    my ($dbg) = shift;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS ...\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } elsif ($dbg) {
        prt("\nNo warnings issued.\n\n");
    }
}

# eof - cmpfgpl.pl
