#!/perl -w
# NAME: cmptriangles.pl
# AIM: VERY SPECIFIC - load a log file, and compare triangle listings
# 06/12/2009 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $load_log = 1;
my $add_try_harder = 0;

my $in_file = 'C:\FG\27\terragear-cs\projects\msvc\temppv.txt';

# debug
my $dbg_01 = 0;   # prt("$typ: $lon1,$lat1 $lon2,$lat2 $lon3,$lat3\n") if ($dbg_01);
my $dbg_02 = 0;   # prt("SAME PT: $lon1,$lat1 $lon2,$lat2 $lon3,$lat3 ($i:$j)[$fnd]\n") if ($dbg_02);

sub get_lat_lon($) {
   my ($ll) = @_;
   my @a = split(",",$ll);
   if (scalar @a == 2) {
      return ($a[0],$a[1]);
   }
   return (0.0,0.0);
}

sub process_file($) {
   my ($fil) = @_;
   my @list = ();
   if (open INF, "<$fil") {
      my @lines = <INF>;
      close INF;
      my ($line,$tri,$typ,$v1,$v2,$v3,@arr);
      my ($lat1,$lon1,$lat2,$lon2,$lat3,$lon3);
      foreach $line (@lines) {
         chomp $line;
         $line = trim_all($line);
         $typ = 0;
         if ($line =~ /^\[V9\]:OutputGL::drawTriangle:\s(.+)$/) {
            $tri = $1;  # like -52.7397,47.6247 -52.7396,47.6247 -52.7398,47.625
            prt("-: $tri\n") if ($dbg_01);
            $typ = 2;
         } elsif ($line =~ /^Triangle:\s+(.+)$/) {
            $tri = $1;  # like -52.7197,47.5581 -52.7158,47.5598 -52.7213,47.5609
            prt("-: $tri\n") if ($dbg_01);
            $typ = 1;
         } elsif ($line =~ /^LTXT 6: STG:OBJECT: loading \[CYYT.btg\]/) {
            prt("Exit on line $line\n");
            last;
         }
         if ($typ) {
            @arr = split(" ",$tri);
            if (scalar @arr == 3) {
               $v1 = $arr[0];
               $v2 = $arr[1];
               $v3 = $arr[2];
               ($lon1,$lat1) = get_lat_lon($v1);
               ($lon2,$lat2) = get_lat_lon($v2);
               ($lon3,$lat3) = get_lat_lon($v3);
               prt("$typ: $lon1,$lat1 $lon2,$lat2 $lon3,$lat3\n") if ($dbg_01);
               push(@list, [$typ,$lon1,$lat1,$lon2,$lat2,$lon3,$lat3,0,0]);
            } else {
               prt("WARNING: Did not split into 3! Got ".scalar @arr."\n");
            }
         }
      }

   } else {
      prt("ERROR: Failed ot open $fil\n");
   }
   return \@list;
}

sub compare_very_near($$$$$$$$$$$$) {
   my ($lon1,$lat1,$lon2,$lat2,$lon3,$lat3,$lon21,$lat21,$lon22,$lat22,$lon23,$lat23) = @_;
   if ( ($lon1 == $lon21) && ($lat1 == $lat21) &&
        ($lon2 == $lon22) && ($lat2 == $lat22) &&
        ($lon3 == $lon23) && ($lat3 == $lat23) ) {
      return 1;
   }
   my ($ilon1,$ilat1,$ilon2,$ilat2,$ilon3,$ilat3,$ilon21,$ilat21,$ilon22,$ilat22,$ilon23,$ilat23);
   $ilon1 = int($lon1 * 1000);
   $ilat1 = int($lat1 * 1000);
   $ilon2 = int($lon2 * 1000);
   $ilat2 = int($lat2 * 1000);
   $ilon3 = int($lon3 * 1000);
   $ilat3 = int($lat3 * 1000);
   $ilon21 = int($lon21 * 1000);
   $ilat21 = int($lat21 * 1000);
   $ilon22 = int($lon22 * 1000);
   $ilat22 = int($lat22 * 1000);
   $ilon23 = int($lon23 * 1000);
   $ilat23 = int($lat23 * 1000);
   if ( ($ilon1 == $ilon21) && ($ilat1 == $ilat21) &&
        ($ilon2 == $ilon22) && ($ilat2 == $ilat22) &&
        ($ilon3 == $ilon23) && ($ilat3 == $ilat23) ) {
      return 2;
   }

   return 0;
}

sub not_a_triangle($$$$$$) {
   my ($lon1,$lat1,$lon2,$lat2,$lon3,$lat3) = @_;
   if (($lon1 == $lon2) &&
       ($lon2 == $lon3) &&
       ($lat1 == $lat2) &&
       ($lat2 == $lat3) ){
      return 1;
   }
   my ($ilon1,$ilat1,$ilon2,$ilat2,$ilon3,$ilat3);
   $ilon1 = int($lon1 * 1000);
   $ilat1 = int($lat1 * 1000);
   $ilon2 = int($lon2 * 1000);
   $ilat2 = int($lat2 * 1000);
   $ilon3 = int($lon3 * 1000);
   $ilat3 = int($lat3 * 1000);
   if (($ilon1 == $ilon2) &&
       ($ilon2 == $ilon3) &&
       ($ilat1 == $ilat2) &&
       ($ilat2 == $ilat3) ){
      return 2;
   }
   return 0;
}

sub show_ref_arr($) {
   my ($ra) = @_;
   my $max = scalar @{$ra};
   prt("Got list of $max triangles...\n");
   my ($typ,$lon1,$lat1,$lon2,$lat2,$lon3,$lat3,$i,$dn1);
   my ($typ2,$lon21,$lat21,$lon22,$lat22,$lon23,$lat23,$j,$dn2);
   my $fnd = 0;
   my $miss = 0;
   my $mtyp1 = 0;
   my $mtyp2 = 0;
   # push(@list, [$typ,$lon1,$lat1,$lon2,$lat2,$lon3,$lat3]);
   for ($i = 0; $i < $max; $i++) {
      $fnd = 0;
      $dn1  = ${$ra}[$i][7];
      next if ($dn1);
      $typ  = ${$ra}[$i][0];
      $lon1 = ${$ra}[$i][1];
      $lat1 = ${$ra}[$i][2];
      $lon2 = ${$ra}[$i][3];
      $lat2 = ${$ra}[$i][4];
      $lon3 = ${$ra}[$i][5];
      $lat3 = ${$ra}[$i][6];
      for ($j = 0; $j < $max; $j++) {
         $typ2  = ${$ra}[$j][0];
         $dn2   = ${$ra}[$j][7];
         next if ($typ == $typ2);
         next if ($dn2);
         $lon21 = ${$ra}[$j][1];
         $lat21 = ${$ra}[$j][2];
         $lon22 = ${$ra}[$j][3];
         $lat22 = ${$ra}[$j][4];
         $lon23 = ${$ra}[$j][5];
         $lat23 = ${$ra}[$j][6];
         if (compare_very_near($lon1,$lat1,$lon2,$lat2,$lon3,$lat3,$lon21,$lat21,$lon22,$lat22,$lon23,$lat23) ) {
         #if ( ($lon1 == $lon21) && ($lat1 == $lat21) &&
         #     ($lon2 == $lon22) && ($lat2 == $lat22) &&
         #     ($lon3 == $lon23) && ($lat3 == $lat23) ) {
            ${$ra}[$i][7] = ($j + 1);
            ${$ra}[$j][7] = ($i + 1);
            $fnd++;
            prt("SAME PT: $lon1,$lat1 $lon2,$lat2 $lon3,$lat3 ($i:$j)[$fnd]\n") if ($dbg_02);
         }
      }
      if (not_a_triangle($lon1,$lat1,$lon2,$lat2,$lon3,$lat3)) {
         prt( "A POINT, or close $lon1,$lat1,$lon2,$lat2,$lon3,$lat3\n");
         ${$ra}[$i][7] = -1;
         next;
      }
      if (!$fnd) {
         $miss++;
         prt("NOT FND:$typ: $lon1,$lat1 $lon2,$lat2 $lon3,$lat3 ($i)\n");
      }
   }
   $fnd = 0;
   for ($i = 0; $i < $max; $i++) {
      $dn1  = ${$ra}[$i][7];
      next if ($dn1);
      $typ  = ${$ra}[$i][0];
      $fnd++;
      if ($typ == 1) {
         $mtyp1++;
      } else {
         $mtyp2++;
      }
   }
   prt("List of $fnd MISSED triangles...($miss) 1=$mtyp1, 2=$mtyp2\n");
   for ($i = 0; $i < $max; $i++) {
      $dn1  = ${$ra}[$i][7];
      next if ($dn1);
      $typ  = ${$ra}[$i][0];
      $lon1 = ${$ra}[$i][1];
      $lat1 = ${$ra}[$i][2];
      $lon2 = ${$ra}[$i][3];
      $lat2 = ${$ra}[$i][4];
      $lon3 = ${$ra}[$i][5];
      $lat3 = ${$ra}[$i][6];
      prt("MISSED:$typ: $lon1,$lat1 $lon2,$lat2 $lon3,$lat3 ($i)\n");
   }
   if ($add_try_harder) {
      prt("Trying harder to match...\n");
      for ($i = 0; $i < $max; $i++) {
         $fnd = 0;
         $dn1  = ${$ra}[$i][7];
         next if ($dn1);
         $typ  = ${$ra}[$i][0];
         $lon1 = ${$ra}[$i][1];
         $lat1 = ${$ra}[$i][2];
         $lon2 = ${$ra}[$i][3];
         $lat2 = ${$ra}[$i][4];
         $lon3 = ${$ra}[$i][5];
         $lat3 = ${$ra}[$i][6];
         for ($j = 0; $j < $max; $j++) {
            $typ2  = ${$ra}[$j][0];
            $dn2   = ${$ra}[$j][7];
            next if ($typ == $typ2);
            next if ($dn2);
            $lon21 = ${$ra}[$j][1];
            $lat21 = ${$ra}[$j][2];
            $lon22 = ${$ra}[$j][3];
            $lat22 = ${$ra}[$j][4];
            $lon23 = ${$ra}[$j][5];
            $lat23 = ${$ra}[$j][6];
            if (compare_very_near($lon1,$lat1,$lon2,$lat2,$lon3,$lat3,$lon21,$lat21,$lon22,$lat22,$lon23,$lat23) ) {
               ${$ra}[$i][7] = ($j + 1);
               ${$ra}[$j][7] = ($i + 1);
               $fnd++;
               prt("SIMILAR PT: $lon1,$lat1 $lon2,$lat2 $lon3,$lat3 ($i:$j)[$fnd]\n");
            }
         }
         if (!$fnd) {
            $miss++;
               prt("NOT FND: $lon1,$lat1 $lon2,$lat2 $lon3,$lat3 ($i)\n");
         }
      }
   }

}

my $ref_arr = process_file($in_file);
show_ref_arr($ref_arr);

close_log($outfile,$load_log);
exit(0);

# eof
