#!/perl -w
# NAME: convdegrees.pl
# AIM: To convert Farenheight to Centigrade and vice versa
# 20/11/2007 geoff mclane - http:geoffair.net/mperl
use strict;
use warnings;

my $verbose = 0;
my $convtype = 0;
my $value = -1;
my $conv = 0;
my $msg1 = "degrees Fahrenheit";
my $msg2 = "degrees Celsius";
###my $fahr = 90;
###my $cels = convert_f2c($fahr);
###my $f2 = convert_c2f($cels);
###print "$fahr degrees Fahrenheit equals $cels degrees Celsius.\n";
###print "$cels degrees Celsius equals $f2 degrees Fahrenheit.\n";
parse_arguments(@ARGV);

if ($value == -1) {
	print "ERROR: Did not find a number in arguments ...\n";
} else {
	if ($convtype == 1) {
		$conv = convert_f2c($value);
		print "$value $msg1 equals $conv $msg2\n";
	} elsif ($convtype == 2) {
		$conv = convert_c2f($value);
		print "$value $msg2 equals $conv $msg1\n";
	} else {
		print "ERROR: Did not find an F or C in arguments ...\n";
	}
}
exit(0);
#####################

sub convert_f2c {
   my $fahr = $_[0];
   my $cels = ($fahr - 32) * 5/9;
   $cels = (int( ($cels + 0.005) * 100 ) / 100);
   return $cels
}

sub convert_c2f {
   my $cels = $_[0];
   my $fahr = (($cels * 9) / 5) + 32;
   $fahr = (int( ($fahr + 0.005) * 100 ) / 100);
   return $fahr
}

sub give_little_help {
	print "Enter degrees Celsius and get Fahrenheit, or\n";
	print "enter degrees Fahrenheit and get Celcius.\n";
	print "Example: 90 F, will output -\n";
	print "90 degrees Fahrenheit equals 32.22 degrees Celsius.\n";
	print "Just the letter denoting the degrees is sufficient.\n";
	die "Happy converting ...\n";
}

sub parse_arguments {
    my @av = @_;
    my $arg = '';
	my $args = '';
	my $gotnum = 0;
    while (@av) {
        $arg = $av[0];
		$args .= ' ' if length($args);
		$args .= $arg;
        if ($arg eq '--help' || $arg eq '-h' || $arg eq '-?') {
            give_little_help(); # show help and exit
        } elsif ($arg eq '--verbose' || $arg eq '-v') {
            $verbose = 1;
		} else {
			# can be 90F, or 90 F, or 90.2 Fahrenheit ...
			if ($gotnum) {
				if ($arg =~ /^(F|C).*/i) {
					if (lc($1) eq 'f') {
						$convtype = 1;
					} else {
						$convtype = 2;
					}
				} else {
					print "Problem with argument [$arg] - NOT begin F or C?\n";
					print "Had arguments [$args]\n";
					give_little_help();
				}
			} else {
				if ($arg =~ /^\d+/) {
					if ($arg =~ /^\d+\.*\d*$/) {
						$value = $arg;
					} else {
						# assume number plus letter
						if ($arg =~ /^(\d+)(.+)/) {
							$value = $1;
							if ($2 =~ /^(F|C).*/i) {
								if (lc($1) eq 'f') {
									$convtype = 1;
								} else {
									$convtype = 2;
								}
							} else {
								print "Problem with argument [$arg] - NOT contain F or C?\n";
								print "Had arguments [$args]\n";
								give_little_help();
							}
						} else {
							print "Problem with argument [$arg] - NOT number plus letter?\n";
							print "Had arguments [$args]\n";
							give_little_help();
						}
					}
					$gotnum = 1;
				} else {
					print "Problem with argument [$arg] - NOT begin with number?\n";
					print "Had arguments [$args]\n";
					give_little_help();
				}
			}
		}
		shift @av;
	}
	if ($verbose) {
		print "Had arguments [$args] ...\n";
		print "Got value $value ...\n";
		if ($convtype == 1) {
			print "Will convert Fahrenheit to Celcius.\n";
		} elsif ($convtype == 2) {
			print "Will convert Celcius to Fahrenheit.\n";
		} else {
			print "ERROR: Did not find an F or C in arguments ...\n";
		}
	}
}

# eof - convdegrees.pl
