#!/perl -w
# NAME: delline.pl
# AIM: Search for a line, and delete it, and write file out
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $in_file = 'C:\HOMEPAGE\GA\travel\maroc\maroc-nwh4.htm';
###my $in_file = 'C:\HOMEPAGE\GA\travel\maroc\maroc-table1m.htm';
###my $in_file = 'C:\HOMEPAGE\GA\travel\maroc\maroc-all.htm';
###my $in_file = 'C:\HOMEPAGE\GA\travel\maroc\maroc-table1f.htm';
###my $in_file = 'C:\HOMEPAGE\GA\travel\maroc\maroc-table4s.htm';
###my $in_file = 'C:\HOMEPAGE\GA\travel\maroc\maroc-table3s.htm';
###my $in_file = 'C:\HOMEPAGE\GA\travel\maroc\maroc-table2s.htm';
my @outlines = ();
my $out_file = 'tempdel.htm';

if( open( INF, "<$in_file" ) ) {
	my @lines = <INF>;
	my $lncnt = scalar @lines;
	close INF;
	my $cnt = 0;
	my $skip = 0;
	my $skipcnt = 0;
	my $line = '';
	my $outcnt = 0;
	my $i = 0;
	my $diff = 0;
	my $res = '';
	my $lastln = 0;
	my $num = '';
	my $tail = '';
	my $bgn = '';
	my $ind = 0;
	my $bal = '';
	my $nline = '';
	prt( "Got $lncnt lines to process ... from $in_file\n" );
	for ($i = 0; $i < $lncnt; $i++) {
		$line = $lines[$i];
		chomp $line;
		$skip = 0;
		if ($line =~ /href="pics\/maroc\d+\.jpg"/) {
			$cnt++;
		} elsif ($line =~ /\s*width="\d+"\s+height="\d+"/) {
			if ($line =~ /^\s*width="\d+"\s+height="\d+"\s*$/) {
				$skip = 1;
				$skipcnt++;
			} else {
				$nline = adjust_line($line);
				prt( "Line adjusted from [" . trim_all($line) . "] to [" . trim_all($nline) . "]\n" );
				$line = $nline;
			}
		} elsif ($line =~ /\s*width="(\d+)"\s*/) {
			$num = $1;
			$ind = index($line, 'width');
			$bgn = substr($line,0,$ind);
			$tail = substr($line,$ind);
			$bal = substr($line,$ind+8+length($num));
			if (just_width($line)) {
				$skip = 1;
				$skipcnt++;
			} else {
				###prt( "******* FIX ME ******* [$line] [$bgn] tail[$tail] bal[$bal]\n" );
				$nline = $bgn . $bal;
				prt( "Line adjusted from [" . trim_all($line) . "] to [" . trim_all($nline) . "]\n" );
				$line = $nline;
			}
		} elsif ($line =~ /\s*height="(\d+)"\s*/) {
			$num = $1;
			$ind = index($line, 'height');
			$bgn = substr($line,0,$ind);
			$tail = substr($line,$ind);
			$bal = substr($line,$ind+9+length($num));
			if (just_height($line)) {
				$skip = 1;
				$skipcnt++;
			} else {
				###prt( "******* FIX ME ******* [$line] [$bgn] tail[$tail] bal[$bal]\n" );
				$nline = $bgn . $bal;
				prt( "Line adjusted from [" . trim_all($line) . "] to [" . trim_all($nline) . "]\n" );
				$line = $nline;
			}
		}
		if ($skip) {
			prt( "$cnt: Skip line [" . trim_all($line) . "] ($skipcnt)\n" );
		} else {
			push(@outlines, $line);
			$lastln++;
		}
	}
	if (open( OUTF, ">$out_file")) {
		foreach $line (@outlines) {
			$outcnt++;
			print OUTF "$line\n";
		}
		close OUTF;
		$diff = ($lncnt - $skipcnt);
		$res = ($outcnt == $diff) ? "ok" : "DIFFERENT???";
		prt( "End processing $in_file ...\n");
		prt( "Wrote $outcnt lines to $out_file ($lncnt - $skipcnt = $diff $res)\n" );
		if (open( OUTF, ">tempcopy.bat")) {
			print OUTF "\@echo copy $out_file $in_file? Ctrl+C to abort!\n";
			print OUTF "\@pause\n";
			print OUTF "copy $out_file $in_file\n";
			close OUTF;
			prt( "Run tempcopy.bat to update, if correct ...\n" );
		}
	} else {
		prt( "ERROR: Can NOT create $out_file ...\n" );
	}
} else {
	prt( "ERROR: Can NOT open $in_file ...\n" );
}

close_log($outfile,1);
exit(0);

##########################

sub just_width {
	my ($txt) = shift;
	my $len = length($txt);
	my ($i, $c, $pt);
	for ($i = 0; $i < $len; $i++) {
		$c = substr($txt,$i,1);
		if ($c eq 'w') {
			$pt = substr($txt,$i);
			if ($pt =~ /^width="\d+"$/) {
				return 1;
			}
		} elsif ( !($c =~ /\s/) ) {
			return 0;
		}
	}
	return 0;
}

sub just_height {
	my ($txt) = shift;
	my $len = length($txt);
	my ($i, $c, $pt);
	for ($i = 0; $i < $len; $i++) {
		$c = substr($txt,$i,1);
		if ($c eq 'h') {
			$pt = substr($txt,$i);
			if ($pt =~ /^height="\d+"$/) {
				return 1;
			}
		} elsif ( !($c =~ /\s/) ) {
			return 0;
		}
	}
	return 0;
}

### $nline = adjust_line($line);
sub adjust_line {
	my ($ln) = shift;
	my $nln = '';
	my ($i, $max, $ch, $part, $num, $bgn, $sz);
	$max = length($ln);
	for ($i = 0; $i < $max; $i++) {
		$ch = substr($ln,$i,1);
		if ($ch eq 'w') {
			$part = substr($ln,$i);
			$bgn = substr($ln,0,$i-1);
			if ($part =~ /^width="(\d+)"/) {
				$num = $1;
				$sz = 7 + length($num);
				$part = substr($part,$sz);
				while ($part =~ /^\s+/) {
					$part = substr($part,1);
				}
				$ln = $bgn . $part;
				$max = length($ln);
				$ch = '';
				$i--;	# back up one
			}
		} elsif ($ch eq 'h') {
			$part = substr($ln,$i);
			$bgn = substr($ln,0,$i-1);
			if ($part =~ /^height="(\d+)"/) {
				$num = $1;
				$sz = 8 + length($num);
				$part = substr($part,$sz);
				while ($part =~ /^\s+/) {
					$part = substr($part,1);
				}
				$ln = $bgn . $part;
				$max = length($ln);
				$ch = '';
				$i--;	# back up one
			}
		}
		if ($ch eq '>') {
			while ($nln =~ /\s+$/) {
				$nln = substr($nln,0,length($nln)-1);
			}
		}
		$nln .= $ch;
	}
	return $nln;

}

# eof - delline.pl

