#!/perl
# NAME - fav-01.pl
# AIM - To list the file in my 'Favorite' folder ...
# 10 Nov, 2005 - geoff mclane - http://geoffmclane.com
# 03 March, 2007 - Added output to LOG FILE ...
use strict;
use Cwd;
use File::stat;
use Time::HiRes qw(usleep ualarm gettimeofday tv_interval);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
my $dbg1 = 0;	# add environment output

my $start_time = time();
my ($ssecs, $susecs) = gettimeofday();
###my $t0 = gettimeofday();
###my $prog = 'fav-01.pl';
my $prog = $0;
my $cwdir = getcwd();
my $fn = '';
my $key = '';
my @files = ();

open_log($outfile);

prt( "$prog: says, Hello, World ... in $cwdir ...\n" );
prt( "$prog: Started on " . localtime($start_time) . " in $cwdir ...\n" );

foreach $key (sort keys(%ENV)) 
{
	prt( "$key = $ENV{$key}\n" ) if $dbg1;
	if( $key eq 'USERPROFILE' ) {
		$cwdir = $ENV{$key} . "\\Favorites";
		last;
	}
}

###my $scanlist = scandir("$cwdir"); 
###my @sl = scandir($cwdir); 
scandir($cwdir); # now made iterative

###foreach ($scanlist as $fn) 
foreach $fn (@files) 
{ 
    ###print "<a href=\"$fn\">$fn</a> <br/>\n"; 
    prt( "$fn\n" ); 
} 


my $end_time = time();
my ($esecs, $eusecs) = gettimeofday();
####my $t1 = gettimeofday();
####my $t1_t0 = tv_interval $t0, $t1;
###my $t1_t0 = tv_interval( $t0 );
prt( "$prog: Ended on " . localtime($end_time) . " diff = " . ($end_time - $start_time) . " ...\n" );
prt( " Secs = " . ($esecs - $ssecs) . "." . ($eusecs - $susecs) . "\n" );
close_log($outfile,1);
exit(0);

##// function to get file names 
## function scandir($dirstr) 
sub scandir {
	my ($dirstr) = @_;
	my @dirs = ();
	prt( "Openning FOLDER $dirstr ...\n" );
    my $fh;
	opendir($fh,$dirstr); 
	my $filename = '';
	my $ff = '';
    while ( $filename = readdir($fh) ) 
    {
		if( !($filename eq '.') && !($filename eq '..') ) {
			$ff = $dirstr . '\\' . $filename; # get FULL PATH
			if( -d $ff ) { # is directory (is_dir)
				# is a DIRECTORY
				push(@dirs, $ff);
			} else {
				###array_push($files, $filename); 
				###push(@files, $filename);
				push(@files, $ff);
			}
		}
    } 
    closedir($fh); 
    ###sort(@files); 
    ###return @files; 
	foreach $ff (@dirs) {
		scandir( $ff );
	}
}

# from : http://www.cyanwerks.com/file-format-url.html 
# Modified
# This field is generally the most cryptic of all the fields.
# Example: Modified=20F06BA06D07BD014D
# For a while some vague calculations were given on this page for calculating the date and time
# of the modified field, but since the first posting of this article Ive received a lot of input
# from other people that have experimented with this field:
# Changes fast    Changes slowly Constant
# C0  34  90  B3  07  DC  C3  01  DE
# Thanks goes to Shawn K. Hall, Jeff Dickey, Ken Schenke, Vivian De Smedt, David Jones,
# Frank Stocker, and possibly others (Ive lost some mail since a few years ago) for pointing
# out this is a FILETIME structure (this article has last been updated in late 2000, 
# basically 3-4 years, so Ive been late to rewrite this section), The first 8 hex bytes
# are the FILETIME structure, the last hex byte is found to be a checksum and is 
# unimportant. Since this is a FILETIME structure, you can pass it to the FileTimeToSystemTime
# API call to get all the discrete date and time elements. However the first 8 hex bytes need
# to be inverted before passing in to FileTimeToSystemTime. Therefore:
# C0  34  90  B3  07  DC  C3  01  DE
# Invert  Rem.
# 01  C3  DC  07  B3  90  34  C0
# High DW = 01 C3 DC 07
# Low DW = B3 90 34 C30
# FileTimeToSystemTime = 16/1/2004 08:06:53
# Ive wrote a small VB6 demonstration that does this task.

# eof - fav-01.pl
