#!perl -w
# #######################################################################################
# module: fgdsphdrs.pl
# header information, when building DSP files
#
# Windows Console Application === sub get_dsp_head_console
# Windows Application         === sub get_dsp_head_app
# Windows Static Library      === sub get_dsp_head_slib
# Windows Dynamic Library     === sub get_dsp_head_dynalib
#
# substitution variables
# -NEW_PROJECT_NAME-"   = name of the project
# -NEW_OUTD_(REL|DBG)-  = PROP Output_Dir ????
# -NEW_INTER_(REL|DBG)- = PROP Intermediate_Dir ????
# ADD CPP with 
# -NEW_RT_(REL|DBG)-    = RUNTIME, like /MT /MD, /MTd, etc
# -NEW_INCS_(REL|DBG)-  = INCLUDE DIRECTORIES, like /I ".."
# -NEW_DEFS_(REL|DBG)-  = DEFINES, like /D "FGFS"
# ADD LINK32 (for console, app, DLL) with
# -NEW_LIBS_(REL|DBG)-  = Additional libraries for the link
# -NEW_OUT_(REL|DBG)-   = link output, like /out:"StaticRelease\libpng.lib
# -NEW_POST_(REL|DBG)-  = POST build - description and commands, TAB separated
# ADD LIB32 (for static library) with
# -NEW_OUT_(REL|DBG)-   =  OUTPUT static library
# #######################################################################################

# like zlib = ConfigurationType="4", alut = ConfigurationType="2", fg = ConfigurationType="1"
#  // This is an internal type to Visual Studio, it seems that:
#  // 4 == static library
#  // 2 == dll
#  // 1 == executable
#  // 10 == utility
my $app_console_stg  = 'Console Application';
my $app_windows_stg  = 'Application';
my $app_dynalib_stg  = 'Dynamic-Link Library';
my $app_statlib_stg  = 'Static Library';
my $app_utility_stg  = 'Utility';

# Windows Console Application
# ===========================
sub get_dsp_head_console {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Console Application" 0x0103

CFG=-NEW_PROJECT_NAME- - Win32 Release
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Release"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Console Application")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Console Application")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
CPP=cl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir ".\\Release"
# PROP BASE Intermediate_Dir ".\\Release"
# PROP BASE Target_Dir "."
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir -NEW_OUTD_REL-
# PROP Intermediate_Dir -NEW_INTER_REL-
# PROP Ignore_Export_Lib 0
# PROP Target_Dir "."
# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_CONSOLE" /YX /c
# ADD CPP /nologo -NEW_RT_REL- /W3 /GX /O2 -NEW_INCS_REL- /D "WIN32" /D "NDEBUG" /D "_CONSOLE" -NEW_DEFS_REL- /FD /c
# SUBTRACT CPP /YX
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:console /machine:I386
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_REL- /nologo /subsystem:console /machine:I386 -NEW_OUT_REL-
-NEW_POST_REL-
!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir ".\\Debug"
# PROP BASE Intermediate_Dir ".\\Debug"
# PROP BASE Target_Dir "."
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir -NEW_OUTD_DBG-
# PROP Intermediate_Dir -NEW_INTER_DBG-
# PROP Ignore_Export_Lib 0
# PROP Target_Dir "."
# ADD BASE CPP /nologo /W3 /Gm /GX /Zi /Od /D "WIN32" /D "_DEBUG" /D "_CONSOLE" /YX /c
# ADD CPP /nologo -NEW_RT_DBG- /W3 /Gm /GX /ZI /Od -NEW_INCS_DBG- /D "WIN32" /D "_DEBUG" /D "_CONSOLE" -NEW_DEFS_DBG- /FD /c
# SUBTRACT CPP /YX
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:console /debug /machine:I386
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_DBG- /nologo /subsystem:console /debug /machine:I386 -NEW_OUT_DBG-
-NEW_POST_DBG-
!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

	return $dsp_head;
}

# Windows Application
# ===========================
sub get_dsp_head_app {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Application" 0x0101

CFG=-NEW_PROJECT_NAME- - Win32 Debug
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Debug"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Application")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Application")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
# PROP Scc_ProjName ""
# PROP Scc_LocalPath ""
CPP=cl.exe
MTL=midl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir "Release"
# PROP BASE Intermediate_Dir "Release"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir -NEW_OUTD_REL-
# PROP Intermediate_Dir -NEW_INTER_REL-
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /Yu"stdafx.h" /FD /c
# ADD CPP /nologo /W3 -NEW_RT_REL- /GX /O2 -NEW_INCS_REL- /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" -NEW_DEFS_REL- /FD /c
# SUBTRACT CPP /YX /Yc /Yu
# ADD BASE MTL /nologo /D "NDEBUG" /mktyplib203 /win32
# ADD MTL /nologo /D "NDEBUG" /mktyplib203 /win32
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:windows /machine:I386
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_REL- /nologo /subsystem:windows /machine:I386 -NEW_OUT_REL-
-NEW_POST_REL-
!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir "Debug"
# PROP BASE Intermediate_Dir "Debug"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir -NEW_OUTD_DBG-
# PROP Intermediate_Dir -NEW_INTER_DBG-
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_WINDOWS" /D "_MBCS" /Yu"stdafx.h" /FD /GZ /c
# ADD CPP /nologo /W3 -NEW_RT_DBG- /Gm /GX /ZI /Od -NEW_INCS_DBG- /D "WIN32" /D "_DEBUG" /D "_WINDOWS" /D "_MBCS" -NEW_DEFS_DBG- /FD /GZ /c
# SUBTRACT CPP /YX /Yc /Yu
# ADD BASE MTL /nologo /D "_DEBUG" /mktyplib203 /win32
# ADD MTL /nologo /D "_DEBUG" /mktyplib203 /win32
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /subsystem:windows /debug /machine:I386 /pdbtype:sept
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_DBG- /nologo /subsystem:windows /debug /machine:I386 /pdbtype:sept -NEW_OUT_DBG-
-NEW_POST_DBG-
!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

	return $dsp_head;
}

# Windows Static Library
# ===========================
sub get_dsp_head_slib {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Static Library" 0x0104

CFG=-NEW_PROJECT_NAME- - Win32 Debug
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Debug"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Static Library")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Static Library")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
# PROP Scc_ProjName ""
# PROP Scc_LocalPath ""
CPP=cl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir "Release"
# PROP BASE Intermediate_Dir "Release"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir -NEW_OUTD_REL-
# PROP Intermediate_Dir -NEW_INTER_REL-
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_MBCS" /D "_LIB" /YX /FD /c
# ADD CPP /nologo /W3 /GX /O2 -NEW_INCS_REL- /D "WIN32" /D "NDEBUG" /D "_MBCS" /D "_LIB" -NEW_DEFS_REL- /YX /FD /c
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LIB32=link.exe -lib
# ADD BASE LIB32 /nologo
# ADD LIB32 /nologo -NEW_OUT_REL-
-NEW_POST_REL-
!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir "Debug"
# PROP BASE Intermediate_Dir "Debug"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir -NEW_OUTD_DBG-
# PROP Intermediate_Dir -NEW_INTER_DBG-
# PROP Target_Dir ""
# ADD BASE CPP /nologo /W3 /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_MBCS" /D "_LIB" /YX /FD /GZ /c
# ADD CPP /nologo /W3 /Gm /GX /ZI /Od -NEW_INCS_DBG- /D "WIN32" /D "_DEBUG" /D "_MBCS" /D "_LIB" -NEW_DEFS_DBG- /YX /FD /GZ /c
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LIB32=link.exe -lib
# ADD BASE LIB32 /nologo
# ADD LIB32 /nologo -NEW_OUT_DBG-
-NEW_POST_DBG-
!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

	return $dsp_head;
}

# Windows Dynamic Library
# ===========================
sub get_dsp_head_dynalib {
	my $dsp_head = <<EOF;
# Microsoft Developer Studio Project File - Name="-NEW_PROJECT_NAME-" - Package Owner=<4>
# Microsoft Developer Studio Generated Build File, Format Version 6.00
# ** DO NOT EDIT **

# TARGTYPE "Win32 (x86) Dynamic-Link Library" 0x0102

CFG=-NEW_PROJECT_NAME- - Win32 Debug
!MESSAGE This is not a valid makefile. To build this project using NMAKE,
!MESSAGE use the Export Makefile command and run
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak".
!MESSAGE 
!MESSAGE You can specify a configuration when running NMAKE
!MESSAGE by defining the macro CFG on the command line. For example:
!MESSAGE 
!MESSAGE NMAKE /f "-NEW_PROJECT_NAME-.mak" CFG="-NEW_PROJECT_NAME- - Win32 Debug"
!MESSAGE 
!MESSAGE Possible choices for configuration are:
!MESSAGE 
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Release" (based on "Win32 (x86) Dynamic-Link Library")
!MESSAGE "-NEW_PROJECT_NAME- - Win32 Debug" (based on "Win32 (x86) Dynamic-Link Library")
!MESSAGE 

# Begin Project
# PROP AllowPerConfigDependencies 0
# PROP Scc_ProjName ""
# PROP Scc_LocalPath ""
CPP=cl.exe
MTL=midl.exe
RSC=rc.exe

!IF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Release"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 0
# PROP BASE Output_Dir "Release"
# PROP BASE Intermediate_Dir "Release"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 0
# PROP Output_Dir -NEW_OUTD_REL-
# PROP Intermediate_Dir -NEW_INTER_REL-
# PROP Ignore_Export_Lib 0
# PROP Target_Dir ""
# ADD BASE CPP /nologo /MT /W3 /GX /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /D "_USRDLL" /D "-NEW_PROJECT_NAME-_EXPORTS" /Yu"stdafx.h" /FD /c
# ADD CPP /nologo -NEW_RT_REL- /W3 /GX /O2 -NEW_INCS_REL- /D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_MBCS" /D "_USRDLL" /D "-NEW_PROJECT_NAME-_EXPORTS" -NEW_DEFS_REL- /FD /c
# SUBTRACT CPP /YX /Yc /Yu
# ADD BASE MTL /nologo /D "NDEBUG" /mktyplib203 /win32
# ADD MTL /nologo /D "NDEBUG" /mktyplib203 /win32
# ADD BASE RSC /l 0x809 /d "NDEBUG"
# ADD RSC /l 0x809 /d "NDEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /dll /machine:I386
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_REL- /nologo /dll /machine:I386 -NEW_OUT_REL-
-NEW_POST_REL-
!ELSEIF  "\$(CFG)" == "-NEW_PROJECT_NAME- - Win32 Debug"

# PROP BASE Use_MFC 0
# PROP BASE Use_Debug_Libraries 1
# PROP BASE Output_Dir "Debug"
# PROP BASE Intermediate_Dir "Debug"
# PROP BASE Target_Dir ""
# PROP Use_MFC 0
# PROP Use_Debug_Libraries 1
# PROP Output_Dir -NEW_OUTD_DBG-
# PROP Intermediate_Dir -NEW_INTER_DBG-
# PROP Ignore_Export_Lib 0
# PROP Target_Dir ""
# ADD BASE CPP /nologo /MTd /W3 /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_WINDOWS" /D "_MBCS" /D "_USRDLL" /D "-NEW_PROJECT_NAME-_EXPORTS" /Yu"stdafx.h" /FD /GZ  /c
# ADD CPP /nologo -NEW_RT_DBG- /W3 /Gm /GX /ZI /Od -NEW_INCS_DBG- /D "WIN32" /D "_DEBUG" /D "_WINDOWS" /D "_MBCS" /D "_USRDLL" /D "-NEW_PROJECT_NAME-_EXPORTS" -NEW_DEFS_DBG- /FD /GZ  /c
# SUBTRACT CPP /YX /Yc /Yu
# ADD BASE MTL /nologo /D "_DEBUG" /mktyplib203 /win32
# ADD MTL /nologo /D "_DEBUG" /mktyplib203 /win32
# ADD BASE RSC /l 0x809 /d "_DEBUG"
# ADD RSC /l 0x809 /d "_DEBUG"
BSC32=bscmake.exe
# ADD BASE BSC32 /nologo
# ADD BSC32 /nologo
LINK32=link.exe
# ADD BASE LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib /nologo /dll /debug /machine:I386 /pdbtype:sept
# ADD LINK32 kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib -NEW_LIBS_DBG- /nologo /dll /debug /machine:I386 /pdbtype:sept -NEW_OUT_DBG-
-NEW_POST_DBG-
!ENDIF 

# Begin Target

# Name "-NEW_PROJECT_NAME- - Win32 Release"
# Name "-NEW_PROJECT_NAME- - Win32 Debug"
EOF

    return $dsp_head;
}


sub get_dsp_tail {
	my $dsp_tail = <<EOF;
# End Target
# End Project
EOF

	return $dsp_tail;
}

sub get_dsw_head {
	### default DSW
	my $raw_dswh = <<EOF;
Microsoft Developer Studio Workspace File, Format Version 6.00
# WARNING: DO NOT EDIT OR DELETE THIS WORKSPACE FILE!

EOF
	return $raw_dswh;
}


sub get_dsw_tail {
	my $raw_dswt = <<EOF;
###############################################################################

Global:

Package=<5>
{{{
}}}

Package=<3>
{{{
}}}

###############################################################################

EOF
	return $raw_dswt;
}


sub get_default_sub {
    my %def_sub = (
    "-NEW_PROJECT_NAME-" => "fgfs",
    "-NEW_RT_REL-"       => "/MT",
    "-NEW_RT_DBG-"       => "/MTd",
    "-NEW_DEFS_REL-"     => "/D \"FGFS\" /D \"_CRT_SECURE_NO_WARNINGS\"",
    "-NEW_DEFS_DBG-"     => "/D \"FGFS\" /D \"_CRT_SECURE_NO_WARNINGS\"",
    "-NEW_LIBS_DBG-"     => "Winmm.lib ws2_32.lib",
    "-NEW_LIBS_REL-"     => "Winmm.lib ws2_32.lib",
    "-NEW_POST_DBG-"     => "",
    "-NEW_POST_REL-"     => "",
    "-NEW_INCS_DBG-"     => "",
    "-NEW_INCS_REL-"     => "",
    "-NEW_OUTD_DBG-"     => "\"Debug\"",
    "-NEW_OUTD_REL-"     => "\"Release\"",
    "-NEW_INTER_DBG-"    => "\"Debug\"",
    "-NEW_INTER_REL-"    => "\"Release\"",
    "-NEW_OUT_DBG-"      => "",
    "-NEW_OUT_REL-"      => ""
    );

    return %def_sub;
}

# Windows Console Application === sub get_dsp_head_console
# Windows Application         === sub get_dsp_head_app
# Windows Static Library      === sub get_dsp_head_slib
# Windows Dynamic Library     === sub get_dsp_head_dynalib
# $isok = get_dsp_header_text( \$msg, $val );
sub get_dsp_header_text {
    my ($rm, $v) = @_;
    my $iok = 1;
    my %dht = (
        $app_console_stg => \&get_dsp_head_console,
        $app_windows_stg => \&get_dsp_head_app,
        $app_statlib_stg => \&get_dsp_head_slib,
        $app_dynalib_stg => \&get_dsp_head_dynalib
    );
    if (defined $dht{$v}) {
            my $val = $dht{$v};
            $$rm = $val->();
    } else {
        prtw( "WARNING: No application type [$v] in hash ...\n" );
        $iok = 0;
    }
    return $iok;
}

my $def_runtime_lts = "MD";
my $def_runtime_stg = "Multithreaded DLL";
my $def_runtime_val = 2;
#    0                  1     2                         3  4
my @fg_runtimes_array = (
    ["RuntimeLibrary", "MT",  "Multithreaded",           0, 0],
    ["RuntimeLibrary", "MTd", "Multithreaded Debug",     1, 0],
    ["RuntimeLibrary", $def_runtime_lts, $def_runtime_stg, $def_runtime_val, 0],
    ["RuntimeLibrary", "MDd", "Multithreaded DLL Debug", 3, 0],
    ["RuntimeLibrary", "ML",  "Single Thread",           4, 0],
    ["RuntimeLibrary", "MLd", "Single Thread Debug",     5, 0]
);

sub fg_get_runtime_val_2_lts {
	my ($rtn) = shift;
    my $len = scalar @fg_runtimes_array;
    for (my $i = 0; $i < $len; $i++) {
        my $itm = $fg_runtimes_array[$i][3];
        if ($itm == $rtn) {
            return "/" . $fg_runtimes_array[$i][1];
        }
    }
    prtw( "WARNING: $rtn not found in runtimes array! Using default '$def_runtime_lts'!!\n" );
	return "/$def_runtime_lts";
}

sub get_app_conf_type {
    my ($ct) = shift;
    # per <Configuration ... ConfigurationType="4" ...
    my %vc_cts = (
        1  => $app_windows_stg,
        2  => $app_dynalib_stg,
        4  => $app_statlib_stg,
        10 => $app_utility_stg );
    my $at = '';
    if (defined $vc_cts{$ct}) {
        $at = $vc_cts{$ct};
    } else {
        prtw( "WARNING: Failed to FIND '$ct' in v8_conftypes!\n" );
        mydie( "ABORTING, in disgust ;=))\n" );
    }
    return $at;
}

# $apptype = adjust_app_type_per_subsystem( $apptype, $adddeps );
sub adjust_app_type_per_subsystem {
    my ($capt,$ss,$dbg) = @_;
    # and if 1 ($app_windows), then per SubSystem
    # <Tool Name="VCLinkerTool" ... SubSystem="2"
    # SubSystem="1" = :console or "2" = :window
    my %vc_ss = (
        1 => $app_console_stg,
        2 => $app_windows_stg );
    if (defined $vc_ss{$ss}) {
        my $napt = $vc_ss{$ss};
        if ($capt eq $napt) {
            prt("Got APPTYPE: NO CHANGE [$capt] equals SubSystem ($ss) [$napt] ...\n" ) if ($dbg);
        } else {
            if ($capt eq $app_dynalib_stg) {
                if ($napt eq $app_windows_stg) {
                    # these are NOT incompatible, so NO CHANGE
                    prt("Got APPTYPE: NO CHANGE [$capt] EQUIVALENT to $ss ($napt) ...\n" ) if ($dbg);
                } else {
                    prtw("WARNING: NO CHANGE but [$capt] NOT EQUIVALENT to $ss ($napt) ...\n" );
                }
            } else {
                prt("Set APPTYPE: from [$capt], to [$napt] ($ss).\n" ) if ($dbg);
                $capt = $napt;
            }
        }
    }
    return $capt;
}

sub write_hash_to_DSP {
    my ($of, $rh) = @_; # say ('tempvcscan.dsp', \%h);
    my ($val, $msg, $key, $cnt, $srcs);
    my $isok = 1;
    my ($fnam, $ftyp, $i, $fil);
    $msg = '';
    if (defined $$rh{'APP_TYPE'}) {
        $val = $$rh{'APP_TYPE'};
        $isok = get_dsp_header_text( \$msg, $val );
    } else {
        prtw( "WARNING: No application type in hash ...\n" );
        $isok = 0;
    }
    if (defined $$rh{'C_SOURCES'}) {
        $srcs = $$rh{'C_SOURCES'}; # = [@vc_c_sources];
        $cnt = scalar @{$srcs};
        if ($cnt == 0) {
            prtw( "WARNING: No source files in hash ...\n" );
            $isok = 0;
        }
    } else {
        prtw( "WARNING: No SOURCES in hash ...\n" );
        $isok = 0;
    }
    if (! $isok) {
        prtw( "WARNING: No DSP written ...\n" );
        return 0;
    }

    foreach $key (keys %{$rh}) {
        if ($key =~ /^-NEW_/) {
            $val = $$rh{$key};
            $msg =~ s/$key/$val/g;
        }
    }

    $fnam = $$srcs[0][1];
    $ftyp = $$srcs[0][2];
    if ($cnt) {
        $msg .= '# Begin Group "'.$fnam."\"\n";
        $msg .= "\n";
        $msg .= '# PROP Default_Filter "'.$ftyp."\"\n";
        for ($i = 0; $i < $cnt; $i++) {
            $fil = $$srcs[$i][0];
            $msg .= "# Begin Source File\n";
            $msg .= "\n";
            $msg .= "SOURCE=$fil\n";
            # $msg .= "# PROP Exclude_From_Build 1\n" if ($ex eq $excl_mark);
            $msg .= "# End Source File\n";
        }
        $msg .= "# End Group\n";
    }

    $cnt = 0;
    if (defined $$rh{'H_SOURCES'}) {
        $srcs = $$rh{'H_SOURCES'}; # = [@vc_c_sources];
        $cnt = scalar @{$srcs};
        $fnam = $$srcs[0][1];
        $ftyp = $$srcs[0][2];
    }
    if ($cnt) {
        $msg .= '# Begin Group "'.$fnam."\"\n";
        $msg .= "\n";
        $msg .= '# PROP Default_Filter "'.$ftyp."\"\n";
        for ($i = 0; $i < $cnt; $i++) {
            $fil = $$srcs[$i][0];
            $msg .= "# Begin Source File\n";
            $msg .= "\n";
            $msg .= "SOURCE=$fil\n";
            # $msg .= "# PROP Exclude_From_Build 1\n" if ($ex eq $excl_mark);
            $msg .= "# End Source File\n";
        }
        $msg .= "# End Group\n";
    }
    
	$msg .= get_dsp_tail();

    write2file($msg,$of);

    prt( "Written $of ...\n" );
}

1;
# eof - fgdsphdrs.pl