#!/usr/bin/perl -w
# NAME: findinfile.pl
# AIM: Find a string in a file, using perl regex
# 31/05/2011 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use File::stat;
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl ...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 1;
my $in_file = '';
my $find_this = '';

my $def_dbg_on = 1;
my $def_file = 'C:\DTEMP\explist.txt';
# my $def_find = "\\b(\\d{7})\\.(\\d+)\\b";
my $def_find = '\b(\d{7})\.(\d+)\b';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

### debug
my $dbg_01 = 0;

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    prt("Processing [$inf]...\n");
    my ($line,$inc,$lnn,$ext,$dir,$sdir,$msg,$tline);
    my ($ff,$sb,$ok,@arr,$type,$key,$tm,$ddir,$head);
    $lnn = 0;
    $dir = '';
    $sdir = '';
    my %types = ();
    my @list = ();
    while (defined($line = <INF>)) {
        chomp $line;
        $lnn++;
        if (($lnn % 100000)==0) {
            prt("$lnn\n");
        }
        $tline = trim_all($line);
        next if (length($tline) == 0);
        if ($line =~ /\s*Directory\s+of\s+/) {
            $dir = $line;
            $dir =~ s/\s*Directory\s+of\s+//;
        } elsif ($line =~ /$find_this/) {
            $inc = $1;
            $ext = $2;
            $msg = '';
            if ($sdir ne $dir) {
                $sdir = $dir;
                $ddir = " Directory of [$dir] ($lnn)";
            }
            prt("$lnn: $inc.$ext [$tline]\n") if ($dbg_01);
            $ok = 0;
            $ff = $dir."\\".$inc.".".$ext;
            if (-f $ff) {
                if ($sb = stat($ff)) {
                    if (open INPUT, "<$ff") {
                        if (defined($head = <INPUT>)) {
                            if (defined($type = <INPUT>)) {
                                if ($head =~ /^\#/) {
                                    $tm = get_YYYYMMDD($sb->mtime);
                                    $type = trim_all($type);
                                    if (!defined $types{$type}) {
                                        prt("New type [$type] $tm [$ff]\n");
                                        $types{$type} = 1;
                                        push(@list, [$ff, $type, $sb->mtime]);
                                    }
                                }
                            }
                        }
                        close INPUT;
                    }
                    #                   0           1    2      3
                    #push(@g_file_list, [$sb->mtime, $ff, $file, $sb->size]);
                    $ok = 1;
                }
            }
            if (!$ok) {
                pgm_exit(1,"ERROR: Failed to stat file...[$ff]\n");
            }
        }
    }
    close INF;
    prt("Done $lnn lines\n");
    $ok = scalar keys(%types);
    prt("Found $ok different types...\n");
    foreach $key (keys %types) {
        prt("$key ");
    }
    prt("\n");
    foreach $key (@list) {
        $ff = ${$key}[0];
        $type = ${$key}[1];
        $tm = get_YYYYMMDD(${$key}[2]);
        prt("$type $tm [$ff]\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
prt( "$pgmname: in [$cwd]: Hello, World...\n" );
process_in_file($in_file);
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2011-05-31\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $def_dbg_on) {
        $in_file = $def_file;
        $find_this = $def_find;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (length($find_this) ==  0) {
        pgm_exit(1,"ERROR: No 'find' item found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }


}

# eof - template.pl
