#!/perl -w
# NAME: gensource.pl
# AIM: VERY SPECIFIC - take a file list, and generate DSP SOURCE lines
# 2009/09/22  - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;
use File::Basename;
require 'fgutils.pl' or die "Unable to load fgutils.pl...\n";
require 'fgdsphdrs02.pl' or die "Unable to load fgdsphdrs02.pl...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my @file_list = qw( block_match.cpp
block_match.h
downconvert.cpp
downconvert.h
downconvert_mmx.cpp
Makefile.am
Makefile.in
me_mode_decn.cpp
me_mode_decn.h
me_subpel.cpp
me_subpel.h
me_utils.cpp
me_utils.h
me_utils_mmx.cpp
me_utils_mmx.h
pixel_match.cpp
pixel_match.h );

my $rel_dir = "..\\..\\libdirac_motionest";

sub get_src_block($) {
    my ($src) = shift;
    my $src_blk = <<EOF;
# Begin Source File

SOURCE=$src
# End Source File
EOF
    return $src_blk;
}

sub is_c_source_ext($) {
   my ($fil) = shift;
	my ($nm, $dir, $ext) = fileparse( $fil, qr/\.[^.]*/ );
   my $lce = lc($ext);
   if (($lce eq '.c') || ($lce eq '.cxx') || ($lce eq '.cpp') || ($lce eq '.cc')) {
      return 1;
   }
   return 0;
}

sub is_h_source_ext($) {
   my ($fil) = shift;
	my ($nm, $dir, $ext) = fileparse( $fil, qr/\.[^.]*/ );
   my $lce = lc($ext);
   if (($lce eq '.h') || ($lce eq '.hxx') || ($lce eq '.hpp')) {
      return 1;
   }
   return 0;
}


sub process_list($$) {
    my ($rl,$dir) = @_;
    my ($fil);
    prt( "\nProcess C/C++ sources\n" );
    foreach $fil (sort @{$rl}) {
        if ( is_c_source_ext($fil) ) {
            prt( get_src_block("$dir\\$fil") );
        }
    }
    prt("\n");
    prt( "\nProcess header sources\n" );
    foreach $fil (sort @{$rl}) {
        if ( is_h_source_ext($fil) ) {
            prt( get_src_block("$dir\\$fil") );
        }
    }

    prt("\n");
    foreach $fil (@{$rl}) {
        if ( !(is_c_source_ext($fil) || is_h_source_ext($fil) ) ) {
            prt( "Skipped file [$fil]\n" );
        }
    }
}

process_list( \@file_list, $rel_dir );

close_log($outfile,1);
exit(0);

# eof
