#!/usr/bin/perl -w
# NAME: genspltable.pl
# AIM: VERY SPECIAL - just to get the TABLE in HTML
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 1;
my $in_dir = 'C:\HOMEPAGE\GA\fg';

my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        ###prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

#  // w010n40 - e000n50
#  // OZ east coast
#  //             s21
#  // e140s30 e150s30
#  //             s31
#  // e140s40 e150s40
sub add_oz_tiles($$$) {
    my ($src,$siz,$chk) = @_;
    my ($i, $j, $ii, $alt, $tit, $k, $url, $jj, $ff);
    my $attr = "width=\"" . $siz . "\" height=\"" . $siz . "\"";
    my $stg = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\" summary=\"Image holder\">\n";
    my $ew = "e";
    my $ns = "n";
   for ($j = -21; $j >= -40; $j--)
   {
      $stg .= "<tr>\n";
      $k = $j;
      $ns = "n";
      if ($j < 0) {
         $k = -$j;
         $ns = "s";
      }
      # setup LATITUDE
      $jj = ($k < 10) ? "0".$k : "".$k;

      for ($i = 140; $i < 160; $i++)
      {
        if ( $i < 0 ) {
          $k = -$i;
          $ii = ($k < 10) ? "00".$k : ($k < 100) ? "0".$k : "" . $k;
          $ew = "w";
        } else {
          $ii = ($i < 10) ? "00".$i : ($i < 100) ? "0".$i : "".$i;
          $ew = "e";
        }
        $tit = "" . $ew . $ii . $ns . $jj;
        $alt = "alt=\"" . $tit . "\"";
        $url = $src . "/" . $tit . ".png";
        $ff = $in_dir . "/" . $url;
        #//if (chk) {
        #//  got_img = 0;
        #//  testImage(url);
        #//  if (got_img == 0) {
        #//     url = "temp/4/blank.png";
        #//  }
        #//}
        #// stg += "<td><img src=\"" + src + "/" + tit + ".png\" " + attr + " " + alt + "><\/td>\n";
        if ( -f $ff ) {
            $stg .= "<td><img src=\"" . $url . "\" " . $attr . " " . $alt . "><\/td>\n";
        } else {
            # $stg .= "<td>&nbsp;<\/td>\n";
            $stg .= "<td><img src=\"images/blue01.png\" ".$attr." ".$alt."><\/td>\n";
        }
      }
      $stg .= "<\/tr>\n";
   }
   $stg .= "<\/table>\n";
   return $stg;
   #document.write(stg);
  }

sub add_eu_tiles($$$) {
    my ($src,$siz,$chk) = @_;
    my ($i, $j, $ii, $alt, $tit, $k, $url, $ff);
    my $attr = "width=\"" . $siz . "\" height=\"" . $siz . "\"";
    my $stg = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\" summary=\"Image holder\">\n";
    my $ew = "e";
    my $ns = "n";
   for ($j = 59; $j >= 40; $j--)
   {
      $stg .= "<tr>\n";
      for ($i = -10; $i < 10; $i++)
      {
        if ( $i < 0 ) {
          $k = -$i;
          $ii = ($k < 10) ? "00".$k : ($k < 100) ? "0".$k : "".$k;
          $ew = "w";
        } else {
          $ii = ($i < 10) ? "00".$i : ($i < 100) ? "0".$i : "".$i;
          $ew = "e";
        }
        $tit = "" . $ew . $ii . $ns . $j;
        $alt = "alt=\"" . $tit . "\"";
        #// stg += "<td>Tile e" + ii + "n" + j + "<\/td>\n";
        $url = $src . "/" . $tit . ".png";
        #//if (chk) {
        #//  got_img = 0;
        #//  testImage(url);
        #//  if (got_img == 0) {
        #//     url = "temp/4/blank.png";
        #//  }
        #//}
        #// stg += "<td><img src=\"" + src + "/" + tit + ".png\" " + attr + " " + alt + "><\/td>\n";
        $ff = $in_dir . "/" . $url;
        if ( -f $ff ) {
            $stg .= "<td><img src=\"" . $url . "\" " . $attr . " " . $alt . "><\/td>\n";
        } else {
            # $stg .= "<td>&nbsp;<\/td>\n";
            $stg .= "<td><img src=\"images/blue01.png\" ".$attr." ".$alt."><\/td>\n";
        }
      }
      $stg .= "<\/tr>\n";
   }
   $stg .= "<\/table>\n";
   return $stg; # document.write(stg);
  }


sub add_all_tiles() {
    # my $stg = "<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\" summary=\"Image holder\">\n";
    my $stg = "<table border=\"1\" cellpadding=\"2\" cellspacing=\"2\" align=\"center\" summary=\"Image holder\">\n";
    $stg .= "<tr>\n";
    $stg .= "<td align=\"center\">\n";
    $stg .= "Central Europe";
    $stg .= "<\/td><td align=\"center\">KSFO<\/td><td align=\"center\">\n";
    $stg .= "Eastern Australia";
    $stg .= "<\/td>\n";
    $stg .= "<\/tr>\n";
    $stg .= "<tr>\n";
    $stg .= "<td>\n";
    # document.write(stg);
    $stg .= add_eu_tiles("images/4",16,0);
    # stg = "<\/td><td>&nbsp;<\/td><td>\n";
    $stg .= "<\/td>\n";
    $stg .= "<td valign=\"top\">\n";
    $stg .= "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\" summary=\"Image holder\">";
    $stg .= "<tr><td>";
    $stg .= "<img src=\"images/6/w123n37.png\" width=\"64\" height=\"64\" alt=\"SF1\">";
    $stg .= "<\/td><td>";
    $stg .= "<img src=\"images/6/w122n37.png\" width=\"64\" height=\"64\" alt=\"SF2\">";
    $stg .= "<\/td><\/tr><\/table>";
    $stg .= "<\/td>";
    $stg .= "<td>";
    #document.write(stg);
    $stg .= add_oz_tiles("images/4",16,0);
    $stg .= "<\/td><\/tr>";
    $stg .= "<\/table>\n";
    # document.write(stg);
    prt($stg);
  }


#########################################
### MAIN ###
##parse_args(@ARGV);
##rt( "$pgmname: in [$cwd]: Hello, World...\n" );
##process_in_file($in_file);
add_all_tiles();
pgm_exit(0,"");
########################################

# eof - genspltable.pl
