#!/usr/bin/perl -w
# NAME: getclopts.pl
# AIM: SPECIFIC - Read cl-options.txt file, and convert to hash
# 07/01/2011 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $in_file = '';

my $debug_on = 0;
my $def_file = 'cl-options.txt';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$len,$part1,$part2,$opt,$val,$tline,@arr,$ln);
    $lnn = 0;
    my %hash = ();
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        next if ($line =~ /^\s/);
        $tline = trim_all($line);
        next if (length($tline) == 0);
        @arr = ();
        $len = length($line);
        if (($len > 40) && (substr($line,40,1) eq '/')) {
            $part1 = substr($line,0,40);
            $part2 = substr($line,40);
            push(@arr,$part1);
            push(@arr,$part2);
        } else {
            push(@arr,$line);
        }
        foreach $ln (@arr) {
            if ($ln =~ /^(\S+)\s+(.+)$/) {
                $opt = $1;
                $val = trim_all($2);
                if (length($val) == 0) {
                    prtw("WARNING: Discarded item with no value [$ln]\n");
                    next;
                } else {
                    if (defined $hash{$opt}) {
                        prtw("WARNING: Discarded dup option [$ln]\n");
                    } else {
                        $hash{$opt} = $val;
                    }
                }
                $opt .= " " while (length($opt) < 6);
                prt("$opt [$val]\n");
            } else {
                prt("$lnn: $ln\n");
            }
        }
    }
    return \%hash;
}

sub show_ref_hash($) {
    my ($rh) = @_;
    my @arr = keys(%{$rh});
    my $cnt = scalar @arr;
    my ($key,$val,$min,$len);
    prt("Display of $cnt keys...\n");
    $min = 0;
    foreach $key (sort keys %{$rh}) {
        $len = length($key);
        $min = $len if ($len > $min);
    }
    foreach $key (sort keys %{$rh}) {
        $val = ${$rh}{$key};
        $key .= " " while (length($key) < $min);
        prt("$key [$val]\n");
    }
}


#########################################
### MAIN ###
#parse_args(@ARGV);
#prt( "$pgmname: in [$cwd]: Hello, World...\n" );
my $ref_hash = process_in_file($def_file);
show_ref_hash($ref_hash);
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-09-11\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

# eof - template.pl
