#!/perl -w
# NAME: gethost01.pl
# AIM: Get the HOST IP address, using the domain name 
# 13/08/2011 - minor update - called by getip.bat
use strict;
use warnings;
use Socket;

my @names = ();
my $dbg1 = 0;	# for testing without input
my $name = '';
if (@ARGV) {
	parse_args(@ARGV);
} else {
	if ($dbg1) {
		@names = qw( nowhereknown.com geoffmclane.com home.exetel.com.au yahoo.com google.com macpcfirstaid.com
  adsl-1-169.lo1.lns1.server-access.com);
	} else {
		die "NO INPUT! Input a domain name to find the IP address ...\n";
	}
}

foreach $name (@names) {
	showIPAddress($name);
}
exit(0);

sub showIPAddress {
	my ($nm) = shift;
	print "Resolving [$nm] ...\n";
	my @addr = gethostbyname($nm);
	my $cnt = 0;
	if( !@addr ) {
		print "CAN NOT RESOLVE $nm ... $! ...\n";
		return;
	}
	@addr = map { inet_ntoa($_) } @addr[4 .. $#addr];
	foreach my $k (@addr) {
		$cnt++;
		print "$cnt: Resolves to IP [$k]\n";
	}
}

sub parse_args {
	my (@av) = @_;
	my $cnt = 0;
	while (@av) {
		$cnt++;
		my $a = shift @av; # get and move to next
		if ($a =~ /.*\.{1}.*/) {
			push(@names, $a);
		} else {
			die "Input [$a] does not appear to be an IP address of the form aaa.bbb ...\n";
		}
	} # while arguments
}


# eof - gethost01.pl
