#!/perl -w
# NAME: getvars.pl
# AIM: Read the error output, and build a set of names used ...
use strict;
use warnings;
##require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
require 'fgutils.pl' or die "Unable to load fgutils.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $in_file = 'templist.txt';

prt( "$0 ... processing $in_file ...\n" );

process_file($in_file);

close_log($outfile,1);
exit(0);

########################
sub process_file {
    my ($inf) = shift;
    my @list = ();
    my (@lines, $line, $lncnt, $i, $itm);
    if (open INF, "<$inf") {
        @lines = <INF>;
        close INF;
        $lncnt = scalar @lines;
        prt( "Processing $lncnt lines...\n" );
        # expect lines like
        # Global symbol "$act_vcproj" requires explicit package name at fggetxmlsources.pl line 72.
        for ($i = 0; $i < $lncnt; $i++) {
            $line = $lines[$i];
            if ($line =~ /Global\s+symbol\s+"(.+)"\s+requires\s+explicit/) {
                $itm = $1;
                if (! is_in_array($itm,@list)) {
                    ###prt( "$itm\n" );
                    push(@list,$itm);
                }
            }
        }
        foreach $line (sort @list) {
            if ($line =~ /^\$/) {
                if ($line =~ /dbg/i) {
                    prt( "my $line = 0;\n" );
                } else {
                    prt( "my $line = '';\n" );
                }
            } elsif ($line =~ /^\%/) {
                prt( "my $line = ();\n" );
            } elsif ($line =~ /^\@/) {
                prt( "my $line = ();\n" );
            } else {
                prt("$line - WHAT IS THIS?\n");
            }
        }


    } else {
        prt("ERROR: Can NOT open [$inf] ...\n");
    }
}

# eof
