#!/usr/bin/perl -w
# NAME: imgconvert.pl
# AIM: Using imagemagick 'convert' convert full jpg images to thumbnils
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use File::Spec; # use File::Spec; # File::Spec->rel2abs($rel); # we are IN the SLN directory, get ABSOLUTE from RELATIVE
use File::Copy;
use File::stat;
use Cwd;
use IO::Handle;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl'! Check \@INC veriable.\n";
require 'imgsize.pl' or die "Unable to load 'imgsize.pl'! Check \@INC veriable.\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $in_file = '';
my $dst_dir = '';
my $thumb_dir = '';
my $html_dir = '';
my $user_name = '';
my $overwrite = 0;
my $max_user_sub = 0;
my $max_width = 216;  # 3456 / 16
my $max_height = 162; # 2592 / 16
my $max_columns = 4;

my $debug_on = 1;
#my $def_file = 'C:\Documents and Settings\Geoff McLane\My Documents\My Pictures\Pan\20110622\P1010325.JPG';
my $def_file = 'C:\Documents and Settings\Geoff McLane\My Documents\My Pictures\Pan\20110622';
my $def_html_dir = 'C:\HOMEPAGE\GA\travel\greece';
my $def_dir = 'C:\HOMEPAGE\GA\travel\greece\images';
my $def_unm = 'grec-';
my @graf_ext = qw( .jpg .jpeg .gif .png .bmp .ico .mpg .tif );

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;
my $done_version = 0;
my $common_name = '';

### DEBUG
my $dbg_01 = 0;

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        ###prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub get_stdin($) {
    my ($rc) = shift;
    ${$rc} = <STDIN>;
}

sub wait_key_input($) {
    my ($msg) = shift;
    if (length($msg)) {
        prt($msg);
    }
    my $char = '';
    get_stdin(\$char);
    if ($char =~ /^y/i) {
        return 0;
    }
    return 1;
}

sub test_identify($) {
    my $rver = shift;
    my $iret = 1;
    my $cmd = "identify -version |";
    if (open (IDT, $cmd)) {
        my @lines = <IDT>;
        close IDT;
        my ($line,$cnt);
        $cnt = scalar @lines;
        prt("[01] Ran [$cmd]. For $cnt lines\n") if ($dbg_01);
        foreach $line (@lines) {
            # Version: ImageMagick 6.3.5 07/31/07 Q16 http://www.imagemagick.org
            if ($line =~ /ImageMagick\s+([\d\.]+)/) {
                ${$rver} = $1;
                $iret = 0;
                last;
            }
        }
    } else {
        prt("FAILED to run command [$cmd]\n");
    }
    return $iret;
}

sub test_convert($) {
    my $rver = shift;
    my $iret = 1;
    my $cmd = "convert -version |";
    if (open (CVT, $cmd)) {
        my @lines = <CVT>;
        close CVT;
        my ($line,$cnt);
        $cnt = scalar @lines;
        prt("[01] Ran [$cmd]. For $cnt lines\n") if ($dbg_01);
        foreach $line (@lines) {
            # Version: ImageMagick 6.3.5 07/31/07 Q16 http://www.imagemagick.org
            if ($line =~ /ImageMagick\s+([\d\.]+)/) {
                ${$rver} = $1;
                $iret = 0;
                last;
            }
        }
    } else {
        prt("FAILED to run command [$cmd]\n");
    }
    return $iret;
}

sub get_imagmagick_versions() {
    if ($done_version) {
        return;
    }
    my $veri = '';
    my $verc = '';
    if (test_identify(\$veri)) {
        pgm_exit(1,"ERROR: Unable to get 'identify' version!\n"); 
    }
    prt("Ran Imagemagick 'identify', version $veri\n");
    if (test_convert(\$verc)) {
        pgm_exit(1,"ERROR: Unable to get 'convert' version!\n"); 
    }
    prt("Ran Imagemagick 'convert', version $verc\n");
    $done_version = 1;
}

sub process_in_file($) {
    my ($inf) = @_;
    get_imagmagick_versions();
}

sub is_my_ext($$$) {
    my ($fil,$rext,$ra) = @_;
    my ($ext,$cnt);
    $cnt = 0;
    foreach $ext (@{$ra}) {
        $cnt++;
        if ($fil =~ /$ext$/i) {
            ${$rext} = $ext;
            return $cnt;
        }
    }
    return 0;
}

sub is_graf_ext($$) {
    my ($fil,$rext) = @_;
    return( is_my_ext($fil, $rext, \@graf_ext) );
}

sub get_common_name($) {
    my ($nam) = @_;
    my $nc = '';
    my ($len1,$len2,$len,$ch1,$ch2,$i);
    $len1 = length($common_name);
    if ($len1) {
        $nc = '';
        $len2 = length($nam);
        $len = ($len1 < $len2) ? $len1 : $len2;
        for ($i = 0; $i < $len; $i++) {
            $ch1 = substr($common_name,$i,1);
            $ch2 = substr($nam,$i,1);
            last if ($ch1 ne $ch2);
            $nc .= $ch1;
        }
        $common_name = $nc;
    } else {
        $common_name = $nam;
    }
}

sub get_image_ratio($$$) {
    my ($isz,$rimgSx,$rimgSy) = @_;
    my $targwid = $max_width;
    my $targhgt = $max_height;
    my $iwd = im_get_image_width($isz);
    my $iht = im_get_image_height($isz);
    my $ratio = $iwd / $iht;
    ${$rimgSx} = $iwd;
    ${$rimgSy} = $iht;
    if (($iwd > $targwid) || ($iht > $targwid)) {
        if ($ratio > 1) {   # width > height
            ${$rimgSx} = $targwid;
            ${$rimgSy} = int($targwid / $ratio);
	    } else {
            # height > width = set target height, adjust width accordingly
			${$rimgSx} = int($targhgt * $ratio);
			${$rimgSy} = $targhgt;
        }
    }
    # $attr =  "  width=\"$imgSx\"";
    # $attr .= "  height=\"$imgSy\"";
	# $const = "".$imgSx."x".$imgSy;
}

sub ensure_path_tail_u($) {
    my ($rpath) = shift;
    ${$rpath} = path_d2u(${$rpath});
    if ( !(${$rpath} =~ /\/$/) ) {
        ${$rpath} .= "/";
    }
}
sub ensure_path_tail_d($) {
    my ($rpath) = shift;
    ${$rpath} = path_u2d(${$rpath});
    if ( !(${$rpath} =~ /\\$/) ) {
        ${$rpath} .= "\\";
    }
}

sub get_html_head() {
    my $htm = <<EOF;

<html>
<head>
<title>html file</title>
</head>
<body>
<h1 align="center">Image table</h1>
<center>
<table summary="list of images" cellpadding="0" cellspacing="0" border="0" align="center">

EOF
    return $htm;

}

sub get_html_tail() {
    my $htm = <<EOF;
</table>
</center>
</body>
</html>

EOF
    return $htm;
}


sub process_in_dir($) {
    my ($dir) = @_;
    get_imagmagick_versions();
    my @gfiles = ();
    my ($file,$ff,$cnt,$siz,$min,$len,$ccnt,$max,$item,$i,$ext);
    my ($nm,$dd,$ex,$sfil,$imgSx,$imgSy,$tn,$sb,$nn);
    my ($cmd1,$cmd2,$common);
    my ($skip_img,$skip_thumb);
    my $dfile = '';
    my $dthumb = '';
    my $do_sub = 0;
    my $total_size = 0;
    my $ddir = $dst_dir;
    my $tdir = $thumb_dir;
    my $hdir = $html_dir;
    my $html = '';
    my ($reldir1,$reldir2,$reldir3);
    my $wrap = 0;
    $min = 0;
    my $html_i = '';
    my $html_t = '';
    my ($html_file, $html_img, $html_thumb, $name);
    my %sizes = ();
    if (opendir(DIR,$dir)) {
        my @files = readdir(DIR);
        closedir(DIR);
        $cnt = scalar @files;
        prt("Found $cnt items in [$dir]...\n");
        $cnt = 0;
        # ensure all DOS paths
        ensure_path_tail_d(\$dir);
        ensure_path_tail_d(\$ddir);
        ensure_path_tail_d(\$tdir);
        ensure_path_tail_d(\$hdir);
        $html_file = $hdir."temphtml.htm";
        $html_file = "\"".$html_file."\"" if ($html_file =~ /\s/);
        $html_img = $ddir."tempindex.htm";
        $html_img = "\"".$html_img."\"" if ($html_img =~ /\s/);
        $html_thumb = $tdir."tempindex.htm";
        $html_thumb = "\"".$html_thumb."\"" if ($html_thumb =~ /\s/);
        foreach $file (@files) {
            next if ($file eq '.');
            next if ($file eq '..');
            $ext = '';
            next if (!is_graf_ext($file,\$ext));
            $ff = $dir.$file;
            ($nm,$dd,$ex) = fileparse($file , qr/\.[^.]*/ );
            if ((-f $ff) && ($sb = stat($ff))) {
                get_common_name($nm);
                $tn = $nm."-t";
                #             0   1     2    3   4   5  6         7
                push(@gfiles,[$ff,$file,$ext,$nm,$tn,"",$sb->size,""]);
                $total_size += $sb->size;
                $cnt++;
                $len = length($file);
                $min = $len if ($len > $min);
            } else {
                pgm_exit(1,"ERROR: Can NOT locate [$ff]!\n");
            }
        }

        $nn = get_nn($total_size);
        prt("Found $cnt items with graphic extent... $nn bytes (".util_bytes2ks($total_size).") ");
        $common = $common_name;
        if (length($common) && length($user_name)) {
            if ($max_user_sub && (length($common) > $max_user_sub)) {
                $common = substr($common,0,$max_user_sub);
            }
            $do_sub = 1;
            prt("Doing sub of [$common] with user [$user_name] ");
        }
        prt("\n");
        $cnt = 0;
        $max = scalar @gfiles;
        $skip_img = 0;
        $skip_thumb = 0;
        for ($i = 0; $i < $max; $i++) {
            $item = $gfiles[$i];
            $ff = ${$item}[0];
            $file = ${$item}[1];
            $ext = ${$item}[2];
            ($nm,$dd,$ex) = fileparse($file , qr/\.[^.]*/ );
            $tn = $nm."-t";
            # $nm = ${$item}[3];
            if ($do_sub) {
                # if (length($common_name) && length($user_name)) {
                $nm =~ s/^$common/$user_name/;
                $tn = $nm."-t";
            }
            $name = $nm;
            $nm .= $ext;
            $tn .= $ext;
            $dfile = $ddir.$nm;
            $dthumb = $tdir.$tn;
            $cnt++;
            $ccnt = sprintf("%4d of %d",$cnt,$max);
            $siz = im_get_image_size($ff);
            if (length($siz)) {
                get_image_ratio($siz,\$imgSx,\$imgSy);
                $file .= ' ' while (length($file) < $min);
                ${$item}[3] = $nm;
                ${$item}[4] = $tn;
                ${$item}[5] = "${imgSx}X${imgSy}";
                ${$item}[6] = $siz;
                prt("$ccnt: $file $siz $ext $nm ${imgSx}X${imgSy} $tn\n");
                $ff = "\"".$ff."\"" if ($ff =~ /\s/);
                $dfile = "\"".$dfile."\"" if ($dfile =~ /\s/);
                $dthumb = "\"".$dthumb."\"" if ($dthumb =~ /\s/);
                $cmd1 = "copy $ff $dfile";
                $cmd2 = "convert -resize ${imgSx}X${imgSy} $ff $dthumb";
                if ($overwrite || (! -f $dfile)) {
                    prt("CMD: $cmd1\n");
                } else {
                    prt("Destination already exists, and no overwrite...\n");
                    $skip_img++;
                }
                if ($overwrite || (! -f $dthumb)) {
                    prt("CMD: $cmd2\n");
                } else {
                    prt("Destination thumb exists, and no overwrite...\n");
                    $skip_thumb++;
                }
                # 	my ($target, $fromdir) = @_;
                $reldir1 = get_relative_path_reversed_words($ddir,$html_dir);
                $reldir2 = get_relative_path_reversed_words($tdir,$html_dir);
                $reldir3 = get_relative_path_reversed_words($tdir,$ddir);
                ensure_path_tail_u(\$reldir1);
                ensure_path_tail_u(\$reldir2);
                ensure_path_tail_u(\$reldir3);
                $reldir1 .= $nm;
                $reldir2 .= $tn;
                $reldir3 .= $tn;
                $reldir1 = path_d2u($reldir1);
                $reldir2 = path_d2u($reldir2);
                $reldir3 = path_d2u($reldir3);
                prt("Rel1: [$reldir1] image, Rel2: [$reldir2] thumb, Rel3: [$reldir3] d2t\n");
            } else {
                prtw("WARNING: Failed to get size of [$ff]\n");
            }
        }
        if ($skip_img) {
            prt("Skipping $skip_img copying due to no overwrite.\n");
        }
        if ($skip_thumb) {
            prt("Skipping $skip_thumb thumb generation due to no overwrite.\n");
        }
        $cnt = $max - $skip_img;
        prt("On ok, will process $cnt image copies.\n");
        # ==============================================================
        if (wait_key_input("Continue with generation? Only y to continue : ")) {
            pgm_exit(1,"Abandoned...\n");
        }
        # ===============================================================

        $cnt = 0;
        $max = scalar @gfiles;
        for ($i = 0; $i < $max; $i++) {
            $item = $gfiles[$i];
            $ff = ${$item}[0];
            $file = ${$item}[1];
            $ext = ${$item}[2];
            $siz = ${$item}[6];
            ($nm,$dd,$ex) = fileparse($file , qr/\.[^.]*/ );
            $tn = $nm."-t";
            # $nm = ${$item}[3];
            if ($do_sub) {
                # if (length($common_name) && length($user_name)) {
                $nm =~ s/^$common/$user_name/;
                $tn = $nm."-t";
            }
            $name = $nm;
            $nm .= $ext;
            $tn .= $ext;
            $dfile = $ddir.$nm;
            $dthumb = $tdir.$tn;
            $cnt++;
            $ccnt = sprintf("%4d of %d",$cnt,$max);
            # $siz = im_get_image_size($ff);
            if (length($siz)) {
                get_image_ratio($siz,\$imgSx,\$imgSy);
                $file .= ' ' while (length($file) < $min);
                ${$item}[3] = $nm;
                ${$item}[4] = $tn;
                ${$item}[5] = "${imgSx}X${imgSy}";
                prt("\n$ccnt: $file $siz $ext $nm ${imgSx}X${imgSy} $tn\n");
                $ff = "\"".$ff."\"" if ($ff =~ /\s/);
                $dfile = "\"".$dfile."\"" if ($dfile =~ /\s/);
                $dthumb = "\"".$dthumb."\"" if ($dthumb =~ /\s/);
                $cmd1 = "copy $ff $dfile";
                $cmd2 = "convert -resize ${imgSx}X${imgSy} $ff $dthumb";
                if ($overwrite || (! -f $dfile)) {
                    prt("CMD: $cmd1\n");
                    #copy("$ff","$dfile") or pgm_exit(1,"ERROR: Command FAILED!");
                    system($cmd1);
                    if (! -f $dfile) {
                        pgm_exit(1,"COPY failed to create destination file!\n");
                    }
                } else {
                    prt("Destination already exists, and no overwrite...\n");
                }
                if ($overwrite || (! -f $dthumb)) {
                    prt("CMD: $cmd2\n");
                    system($cmd2);
                    if (! -f $dthumb) {
                        pgm_exit(1,"ERROR: Convert FAILED to create new file!\n");
                    }
                } else {
                    prt("Destination thumb exists, and no overwrite...\n");
                }
                # 	my ($target, $fromdir) = @_;
                $reldir1 = get_relative_path_reversed_words($ddir,$html_dir);
                $reldir2 = get_relative_path_reversed_words($tdir,$html_dir);
                $reldir3 = get_relative_path_reversed_words($tdir,$ddir);
                ensure_path_tail_u(\$reldir1);
                ensure_path_tail_u(\$reldir2);
                ensure_path_tail_u(\$reldir3);
                $reldir1 .= $nm;
                $reldir2 .= $tn;
                $reldir3 .= $tn;
                $reldir1 = path_d2u($reldir1);
                $reldir2 = path_d2u($reldir2);
                $reldir3 = path_d2u($reldir3);
                prt("Rel1: [$reldir1] image, Rel2: [$reldir2] thumb, Rel3: [$reldir3] d2t\n");
                if ($wrap == 0) {
                    $html .= "<tr>\n";
                    $html_i .= "<tr>\n";
                    $html_t .= "<tr>\n";
                }
                $html .= "<td align=\"center\"><a name=\"$name\" target=\"_blank\" href=\"$reldir1\"><img src=\"$reldir2\" alt=\"$reldir1\"></a></td>\n";
                $html_i .= "<td align=\"center\"><a name=\"$name\" target=\"_blank\" href=\"$nm\"><img src=\"$reldir3\" alt=\"$reldir1\"></a></td>\n";
                $html_t .= "<td align=\"center\"><a name=\"$name\" target=\"_blank\" href=\"../$nm\"><img src=\"$tn\" alt=\"$reldir1\"></a></td>\n";
                $wrap++;
                if ($wrap == $max_columns) {
                    $html .= "</tr>\n";
                    $html_i .= "</tr>\n";
                    $html_t .= "</tr>\n";
                    $wrap = 0;
                }
            } else {
                prtw("WARNING: Failed to get size of [$ff]\n");
            }
        }
        if ($wrap) {
            while ($wrap < $max_columns) {
                $html .= "<td>&nbsp;</td>\n";
                $html_i .= "<td>&nbsp;</td>\n";
                $html_t .= "<td>&nbsp;</td>\n";
                $wrap++;
            }
            $html .= "</tr>\n";
            $html_i .= "</tr>\n";
            $html_t .= "</tr>\n";
        }
        $html = get_html_head().$html;
        $html .= get_html_tail();
        $html_i = get_html_head().$html_i;
        $html_i .= get_html_tail();
        $html_t = get_html_head().$html_t;
        $html_t .= get_html_tail();
        write2file($html_i,$html_img);
        write2file($html_t,$html_thumb);
        write2file($html,$html_file);
        prt("Written HTML to [$html_file]\n");
        system($html_file);
    }
}


#########################################
### MAIN ###
parse_args(@ARGV);
# prt( "$pgmname: in [$cwd]: Hello, World...\n" );
if (-d $in_file) {
    process_in_dir($in_file);
} elsif (-f $in_file) {
    process_in_file($in_file);
} else {
    pgm_exit(1,"ERROR: Input [$in_file] NOT directory, or file!\n");
}
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-09-11\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
    prt(" --src <file|dir>  = Set input item.\n");
    prt(" --dst <dir>       = Set desitnation directory.\n");
    prt(" --thumb <dir>     = Set desitnation 'thumb' directory.\n");
    prt(" --width <ddd>     = Set max. width/height. def=$max_width, maintaining ratio.\n");
    prt(" --html <dir>      = Set destination for the HTML file.\n");
    prt(" --ovr             = Set to overwrite existing file, which are skipped by default.\n");
    prt(" --ll              = Set to load output log at end.\n");
    prt(" --sub <name>      = Substitute the common name, up to maximum 'n', if given.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^src/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $in_file = File::Spec->rel2abs($sarg); # we are IN the Cwd directory, get ABSOLUTE from RELATIVE
                prt("Set input to [$in_file]\n");
            } elsif ($sarg =~ /^dst/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $dst_dir = File::Spec->rel2abs($sarg); # we are IN the Cwd directory, get ABSOLUTE from RELATIVE
                prt("Set destination to [$dst_dir]\n");
            } elsif ($sarg =~ /^thumb/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $thumb_dir = File::Spec->rel2abs($sarg); # we are IN the Cwd directory, get ABSOLUTE from RELATIVE
                prt("Set destination thumb directory to [$thumb_dir]\n");
            } elsif ($sarg =~ /^html/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $html_dir = File::Spec->rel2abs($sarg); # we are IN the Cwd directory, get ABSOLUTE from RELATIVE
                prt("Set destination HTML directory to [$html_dir]\n");
            } elsif ($sarg =~ /^ovr/) {
                $overwrite = 1;
                prt("Set to ovewrite existing files.\n");
            } elsif ($sarg =~ /^ll/) {
                $load_log = 1;
                prt("Set to load lg at end.\n");
            } elsif ($sarg =~ /^width/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                if ($sarg =~ /^\d+$/) {
                    $max_width = $sarg;
                    prt("Set max image width to [$max_width]\n");
                } else {
                    pgm_exit(1,"ERROR: Invalid argument [$arg]! Can ONLY be followed by a NUMBER! Got [$sarg]! Try -?\n");
                }
            } elsif ($sarg =~ /^sub/) {
                if ($sarg =~ /^sub(\d+)/) {
                    $max_user_sub = $1;
                    prt("Set maximum sub common size to $max_user_sub\n");
                }
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $user_name = $sarg;
                prt("Set sub common name with [$user_name]\n");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = File::Spec->rel2abs($arg); # we are IN the Cwd directory, get ABSOLUTE from RELATIVE
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    # some DEBUG ONLY overrides...
    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = File::Spec->rel2abs($def_file);
        prt("Set input to DEBUG [$in_file]\n");
    }
    if ((length($dst_dir) ==  0) && $debug_on) {
         $dst_dir = File::Spec->rel2abs($def_dir);
         prt("Set destination to DEBUG [$dst_dir]\n");
    }
    if ((length($html_dir) ==  0) && $debug_on) {
         $html_dir = File::Spec->rel2abs($def_html_dir);
         prt("Set destination HTML to DEBUG [$html_dir]\n");
    }
    if ((length($user_name) ==  0) && $debug_on) {
         $user_name = $def_unm;
         prt("Set name substitution to DEBUG [$user_name]\n");
    }
    if ($debug_on) {
        $load_log = 1;
    }

    # check user paramaters
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (length($dst_dir) ==  0) {
        pgm_exit(1,"ERROR: No DESTINATION directory found in command!\n");
    } elsif (! -d $dst_dir) {
        pgm_exit(1,"ERROR: DESTINATION directory [$dst_dir] NOT VALID!\n");
    }
    if (length($thumb_dir) == 0) {
        $thumb_dir = $dst_dir;
        $thumb_dir .= "\\" if ( !($thumb_dir =~ /(\\|\/)$/) );
        $thumb_dir .= "thumbs";
    }
    if (-d $thumb_dir) {
        prt("Thumb file output to [$thumb_dir]...\n");
    } else {
        pgm_exit(1,"ERROR: DESTINATION THUMB directory [$thumb_dir] NOT VALID!\n");
    }
    if (! -f $in_file) {
        if (! -d $in_file) {
            pgm_exit(1,"ERROR: Unable to find input [$in_file], as file or directory! Check name, location...\n");
        }
    }
}

# eof - imgconvert.pl
