#!/perl -w
# NAME: imgratio.pl 
# AIM: Play with MATH, to re-size an image, keeping the aspect ratio ...
# 08/12/2008 - add 2 more examples
# 17/08/2007 - geoff mclane - geoffiar.net/mperl/samples
use strict;
use warnings;
my $width = 707;
my $height = 519;
my $width2 = 1134;
my $height2 = 751;
my $width3 = 1701;
my $height3 = 2179;

my $targmax = 100;

show_math( $width, $height, $targmax );
show_math( $width3, $height3, $targmax );
show_math( $width2, $height2, $targmax );

sub show_math {
    my ($wid, $hgt, $tw) = @_;
    my $ratio = $wid / $hgt;
    my ($imgSx, $imgSy);
    if($ratio > 1) {
	    $imgSx = $tw;
    	$imgSy = int( ($tw / $ratio) + 0.5 );
    } else {
	    $imgSx = int( ($tw * $ratio) + 0.5 );
	    $imgSy = $tw;
    }

    print "From $wid x $hgt, TARGET maximum $tw, gives $imgSx x $imgSy ... ratio $ratio\n";

    # use HEIGHT
    $imgSx = int( ($tw * $ratio) + 0.5 );
    $imgSy = $tw;
    print "Set HEIGHT: gives $imgSx x $imgSy ...\n";
    # use WIDTH
    $imgSx = $tw;
    $imgSy = int( ($tw / $ratio) + 0.5 );
    print "Set  WIDTH: gives $imgSx x $imgSy ...\n";
}

# perl dealing with images
# imglist.pl 
# AIM: Given a folder, search for ALL image files
#
# genimgindex.pl - (see earlier simpe imgindex.pl)
# AIM: Given a BASE folder, seek all IMAGE files, and build
# an 'index' table of images, as HTML ...
#
# imgindex.pl
# AIM: To read a FOLDER, finding all image files, and preparing a simple table index
#
# getimgsize.pl
# AIM: Given a folder, use Imagemagick identify to get the image sizes
# and write a tempjs.js with the image sizes in an array
#
# imagemagic.pl
# AIM: Test of ImageMagic installation - use Image::Magick;
#
# imgalt02.pl
# AIM: To extract the <img alt="..." atribute of each image,
# in all (both) English and French version ...
# Read a JetPhoto, fix each entry in the 
# studio.plist XML file ... each has to be inserted as 
# <key>Description</key>
# <string>English description ... French Description</string>
# and save the new studio.plist file ...
#
# imgsize.pl - MODULE
# AIM: Use external imagemagick 'identify.exe' to get an image SIZE geometry
# Services: im_get_image_size( file_name ); returns geometry nnnnxnnnn
# im_get_image_width( geometry ); returns WIDTH
# im_get_image_height( geometry ); returns HEIGHT
#
# imgratio.pl
# AIM: Play with MATH, to re-size an image, keeping the aspect ratio ...
#
# eof - imgratio.pl
