#!/usr/bin/perl -w
# NAME: ll2dms.pl
# AIM: Convert a lat, lon to degree, minutes, seconds
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $vers = "0.0.1 2011-07-27";
my $load_log = 0;
my $in_file = '';

my $bad_latlon = 200;
my $usr_lat = $bad_latlon;
my $usr_lon = $bad_latlon;

my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        ###prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub process_lat_lon() {
    my ($ns,$ew,$degs,$mins,$lat,$lon);
    if ($usr_lat != $bad_latlon) {
        $lat = $usr_lat;
        $ns = 'N';
        if ($lat < 0) {
            $ns = 'S';
            $lat *= -1;
        }
        $degs = int($lat);
        $mins = ($lat - $degs) * 60;
        prt("$usr_lat = ${ns}${degs} $mins\n");
    }
    if ($usr_lon != $bad_latlon) {
        $lon = $usr_lon;
        $ew = 'E';
        if ($lon < 0) {
            $ew = 'W';
            $lon *= -1;
        }
        $degs = int($lon);
        $mins = ($lon - $degs) * 60;
        prt("$usr_lon = ${ew}${degs} $mins\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_lat_lon();
pgm_exit(0,"");
########################################
sub give_help {
    prt("$pgmname: version $vers\n");
    prt("Usage: $pgmname [options] [lat,lon]\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
    prt(" --lat <degs>      = Set latitude to convert.\n");
    prt(" --lon <degs>      = Set longitude to convert.\n");

}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg,@arr,$cnt);
    $cnt = 0;
    while (@av) {
        $arg = $av[0];
        $sarg = $arg;
        if (($arg =~ /^-/)&& !($arg =~ /^-\d+/)) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^lat/) {
                need_arg(@av);
                shift @av;
                $usr_lat = $av[0];
            } elsif ($sarg =~ /^lon/) {
                need_arg(@av);
                shift @av;
                $usr_lon = $av[0];
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            # assume a lat.lon pair, sepearated by a comma
            @arr = split(/,/,$sarg);
            if (scalar @arr == 2) {
                $usr_lat = $arr[0];
                $usr_lon = $arr[1];
                $cnt = 2;
            } else {
                if ($cnt == 0) {
                    $usr_lat = $sarg;
                } elsif ($cnt == 1) {
                    $usr_lon = $sarg;
                } else {
                    pgm_exit(1,"ERROR: Invalid argument [$arg]! Got lat=$usr_lat, lon=$usr_lon!! Try -?\n");
                }
            }
            $cnt++;
        }
        shift @av;
    }

    if ((($usr_lat == $bad_latlon)&&($usr_lon == $bad_latlon)) && $debug_on) {
        $usr_lat = -31.69916275;
        $usr_lon = 148.63501248;
    }
    if (($usr_lat == $bad_latlon)&&($usr_lon == $bad_latlon)) {
        pgm_exit(1,"ERROR: No --lat nor --lon <degs> found in command!\n");
    }
}

# eof - template.pl
