# debug.pl
# set debug variables, of the form '$dbg01', 02, 03, ... 
# or if $dbg_base is set to 'dbg_s', then say $dbg_s01, 02, 03 ...
use strict;
use warnings;
package myDebug2;

sub new {
    my $class = shift;
    my $val = shift;
    my $self = {};
    print("Set dbg_base to [$val]\n");
    $self->{dbg_base} = $val;
    bless($self,$class);
    return $self;
}

#sub new {
#    my ($class,$val) = @_;
#    return bless {
#      'dbg_base' => $val
#    }, $class;
#}

#my $dbg_base = 'dbg';
#our $dbg_base;

sub set_dbg_base($) {
    my ($self,$val) = @_;
    print("Set dbg_base to [$val]2\n");
    $self->{dbg_base} = $val;
}

sub get_base {
    my $self = shift;
    my $val = $self->{dbg_base};
    print("Returning [$val]...\n");
    return $val;
}

sub get_dbg_var($) {
    my $self = shift;
    my $val  = shift;
    my $var = $self->get_base();
    #my $var = $self->{dbg_base};
    my $res = -1;
    if ($val < 10) {
        $var .= "0$val";
    } else {
        $var .= "$val";
    }
    # from : http://perldoc.perl.org/functions/eval.html
    print("Getting var '\$$var'...\n");
    if (eval "defined \$$var") {
        $res = eval "\$$var";
    } else {
        print("var [\$$var] NOT defined...\n");
    }
    return $res;
}

sub get_dbg_stg() {
    my $s = '';
    my ($i,$res,$i2);
    for ($i = 1; ;$i++) {
        $res = get_dbg_var($i);
        last if ($res == -1);
        if ($i < 10) {
            $i2 = "0$i";
        } else {
            $i2 = "$i";
        }
        if ($res) {
            $s .= "$i2 ";
        }
    }
    return $s;
}

sub get_dbg_range() {
    my ($i,$res);
    for ($i = 1;$i < 5;$i++) {
        $res = get_dbg_var($i);
        last if ($res == -1);
    }
    return $i - 1;
}

sub set_dbg_var($) {
    my ($self,$val) = @_;
    my $var = get_base();
    if ($val < 10) {
        $var .= "0$val";
    } else {
        $var .= "$val";
    }
    # from : http://perldoc.perl.org/functions/eval.html
    # NOT $$var++; # does not work!
    if (eval "defined \$$var") {
        eval "\$$var++";
    } else {
        #print "ERROR: \$$var does NOT exist\n";
        return 0;
    }
    return 1;
}

sub clear_dbg_var($) {
    my ($self,$val) = @_;
    my $var = $self->{dbg_base};
    if ($val < 10) {
        $var .= "0$val";
    } else {
        $var .= "$val";
    }
    # from : http://perldoc.perl.org/functions/eval.html
    # NOT $$var++; # does not work!
    if (eval "defined \$$var") {
        eval "\$$var = 0";
    } else {
        #print "ERROR: \$$var does NOT exist\n";
        return 0;
    }
    return 1;
}

sub set_all_dbg_on() {
    my ($i,$res);
    for ($i = 1; ;$i++) {
        $res = set_dbg_var($i);
        last if (!$res);
    }
}

sub set_all_dbg_off() {
    my ($i,$res);
    for ($i = 1; ;$i++) {
        $res = clear_dbg_var($i);
        last if (!$res);
    }
}

1;

# eof - debug2.pl
