#!/Perl
###########################################################################
# p2h04.pl - 23 April, 2006 - Geoff McLane - http://geoffmclane.com
#
# A SIMPLE placement of the perl script into a textarea
# minor update: 2006.07.11
###########################################################################
use Time::HiRes qw(usleep ualarm gettimeofday tv_interval nanosleep );
use strict;

# USER VARIABLES
my $vers = '04';
my $out_file = 'tempout'.$vers.'.htm'; # HTML output
my $log_file = 'tempp2h'.$vers.'.txt'; # log file output
my $in_file = "p2h04.pl"; # an INPUT file to convert
###my $in_file = "am2dsp5.pl";
###my $in_file = 'temptest.pl';
if (@ARGV) {
	$in_file = pop @ARGV;
}
# USER variables
my $tab_space = '   '; # note tabs to 3 spaces - change if desired
# some USER OPTIONS
my $row_size = 25;
my $col_size = 100;
# this load the output result into a browser
my $load_html = 1; # load the final HTML

#####################
# PROGRAM VARIABLES #
#####################
my ($LF, $OF);
my @lines = (); # final output line gathered here
my $line = '';
my $doc_total = 0;
my $out_total = 0;
# TIME VARIABLES
my ($t0, $t1, $elapsed);

#####################################################################
# This is the small MAIN part of the script
$t0 = [gettimeofday];
# logging file, if possible
my $out_log = 1;
if (open $LF, ">$log_file") {
   $out_log = 1;
   prt( "Output also being written to LOG file $log_file ... \n" );
} else {
   $out_log = 0;
   prt( "WARNING: Unable to create LOG file $log_file ... \n" );
}
read_in_file( $in_file );
prt( "Got ".scalar @lines." new lines out to $out_file ...\n" );
write_out_file(); # write out results, using HTML format ...
$t1 = [gettimeofday];
$elapsed = tv_interval ( $t0, $t1 );
prt( "$0 processing took $elapsed seconds ...\n" );
if ($load_html) {
	system( $out_file );
}
close($LF) if $out_log;
exit 0;
#####################################################################
#######################
### only subs below ###
#######################
##########################################################################
# The main file OUTPUT - that is the HTML file.
# It establishes the HTML header, which includes the CSS style
# information. then outputs each of the 'converted' lines ...
##########################################################################
sub write_out_file {
   # this is what it is all about - to generate a HTML document
   open $OF, ">$out_file" or die "ERROR: Unable to create $out_file ... aborting ...\n";

   print $OF <<"EOF";
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>Perl Script to TEXTAREA</title>
<meta http-equiv="Content-Language" content="en-gb">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
<style type="text/css">
<!-- /* Style Definitions */
body { background-image:url('cldsp.jpg'); margin: 0cm 1cm 0cm 1cm; }
h1{
 background:#efefef;
 border-style: solid solid solid solid;
 border-color:#d9e2e2;
 border-width:1px;
 padding:2px 2px 2px 2px;
 font-size:200%;
 text-align:center;
}
.ctr { text-align:center; }
-->
</style>
</head>
<body>

<h1>Perl Script to TEXTAREA</h1>

<p class="ctr"><a href="index.htm">index</a>

<p>This HTML script is generated by a Perl script, $in_file, which places all the lines 
of the script into a TEXTAREA box of size (row x col = $row_size x $col_size). A 
quick and easy way to publish Perl scripts ...</p>

EOF

   print $OF "<div align=\"center\">\n";
   print $OF "<table border=\"0\" width=\"95%\" cellpadding=\"3\" cellspacing=\"0\">\n";
   print $OF "<tr>\n";
   print $OF "<td bgcolor=\"yellow\" align=\"center\">\n";
   print $OF "<form name=\"copy\" action=\"\">\n";
   print $OF "<div align=\"center\">\n";
   print $OF "<input type=button value=\"Highlight All\" \n";
   print $OF "onClick=\"javascript:this.form.txt.focus();this.form.txt.select();\">\n";
   print $OF "</div>\n";
   print $OF "</form>\n";
   ###print $OF "<textarea name=\"txt\" rows=\"$row_size\" cols=\"$col_size\" wrap=\"virtual\">\n";
   print $OF "<textarea name=\"txt\" rows=\"$row_size\" cols=\"$col_size\">\n";
   # actual output of generated lines
   foreach $line (@lines) {
      $out_total += length($line);
      print $OF $line;
   }
   print $OF "</textarea>\n";
   print $OF "</td></tr>\n";
   print $OF "</table>\n";
   print $OF "</div>\n";

   print $OF '<p>Generated: ' . localtime(time()) . " from $in_file.</p>\n";

   print $OF <<"EOF";

<p class="ctr"><a href="index.htm">index</a>

<p>
<a href="http://validator.w3.org/check?uri=referer">
<img src="valid-html401.gif" alt="Valid HTML 4.01 Transitional" width="88" height="31">
</a>
</p>
</body>

</html>

EOF

   close($OF);
}

sub html_line2 {
   my $t = shift;
   $t =~ s/&/&amp;/g; # all '&' become '&amp;'
   $t =~ s/</&lt;/g; # make sure all '<' is/are swapped out
   $t =~ s/>/&gt;/g; # make sure all '>' is/are swapped out
   $t =~ s/\"/&quot;/g; # and all quotes become &quot;
   $t =~ s/\t/$tab_space/g; # tabs to spaces
   return $t;
}

sub read_in_file {
   my ($in_file) = shift;
   my ($IF);
   open $IF, "<$in_file" or die "ERROR: Unable to open $in_file ... aborting ...\n";
   my @lns = <$IF>; # slurp into line array
   close($IF);
   prt( "Got ".scalar @lns." to process from $in_file ...\n" );
   foreach my $ln (@lns) {
      $doc_total += length($ln);
      chomp $ln; # remove LF
      $ln =~ s/\r$//; # and remove CR, if present
	  my $nline = html_line2($ln);
	  $nline .= "\n";
      push(@lines, $nline);
   }
}

################################################
# A small 'print' service, that not only
# sends the output to STDOUT, but also
# directs it to a LOG file. I find it
# quite difficult to watch the console
# messages FLASH by ... Of course the
# output can be command line RE-DRIECTED,
# IF you are running it from the command
# line ... most of the time I run it
# from withing the Editor tool, thus this
# provides a convenient look-back at what
# happened ...
################################################
sub prt {
   my ($m) = shift;
   print $m;
   print $LF $m if $out_log;
}

# eof - p2h04.pl
