#!/perl -w
# NAME: readlog.pl
# AIM: VERY SPECIFIC - read a big 'log' file,
# sort, and show the information
# 15/11/2009 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use Bucket2; # see Bucket2.pm
use File::Basename;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $log_option = 5;

my $base_dir = "C:\\FG\\Cullam";
my $in_file = "$base_dir\\temptime1.txt";
my $in_log1 = "$base_dir\\templog1.txt";
my $in_log2 = "$base_dir\\templog2.txt";
#my $in_log4 = "$base_dir\\templog4.txt";
#my $in_log4 = "$base_dir\\logs\\construct-log1.gz";
#my $in_log4 = "$base_dir\\logs\\construct-log1b.gz";
my $in_log4 = "$base_dir\\logs\\construct-log1c.gz";
my $in_log5 = "$base_dir\\Cullam-data\\templog.txt";

my $chunk = "w060n40";
my $airport = "CYYT";
my $airloc = 'w060n40/w059n47';
my $min_clat =  40;
my $max_clat =  50;
my $min_clon = -60;
my $max_clon = -50;

# FLAGS
my $flg_01 = 1;
my $flg_02 = 1 << 1;
my $flg_03 = 1 << 2;
my $flg_04 = 1 << 3;
my $flg_05 = 1 << 4;
my $flg_06 = 1 << 5;
my $flg_07 = 1 << 6;
my $flg_08 = 1 << 7;
my $flg_09 = 1 << 8;
my $flg_10 = 1 << 9;
my $flg_all = ($flg_01|$flg_02|$flg_03|$flg_04|$flg_05|$flg_06|$flg_07|$flg_08|$flg_09|$flg_10);

# DEBUG
my $dbg_01 = 0;
my $dbg_02 = 0;   # prt("[dbg_02] $poly\n") if ($dbg_02);
my $dbg_03 = 0;   # prt("[dbg_03] num polys of type ($ptyp) = $tcnt\n") if ($dbg_03);
my $dbg_04 = 0;   # prt("$line $ptsz,$ptmat\n") if ($dbg_04); AND MORE COUNTS

my ($in_name, $in_dir);

sub in_my_range($$) {
   my ($lat,$lon) = @_;
   if (($lat >= $min_clat) &&
       ($lat  < $max_clat) &&
       ($lon >= $min_clon) &&
       ($lon  < $max_clon)) {
      return 1;
   }
   return 0;
}

sub secs2hms($) {
	my ($s) = shift;
	my $h = int($s / (60 * 60));
	$s -= $h * 60 * 60;
	my $m = int($s / 60);
	$s -= $m * 60;
	my $ret = '';
	if ($h < 10) {
		$ret = "0$h";
	} else {
		$ret = "$h";
	}
	$ret .= ':';
	if ($m < 10) {
		$ret .= "0$m";
	} else {
		$ret .= "$m";
	}
	$ret .= ':';
	$s = int(($s + 0.005) * 100) / 100;
	if ($s < 10) {
		$ret .= "0$s";
	} else {
		$ret .= "$s";
	}
	return $ret;
}

sub process_in_log($) {
   my ($fil) = @_;
   prt( "Reading $fil... moment...\n" );
   ($in_name,$in_dir) = fileparse($fil);
   my %hash = ();
   my %hash2 = ();
   my $rh = \%hash;
   my $rh2 = \%hash2;
   if (open INF, "<$fil") {
      #my @lines = <INF>;
      #close INF;
      #my $lncnt = scalar @lines;
      #prt( "Got $lncnt lines, from $fil...\n" );
      my ($line,$time,$msg,$cnt,$cnt2,$hms,$file,$recs,$fcnt,$rh3,$pcnt,$tpcnt);
      my ($pfiles,$pfil);
      $cnt = 0;
      $file = '';
      $fcnt = 0;
      $pcnt = 0;
      $tpcnt = 0;
      $pfiles = '';
      #foreach $line (@lines) {
      while (<INF>) {
         $line = $_;
         #chomp $line;
         # Opening data\NTDB250k\Lakes\250k_Lakes for reading.
         # shape file records = 35856
         if ($line =~ /^Opening\s+(\S+)\s+for\s+reading/) {
            $file = $1;
            prt("file: [$file]\n");
            $fcnt++;
         } elsif ($line =~ /^shape file records = (\d+)\s*$/) {
            $recs = $1;
            $msg = "$recs";
            $msg = ' '.$msg while (length($msg) < 8);
            prt("recs: [$msg]\n");
         } elsif ($line =~ /Difference\s+([\d\.]+)\s+seconds/) {
            $time = $1;
            $msg = sprintf("%0.2f",$time);
            $msg = ' '.$msg while (length($msg) < 5+1+2);
            prt("time: [$msg]\n");
            ${$rh}{$msg} = [$time, $recs, $file, $pcnt];
            ${$rh2}{$file} = [$time, $recs, $pcnt, $pfiles];
            $cnt++;
            $tpcnt += $pcnt;
            $pcnt = 0;  # restart poly counter
            $file = '';
            $recs = 0;
            $pfiles = '';
         } elsif ($line = /^Writing polyfile (.+)$/) {
            $pfil = $1;
            $pfiles .= '|' if (length($pfiles));
            $pfiles .= $pfil;
            $pcnt++;
         }
      }
      close INF;
      $cnt2 = scalar keys(%{$rh});
      prt( "Got $fcnt files, $cnt times, $cnt2 different...\n" );
      prt( "Short list of $cnt2, per TIME...\n" );
      foreach $line (sort keys %{$rh}) {
         $rh3 = ${$rh}{$line};
         $file = ${$rh3}[2];
         $recs = ${$rh3}[1];
         $pcnt = ${$rh3}[3];
         $msg = trim_all($line);
         $hms = secs2hms($msg);
         prt("$line $hms $recs $pcnt $file\n");
      }
      prt( "Done $fcnt files, $cnt times, $tpcnt polys written...\n" );
   } else {
      prt("Error: Unable to open [$fil]\n");
   }
   return $rh2;
}

sub process_in_log2($) {
   my ($fil) = @_;
   prt( "Reading $fil... moment...\n" );
   ($in_name,$in_dir) = fileparse($fil);
   if (open INF, "<$fil") {
      my ($line,$cnt,$file);
      $cnt = 0;
      while (<INF>) {
         $line = $_;
         if ($line =~ /Working on file '(.+)'\s*$/) {
            $file = $1;
            prt("$file\n");
            $cnt++;
         }
      }
      prt( "Got $cnt file names...\n" );
   } else {
      prt("Error: Unable to open [$fil]\n");
   }
}

sub process_in_file($) {
   my ($fil) = @_;
   ($in_name,$in_dir) = fileparse($fil);
   if (open INF, "<$fil") {
      my @lines = <INF>;
      close INF;
      my $lncnt = scalar @lines;
      prt( "Got $lncnt lines, from $fil...\n" );
      my ($line,$time,$msg,$cnt,$cnt2,$hms);
      my %hash = ();
      my $rh = \%hash;
      $cnt = 0;
      foreach $line (@lines) {
         if ($line =~ /Difference\s+([\d\.]+)\s+seconds/) {
            $time = $1;
            $msg = sprintf("%0.2f",$time);
            $msg = ' '.$msg while (length($msg) < 5+1+2);
            prt("$msg\n");
            ${$rh}{$msg} = $time;
            $cnt++;
         }
      }
      $cnt2 = scalar keys(%{$rh});
      prt( "Got $cnt times, $cnt2 different...\n" );
      foreach $line (sort keys %{$rh}) {
         $msg = trim_all($line);
         $hms = secs2hms($msg);
         prt("$line $hms\n");
      }
   } else {
      prt("Error: Unable to open [$fil]\n");
   }
}

sub fix_length($$$) {
   my ($r,$l,$t) = @_;
   if ($t) {
      ${$r} .= ' ' while (length(${$r}) < $l);
   } else {
      ${$r} = ' '.${$r}  while (length(${$r}) < $l);
   }
}

sub show_ref_hash2($$$$$$) {
   my ($rh,$minf,$mint,$minr,$minp,$type) = @_;
   # {$rh2}{$file} = [$time, $recs, $pcnt, $file];
   my ($file,$time,$recs,$pcnt,@keys,$cnt,$ref);
   my ($key,$pfils);
   @keys = sort keys( %{$rh} );
   $cnt = scalar @keys;
   prt( "Got $cnt file records..." );
   if ($type == 0) {
      prt( "Shown in record count order.\n" );
   } else {
      prt( "Shown in poly count order.\n" );
   }
   foreach $key (@keys) {
      $ref = ${$rh}{$key};
      $time = ${$ref}[0];
      $recs = ${$ref}[1];
      $pcnt = ${$ref}[2];
      $file = ${$ref}[3];
      $pfils = ${$ref}[4];
      fix_length(\$file,$minf,1);
      fix_length(\$time,$mint,0);
      fix_length(\$recs,$minr,0);
      fix_length(\$pcnt,$minp,0);
      if ($type == 0) {
         prt("$recs $time $pcnt $file\n");
      } else {
         prt("$pcnt $time $recs $file\n");
      }
   }
   prt( "Done $cnt file records..." );
   if ($type == 0) {
      prt( "Shown in record count order.\n" );
   } else {
      prt( "Shown in poly count order.\n" );
   }
}

sub show_file_buckets($) {
   my ($rh) = @_;
   # {$rh2}{$file} = [$time, $recs, $pcnt, $pfiles];
   my ($file,$time,$recs,$pcnt,@keys,$cnt,$ref);
   my ($pfil,@arr,$poly);
   my ($nam,$dir,$ext);
   my ($lat,$lon,$maxlat,$maxlon,$minlon,$minlat);
   my ($clon,$clat,$i,$ok,$pcnt2);
   # added pfiles like work/Rivers/w060n40/w055n48/2056842.768382
   @keys = sort keys( %{$rh} );
   $cnt = scalar @keys;
   prt( "Got $cnt file records...\n" );
   my @filesll = ();
   foreach $file (@keys) {
      next if (length($file) == 0);    # skip TOTAL record
      $ref = ${$rh}{$file};
      $time = ${$ref}[0];
      $recs = ${$ref}[1];
      $pcnt = ${$ref}[2];
      $pfil = ${$ref}[3];
      @arr = split(/\|/,$pfil);
      $maxlon = -2000;
      $maxlat = -2000;
      $minlon = 2000;
      $minlat = 2000;
      $pcnt2 = scalar @arr;
      foreach $poly (@arr) {
         ($nam,$dir,$ext) = fileparse($poly, qr/\.[^.]*/ );
         if ($nam =~ /^\d+$/) {
            my $bucket = Bucket2->new;
            $bucket->set_bucket_per_index($nam);
            $lon = $bucket->get_center_lon();
            $lat = $bucket->get_center_lat();
            for ($i = 0; $i < 4; $i++) {
               ($clon,$clat) = $bucket->get_corner($i);
               $minlon = $clon if ($clon < $minlon);
               $minlat = $clat if ($clat < $minlat);
               $maxlon = $clon if ($clon > $maxlon);
               $maxlat = $clat if ($clat > $maxlat);
            }
         } else {
            prt( "\nWHAT IS THIS poly [$poly]!\n CHECK ME! [$dir] [$nam] [$ext]\n" );
         }
      }
      if ( in_my_range($minlat,$minlon) || in_my_range($maxlat,$maxlon) ) {
         $ok = 'ok'
      } else {
         $ok = 'OOR';
      }
      prt("$file - min,max $minlat,$minlon - $maxlat,$maxlon $ok $pcnt ($pcnt2)\n" );
      push(@filesll, [$file, $minlat, $minlon, $maxlat, $maxlon, $ok, $pcnt]);
   }
   prt( "Done $cnt file records...\n" );
   return \@filesll;
}

sub show_ref_hash($) {
   my ($rh) = @_;
   # {$rh2}{$file} = [$time, $recs, $pcnt, $pfiles];
   my ($file,$time,$recs,$pcnt,@keys,$cnt,$ref);
   my ($key1,$key2,$minf,$mint,$minr,$minp,$len,$pfil);
   # added pfiles like work/Rivers/w060n40/w055n48/2056842.768382
   @keys = sort keys( %{$rh} );
   $cnt = scalar @keys;
   prt( "Got $cnt file records...\n" );
   my %h1 = ();
   my %h2 = ();
   $minf = 0;
   $mint = 0;
   $minr = 0;
   $minp = 0;
   foreach $file (@keys) {
      $ref = ${$rh}{$file};
      $time = ${$ref}[0];
      $recs = ${$ref}[1];
      $pcnt = ${$ref}[2];
      $pfil = ${$ref}[3];
      $key1 = sprintf("%09u",$recs)."_$file";
      $key2 = sprintf("%09u",$pcnt)."_$file";
      $h1{$key1} = [$time, $recs, $pcnt, $file, $pfil];
      $h2{$key2} = [$time, $recs, $pcnt, $file, $pfil];
      $len = length($file);
      $minf = $len if ($len > $minf);
      $len = length($time);
      $mint = $len if ($len > $mint);
      $len = length($recs);
      $minr = $len if ($len > $minr);
      $len = length($pcnt);
      $minp = $len if ($len > $minp);
   }
   show_ref_hash2(\%h1,$minf,$mint,$minr,$minp,0);
   show_ref_hash2(\%h2,$minf,$mint,$minr,$minp,1);
}

sub process_in_log4($) {
   my ($fil) = @_;
   my %hash = ();
   ($in_name,$in_dir) = fileparse($fil);
   if (! -f $fil) {
      prt("ERROR: $fil does NOT exist!\n");
      return \%hash;
   }
   if ($fil =~ /\.gz$/) {
      if (! open INF, "gzip -d -c $fil|") {
         prt("ERROR: Can NOT open file $fil!\n");
         return \%hash;
      }
   } else {
      if (!open INF, "<$fil") {
         prt("ERROR: Can NOT open file $fil!\n");
         return \%hash;
      }
   }
   my ($line,$cnt,$file);
   my ($nam,$dir,$ext);
   my ($nam2,$dir2,$ext2);
   $cnt = 0;
   $file = '';
   my $pscnt = 0;
   my $pmcnt = 0;
   my $tscnt = 0;
   my $tmcnt = 0;
   my $sscnt = 0;
   my $smcnt = 0;
   my $fscnt = 0;
   my $fmcnt = 0;
   my $ndcnt = 0;
   my $clcnt = 0;
   my $nmcnt = 0;
   my $tccnt = 0;
   my $tlcnt = 0;
   my $flag = 0;
   while (<INF>) {
      $line = $_;
      if ($line =~ /^Output file = (.+)\s*$/) {
         $file = $1;
         $cnt++;
         ($nam,$dir,$ext) = fileparse($file, qr/\.[^.]*/ );
         ($nam2,$dir2,$ext2) = fileparse($nam, qr/\.[^.]*/ );
         prt("Output: $file ($nam2)\n");
         $flag |= $flg_01;
      } elsif ($line =~ /^points size = (\d+)\s+pt_materials = (\d+)\s*$/) {
         $pscnt = $1;
         $pmcnt = $2;
         prt("points size = $pscnt  pt_materials = $pmcnt\n");
         $flag |= $flg_02;
      } elsif ($line =~ /^triangles size = (\d+)\s+tri_materials = (\d+)\s*$/) {
         $tscnt = $1;
         $tmcnt = $2;
         prt("triangles size = $tscnt  tri_materials = $tmcnt\n");
         $flag |= $flg_03;
      } elsif ($line =~ /^strips size = (\d+)\s+strip_materials = (\d+)\s*$/) {
         $sscnt = $1;
         $smcnt = $2;
         prt("strips size = $sscnt  strip_materials = $smcnt\n");
         $flag |= $flg_04;
      } elsif ($line =~ /^fans size = (\d+)\s+fan_materials = (\d+)\s*$/) {
         $fscnt = $1;
         $fmcnt = $2;
         prt("fans size = $fscnt  fan_materials = $fmcnt\n");
         $flag |= $flg_05;
      } elsif ($line =~ /^nodes = (\d+)\s*$/) {
         $ndcnt = $1;
         prt("nodes = $ndcnt\n");
         $flag |= $flg_06;
      } elsif ($line =~ /^colors = (\d+)\s*$/) {
         $clcnt = $1;
         prt("colors = $clcnt\n");
         $flag |= $flg_07;
      } elsif ($line =~ /^normals = (\d+)\s*/) {
         $nmcnt = $1;
         prt("normals = $nmcnt\n");
         $flag |= $flg_08;
      } elsif ($line =~ /^tex coords = (\d+)\s*$/) {
         $tccnt = $1;
         prt("tex coords = $tccnt\n");
         $flag |= $flg_09;
      } elsif ($line =~ /^total top level objects = (\d+)\s*$/) {
         $tlcnt = $1;
         prt("total top level objects = $tlcnt\n");
         $flag |= $flg_10;
         if (length($file)) {
            $hash{$file} = [ $pscnt, $pmcnt, $tscnt, $tmcnt, $sscnt, $smcnt, $fscnt, $fmcnt,
               $ndcnt, $clcnt, $nmcnt, $tccnt, $tlcnt, $flag, $nam2 ];
            if ($flag != $flg_all) {
               prt("\nFlag is NOT FULL!\n" );
            }
         }
         $pscnt = 0;
         $pmcnt = 0;
         $tscnt = 0;
         $tmcnt = 0;
         $sscnt = 0;
         $smcnt = 0;
         $fscnt = 0;
         $fmcnt = 0;
         $ndcnt = 0;
         $clcnt = 0;
         $nmcnt = 0;
         $tccnt = 0;
         $tlcnt = 0;
         $file = '';
         $flag = 0;
      }
   }
   prt( "Got $cnt file names...\n" );
   return \%hash;
}

sub show_hash4($$$) {
   my ($rh,$lev,$nam) = @_;
   #                  0   &   1       2   &   3       4   &   5       6   &   7
   # $hash{$file} = [ $pscnt, $pmcnt, $tscnt, $tmcnt, $sscnt, $smcnt, $fscnt, $fmcnt,
   #            8       9       10      11      12      13     14
   #            $ndcnt, $clcnt, $nmcnt, $tccnt, $tlcnt, $flag, $index ];
   if ($lev > 13) {
      prt( "ERROR: level GT 13 = $lev ($nam)\n" );
      return 1;
   }
   my $cnt = keys( %{$rh} );
   return 1 if ($cnt == 0);
   prt( "[dbg_01] Process $cnt keys/files, for [$nam]\n" ) if ($dbg_01);
   my ($key,$rarr,$val,$min,$max,$msg,$ind);
   $min = 0xffffffff;
   $max = -1;
   foreach $key (keys %{$rh}) {
      $rarr = ${$rh}{$key};
      $val = ${$rarr}[$lev];
      #prt( "$val " );
      $min = $val if ($val < $min);
      if ($val > $max) {
         $max = $val;
         $ind = ${$rarr}[14];
      }
   }
   #prt("\n");
   $msg = ($max > 0xFFFF) ? "GT 65K" : "";
   prt("$in_name: $cnt tiles, for $nam ($lev) - min = $min, max = $max ($ind) $msg\n");
   return 0;
}

# transitions
# 
#

# done building node list and polygons
# ready to do triangulation
# ...
# Region point = -52.6429, 47.5102, -9999
# Triangulation with options = pczAen
# ...
# finished triangulation
# number of fitted nodes = 48360
# fixing node heights
# flattening lake connected nodes (and smoothing streams)
# flattening ocean connected nodes
# ...
#     -52.635, 47.5, 64
# Spliting tile
#  extracting (shared) edge nodes and normals
# ...
# after adding all segments (should be the same):
#  new_nodes = 48297
#  new normals = 48297
#done re building node list and polygons
#ready to do second triangulation
# ...
# finished second triangulation
# generating wgs84 list
# ...
#creating 4942 fans of type 59
#Output file = Scenery/Terrain/w060n40/w053n47/2089569.btg.gz
#points size = 0  pt_materials = 0
#triangles size = 0  tri_materials = 0
#strips size = 0  strip_materials = 0
#fans size = 24295  fan_materials = 24295
#nodes = 48296
#colors = 0
#normals = 48297
#tex coords = 144625
#total top level objects = 19
# ...
# No custom objects
#Construct tile, bucket = -53:2, 47:4
# ...
#    File not open, so using zero'd data
#  master clipper finished.
#Construct tile, bucket = -53:1, 47:5


sub process_in_log5($) {
   my ($fil) = @_;
   prt( "5: Reading $fil... moment...\n" );
   ($in_name,$in_dir) = fileparse($fil);
   my %hash = ();
   if (open INF, "<$fil") {
      my ($line,$cnt,$file);
      my ($lon,$lat,$xd,$yd,$set4,$inrun,$poly,@polys);
      my ($key,$pcnt,$ptyp,$tcnt,$len,$buck,$nbuck,$ofile,@outfiles);
      my ($ffile,$odir,$nkey);
      my ($ptsz,$ptmat,$trisz,$trimat,$stsz,$stmat);
      my ($fansz,$fanmat,$nodes,$colors,$norms,$texcoord,$tlobjs);
      my ($reset);
      $cnt = 0;
      $set4 = 0;
      $inrun = 0;
      @polys = ();
      $buck = "NONE YET";
      $ofile = '';
      $ffile = '';
      @outfiles = ();
      my %hptypes = ();
      $ptsz = 0;
      $ptmat = 0;
      $trisz = 0;
      $trimat = 0;
      $stsz = 0;
      $stmat = 0;
      $fansz = 0;
      $fanmat = 0;
      $nodes = 0;
      $colors = 0;
      $norms = 0;
      $texcoord = 0;
      $tlobjs = 0;
      $reset = 0;
      while (<INF>) {
         $line = $_;
         chomp $line;
         $len = length($line);
         next if ($len == 0);
         next if ($line =~ /^\s+$/);
         if ($line =~ /^Center longitude is (.+)$/) {
            $lon = $1;
            $set4 |= 1;
         } elsif ($line =~ /^Center latitude is (.+)$/) {
            $lat = $1;
            $set4 |= 2;
         } elsif ($line =~ /^X distance is (.+)$/) {
            $xd = $1;
            $set4 |= 4;
         } elsif ($line =~ /^Y distance is (.+)$/) {
            $yd = $1;
            $set4 |= 8;
            if ($set4 == 15) {
               prt("Lon $lon, Lat $lat, X = $xd, Y = $yd\n");
            }
            $set4 = 0;
         } elsif ($line =~ /^Loading (.+) \.\.\.$/) {
            $poly = $1;
            push(@polys,$poly);
            prt("[dbg_02] $poly\n") if ($dbg_02);

         } elsif ($line =~ /^num polys of type \((\d+)\) = (\d+)$/) {
            $ptyp = $1;
            $tcnt = $2;
            if ($tcnt) {
               prt("[dbg_03] num polys of type ($ptyp) = $tcnt\n") if ($dbg_03);
               $hptypes{$ptyp} = $tcnt;
            }
         } elsif ($line =~ /^Construct tile, bucket = (.+)$/) {
            $nbuck = $1;
            $pcnt = scalar @polys;
            if ($pcnt) {
               $key = "$lon,$lat,$xd,$yd,$buck";
               $nkey = "POLYS $key";
               $hash{$nkey} = [ @polys ];
               prt("Key $key has $pcnt polys...[$ofile]\n");
               @polys = ();
               $nkey = "POLYCOUNTS $key";
               $hash{$nkey} = { %hptypes };
               $nkey = "FILES $key";
               $hash{$nkey} = [ @outfiles ];
               $nkey = "COUNTS $key";
               $hash{$nkey} = [$ptsz,$ptmat,$trisz,$trimat,$stsz,$stmat,$fansz,$fanmat,$nodes,$colors,$norms,$texcoord,$tlobjs];
               prt("COUNTS: texc=$texcoord pts=$ptsz,$ptmat tris=$trisz,$trimat strips=$stsz,$stmat fans=$fansz,$fanmat n=$nodes c=$colors norms=$norms tlo=$tlobjs\n");
            } else {
               prt("No polys for bucket $buck [$ofile]\n");
            }
            $ofile = '';
            %hptypes = ();
            @outfiles = ();
            $ptsz = 0;
            $ptmat = 0;
            $trisz = 0;
            $trimat = 0;
            $stsz = 0;
            $stmat = 0;
            $fansz = 0;
            $fanmat = 0;
            $nodes = 0;
            $colors = 0;
            $norms = 0;
            $texcoord = 0;
            $tlobjs = 0;
            prt("\nBUCKET: $nbuck\n");
            $buck = $nbuck;
         } elsif ($line =~ /^Output file = (.+)$/) { # Scenery/Terrain/w060n40/w053n47/2089577.btg.gz
            $ffile = $1;
            ($ofile,$odir) = fileparse($ffile);
            #prt("$line\n");
            prt("OUT: $ofile\n");
            push(@outfiles,$ofile);
         } elsif ($line =~ /^\[Finished successfully\]/) {
            #prt("$line\n\n");
            $reset = 1;
         } elsif ($line =~ /^Killed/) {
            #prt("$line ABORTED CONSTRUCTION\n\n");
            $reset = 1;
         } elsif ($line =~ /^points size = (\d+)  pt_materials = (\d+)\s*$/) {
            $ptsz = $1;
            $ptmat = $2;
            prt("$line $ptsz,$ptmat\n") if ($dbg_04);
         } elsif ($line =~ /^triangles size = (\d+)  tri_materials = (\d+)\s*$/) {
            $trisz = $1;
            $trimat = $2;
            prt("$line $trisz,$trimat\n") if ($dbg_04);
         } elsif ($line =~ /^strips size = (\d+)  strip_materials = (\d+)\s*$/) {
            $stsz = $1;
            $stmat = $2;
            prt("$line $stsz,$stmat\n") if ($dbg_04);
         } elsif ($line =~ /^fans size = (\d+)  fan_materials = (\d+)\s*$/) {
            $fansz = $1;
            $fanmat = $2;
            prt("$line $fansz,$fanmat\n") if ($dbg_04);
         } elsif ($line =~ /^nodes = (\d+)\s*$/) {
            $nodes = $1;
            prt("$line $nodes\n") if ($dbg_04);
         } elsif ($line =~ /^colors = (\d+)\s*$/) {
            $colors = $1;
            prt("$line $colors\n") if ($dbg_04);
         } elsif ($line =~ /^normals = (\d+)\s*$/) {
            $norms = $1;
            prt("$line $norms\n") if ($dbg_04);
         } elsif ($line =~ /^tex coords = (\d+)\s*$/) {
            $texcoord = $1;
            prt("$line $texcoord\n") if ($dbg_04);
         } elsif ($line =~ /^total top level objects = (\d+)\s*$/) {
            $tlobjs = $1;
            prt("$line $tlobjs\n") if ($dbg_04);
         }
         if ($reset) {
            $pcnt = scalar @polys;
            if ($pcnt) {
               $key = "$lon,$lat,$xd,$yd,$buck";
               $nkey = "POLYS $key";
               $hash{$nkey} = [ @polys ];
               prt("Key $key has $pcnt polys...[$ofile]\n");
               @polys = ();
               $nkey = "POLYCOUNTS $key";
               $hash{$nkey} = { %hptypes };
               $nkey = "FILES $key";
               $hash{$nkey} = [ @outfiles ];
               $nkey = "COUNTS $key";
               $hash{$nkey} = [$ptsz,$ptmat,$trisz,$trimat,$stsz,$stmat,$fansz,$fanmat,$nodes,$colors,$norms,$texcoord,$tlobjs];
               prt("COUNTS: texc=$texcoord pts=$ptsz,$ptmat tris=$trisz,$trimat strips=$stsz,$stmat fans=$fansz,$fanmat n=$nodes c=$colors norms=$norms tlo=$tlobjs\n");
            } else {
               prt("No polys for bucket $buck [$ofile]\n");
            }
            $ofile = '';
            %hptypes = ();
            @outfiles = ();
            $ptsz = 0;
            $ptmat = 0;
            $trisz = 0;
            $trimat = 0;
            $stsz = 0;
            $stmat = 0;
            $fansz = 0;
            $fanmat = 0;
            $nodes = 0;
            $colors = 0;
            $norms = 0;
            $texcoord = 0;
            $tlobjs = 0;

            prt("$line\n\n");
            $reset = 0;
         }
      }
      # done all lines - any remainers
      $pcnt = scalar @polys;
      if ($pcnt) {
         $key = "$lon,$lat,$xd,$yd,$buck";
         $nkey = "POLYS $key";
         $hash{$nkey} = [ @polys ];
         prt("Key $key has $pcnt polys...[$ofile]\n");
         @polys = ();
         $nkey = "POLYCOUNTS $key";
         $hash{$nkey} = { %hptypes };
         $nkey = "FILES $key";
         $hash{$nkey} = [ @outfiles ];
         $nkey = "COUNTS $key";
         $hash{$nkey} = [$ptsz,$ptmat,$trisz,$trimat,$stsz,$stmat,$fansz,$fanmat,$nodes,$colors,$norms,$texcoord,$tlobjs];
         prt("COUNTS: texc=$texcoord pts=$ptsz,$ptmat tris=$trisz,$trimat strips=$stsz,$stmat fans=$fansz,$fanmat n=$nodes c=$colors norms=$norms tlo=$tlobjs\n");
      }
   } else {
      prt("Error: Unable to open [$fil]\n");
   }
}

# process_in_file($in_file);
my ($ref_hash);

if ($log_option == 1) {
   $ref_hash = process_in_log($in_log1);
   show_ref_hash($ref_hash);
   show_file_buckets($ref_hash);
} elsif ($log_option == 2) {
   process_in_log2($in_log2);
} elsif ($log_option == 3) {
   prt("To be done...\n");
   exit(1);
} elsif ($log_option == 4) {
   $ref_hash = process_in_log4($in_log4);
   #                  0   &   1       2   &   3       4   &   5       6   &   7
   # $hash{$file} = [ $pscnt, $pmcnt, $tscnt, $tmcnt, $sscnt, $smcnt, $fscnt, $fmcnt,
   #            8       9       10      11      12      13
   #            $ndcnt, $clcnt, $nmcnt, $tccnt, $tlcnt, $flag ];
   show_hash4($ref_hash,0,"points");
   show_hash4($ref_hash,1,"points mat");
   show_hash4($ref_hash,2,"tris");
   show_hash4($ref_hash,3,"tris mat");
   show_hash4($ref_hash,4,"strips");
   show_hash4($ref_hash,5,"strips mat");
   show_hash4($ref_hash,6,"fans");
   show_hash4($ref_hash,7,"fans mat");
   show_hash4($ref_hash,8,"nodes");
   show_hash4($ref_hash,8,"colors");
   show_hash4($ref_hash,10,"normals");  # show normals
   show_hash4($ref_hash,11,"tex coords");
   show_hash4($ref_hash,12,"top level");

} elsif ($log_option == 5) {
   process_in_log5($in_log5);
}

close_log($outfile,1);
exit(0);

# eof
