#!/perl -w
# NAME: relinetxt.pl
# AIM: SPECIAL: Reline a text file
# 03/08/2008 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $max_len = 76;
my $in_file = 'C:\Projects\tidy\twperl\build\temp1.txt';

process_file($in_file);

close_log($outfile,0);
exit(0);

sub process_file {
    my ($inf) = shift;
    my (@lines, $line, $lncnt, $len, $ch, $nline, $tag, $nfil, $i, $i2);
    my @nlines = ();
    my $inquote = 0;
    if (open INF, "<$inf") {
        @lines = <INF>;
        close INF;
        $lncnt = scalar @lines;
        prt( "Processing $lncnt lines from $inf ...\n" );
        $tag = '';
        $nline = '';
        foreach $line (@lines) {
            chomp $line;
            $len = length($line);
            for ($i = 0; $i < $len; $i++) {
                $ch = substr($line,$i,1);
                $i2 = $i + 1;
                $tag .= $ch;    # add to tag
                if ($inquote) {
                    if ($ch eq '"') {
                        $inquote = 0;
                    }
                } else {
                    # not in a QUOTE
                    if (($ch =~ /\s/)||($i2 >= $len)) {
                        # is length too much?
                        if ((length($nline) + length($tag)) > $max_len) {
                            push(@nlines,$nline) if length($nline);
                            $nline = $tag;  # start new line with tag
                        } else {
                            $nline .= $tag; # else add tag to new line
                        }
                        $tag = '';  # and kill the tag
                    } elsif ($ch eq '"') {
                        $inquote = 1;
                    }
                }
            }
        }
        push(@nlines, $nline) if length($nline);
        push(@nlines, $tag) if length($tag);
        $lncnt = scalar @nlines;
        prt( "Got $lncnt lines ...\n" );
        $nfil = $inf.'.txt';
        write2file(join("\n",@nlines),$nfil);
        prt( "Written $lncnt lines to $nfil ...\n" );
    } else {
        prt( "ERROR: Failed to open $inf ... $! ...\n" );
    }
}
# eof
