#!/perl
#print "Content-type: text/HTML\n\n";
#print << EOF;
#< html>
#< head>< /head>
#< body>
#EOF


use strict;
### BEGIN { $ENV{PATH} = '/usr/ucb:/bin' }
use Socket;
use Carp;
my $EOL = "\n"; ### "\015\012";
sub logmsg {
	print "$0 $$: @_ at ", scalar localtime, "\n";
}
print "start!\n\n";
my $port = shift || 2345;
my $proto = getprotobyname('tcp');
($port) = $port =~ /^(\d+)$/                        or die "invalid port";
socket(Server, PF_INET, SOCK_STREAM, $proto)        || die "socket: $!";
setsockopt(Server, SOL_SOCKET, SO_REUSEADDR,
									pack("l", 1))   || die "setsockopt: $!";
bind(Server, sockaddr_in($port, INADDR_ANY))        || die "bind: $!";
listen(Server,SOMAXCONN)                            || die "listen: $!";
logmsg "server started on port $port";
my $paddr;
##### $SIG{CHLD} = \&REAPER;
for ( ; $paddr = accept(Client,Server); close Client) {
	logmsg "waiting for connection, using port=$port ...";
	my($port,$iaddr) = sockaddr_in($paddr);
	my $name = gethostbyaddr($iaddr,AF_INET);
	logmsg "connection from $name [",
			inet_ntoa($iaddr), "]
			at port $port";
	print Client "Hello there, $name, it's now ",
					scalar localtime, $EOL;
}


### print "< /body>< /html>";

# EOF


