#!/Perl
# AIM: Strip <span ...>something </span> from HTML
require "logfile.pl" or die "Missing logfile.pl ...\n"; # my simple log file and some other utility subs
# log file stuff
my ($LF);
my $outfile = 'temp'.$0.'.txt';
open_log($outfile);
prt( "$0 ... Hello, World...\n" );
my $dbg_on1 = 0;

my $in_file = '..\javascript\fg\fgfs-030.htm';
my $out_file = '..\javascript\fg\temp1.htm';
$in_file = shift @ARGV if (@ARGV);
if (! -f $in_file) {
	mydie( "ERROR: Can NOT locate [$in_file] ... check location and name ...\n" );
}
open FH, "<$in_file" or mydie("ERROR: Failed to open [$in_file] ... aborting ...\n");
my @lines = <FH>; # slurp in whole file
close(FH);
my $line = '';
my $ch = '';
my $llen = 0;
my $gotbgn = 0;
my $i = 0;
my $tag = '';
my $nline = '';
my $tmline = '';
my @nlines = ();
my $inspan = 0;
my $cnt = 0;
my @dlines = ();
prt("Processing ".scalar @lines." from $in_file ...\n");
foreach $line (@lines) {
	chomp $line;
	$llen = length($line);
	for ($i = 0; $i < $llen; $i++) {
		$ch = substr($line,$i,1);
		if ($gotbgn) {
			if ($ch eq '>') {
				$gotbgn = 0;
				prt("Got tag [$tag]\n") if ($dbg_on1);
				if ($tag =~ /^span\s+/) {
					prt("Got SPAN tag [$tag] ...\n");
					$inspan = 1;
					$tmline .= $ch;
					push(@dlines, $tmline);
					$tmline = ''; # kill the temporary accumulation
					next;
				} elsif ($tag =~ /^\/span/) {
					prt("Got end SPAN tag [$tag] ...\n");
					# we want to discard from the begin of <span ...> to </span>
					# but keep what is indetween ...
					$inspan = 0;
					$tmline .= $ch;
					push(@dlines, $tmline);
					$tmline = ''; # kill the temporary accumulation
					next;
				} else {
					$nline .= $tmline;
					$tmline = '';
				}
			} else {
				$tag .= $ch;
			}
		} else { # not started a tag yet
			if ($ch eq '<') {
				$gotbgn = 1;
				$tag = '';
			}
		}
		if ($gotbgn) {
			# can only store it in temp, until we know the tag
			$tmline .= $ch;
		} else {
			$nline .= $ch; # accumulate new line
		}
	} # done the whole line
	if (length($nline)) {
		prt("Add line [$nline]\n");
		push(@nlines, $nline);
	}
	$nline = '';
	$cnt++; # bump line counter
}

prt("Doing output of ".scalar @nlines." to $out_file ...\n");
open NFH, ">$out_file" or mydie("ERROR: Unable to open output file $out_file ...\n");
foreach $line (@nlines) {
	prt( "$line\n" );
	print NFH "$line\n";
}
close(NFH);

prt("Discarded spans ...\n");
foreach $line (@dlines) {
	prt("$line\n");
}

close_log($outfile,1);
exit(0);

