#!/Perl
# test.pl
# AIM: Test read a config file
use strict;
use warnings;

my %ACCESS = ();

###my $file = 'C:\FG\16\build-fgcom\auth.conf';
my $file = 'C:\FG\16\fgcom\server\auth.conf';

sub prt($) { print shift }

sub read_auth_file($) {
    my $fil = shift;
    if (open INF, "<$fil") {
        my @arr = <INF>;
        close INF;
        my ($line,$name,$val);
        foreach $line (@arr) {
            chomp $line;
            next if ($line =~ /^\s*$/);
            next if ($line =~ /\s*\#/);
            if ($line =~ /^\$ACCESS\{['"]{1}(.+)["']{1}\}\s*=\s*['"]{1}(.+)["']{1}/) {
                $name = $1;
                $val  = $2;
                prt("$name $val\n");
                $ACCESS{$name} = $val;
            } else {
                prt("WARNING: Unknown line in 'auth' file [$line]!\n");
            }
        }
    }
}

sub show_access() {
    my ($key,$val);
    foreach $key (keys %ACCESS) {
        $val = $ACCESS{$key};
        prt("$key = $val\n");
    }

}

read_auth_file($file);
show_access();

# eof
