#!/usr/bin/perl -w
# NAME: typefile.pl
# AIM: Given an input file, output without comments /* .... */ or 
# lines beginning /\s*\/\/
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $in_file = '';

my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        ###prt( "\nNo warnings issued.\n\n" );
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$i,$tag,$len,$ch,$nc,$j,$j2);
    my $in_comm = 0;
    $lnn = 0;
    for ($i = 0; $i < $lncnt; $i++) {
        $line = $lines[$i];
        chomp $line;
        $lnn++;
        $len = length($line);
        next if ($len == 0);
        next if ($line =~ /^\s+$/);
        next if ($line =~ /^\s*\/\//);
        if ($in_comm) {
            for ($j = 0; $j < $len; $j++) {
                $j2 = $j+1;
                $ch = substr($line,$j,1);
                $nc = (($j2 < $len) ? substr($line,$j2,1) : '');
                if (($ch eq '*')&&($nc eq '/')) {
                    $j += 2;
                    $in_comm = 0;
                    last;
                }
            }
            $tag = '';
            for (; $j < $len; $j++) {
                $ch = substr($line,$j,1);
                $tag .= $ch;
            }
            if (length($tag) && !($tag =~ /^\s+$/)) {
                prt("$tag\n");
            }
            next;
        } elsif ($line =~ /\/\*/) {
            # potential comment beginning
            $tag = '';
            for ($j = 0; $j < $len; $j++) {
                $j2 = $j+1;
                $ch = substr($line,$j,1);
                $nc = (($j2 < $len) ? substr($line,$j2,1) : '');
                if (($ch eq '/')&&($nc eq '*')) {
                    $in_comm = 1;
                    last;
                }
                $tag .= $ch;
            }
            if (length($tag) && !($tag =~ /^\s+$/)) {
                prt("$tag\n");
            }
            $j++;
            for (; $j < $len; $j++) {
                $j2 = $j+1;
                $ch = substr($line,$j,1);
                $nc = (($j2 < $len) ? substr($line,$j2,1) : '');
                if (($ch eq '*')&&($nc eq '/')) {
                    $j += 2;
                    $in_comm = 0;
                    last;
                }
            }
            $tag = '';
            for (; $j < $len; $j++) {
                $ch = substr($line,$j,1);
                $tag .= $ch;
            }
            if (length($tag) && !($tag =~ /^\s+$/)) {
                prt("$tag\n");
            }
            next;
        }
        prt("$line\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
prt( "$pgmname: in [$cwd]: Hello, World...\n" );
process_in_file($in_file);
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help {
    prt("$pgmname: version 0.0.1 2010-09-11\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help (-h or -?) = This help, and exit 0.\n");
}
sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n");
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

# eof - typefile.pl
