#!/perl -w
# NAME: unixit.pl
# AIM: Given an input file, convert to unix/linux form ...
use strict;
use warnings;
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}

my $in_file = "C:\\FG\\FGCOMXML\\xmlrpc.diff17.txt";
my $out_file = "tempu.txt";
my @newlines = ();
my $removedrive = 0;	# also remove the DRIVE

parse_args(@ARGV);

if (open INF, "<$in_file") {
	my @lines = <INF>;
	close INF;
	prt( "Processing ".scalar @lines." from $in_file ...\n" );
	my $file = '';
	foreach my $line (@lines) {
		chomp $line;
		if ($line =~ /^diff\s+-\w+\s+(.+)$/) {
			$file = $1;
		} elsif ($line =~ /^---\s+(.+)$/) {
			$file = $1;
		} elsif ($line =~ /^\+\+\+\s+(.+)$/) {
			$file = $1;
		}
		if ($file =~ /\\/) {
			$line =~ s/\\/\//g;
			if ($removedrive) {
				if ($line =~ /\s+C:\//) {
					$line =~ s/(\s+)C:\//$1\//g;
				}
			}
		}
		push(@newlines,$line);
		$file = '';
	}
	if (open OUT, ">$out_file") {
		binmode( OUT );
		print OUT join("\n",@newlines)."\n";
		close OUT;
		prt( "Ouput written to $out_file ...\n" );
	} else {
		prt( "ERROR: Can NOT create $out_file ... $! ...\n" );
	}
} else {
	prt( "ERROR: Can not open [$in_file] ... $! ...\n" );
}

exit(0);

sub prt {
	my ($txt) = shift;
	print $txt;
}

sub give_help {
	prt( "Usage: $pgmname [options] in_file\n" );
	prt( "Options:\n" );
	prt( " -? or -h  - This help\n" );
	prt( " -out out_file - Output file (def=$out_file)\n" );
	die( "Aborting ...\n" );
}

sub need_arg {
	my ($a, @b) = @_;
	if (@b) {
		# ok
	} else {
		prt( "Error: $a argument requires additional item!\n" );
		give_help();
	}
}

sub parse_args {
	my (@av) = @_;
	my $had_in = 0;
	while (@av) {
		my $arg = $av[0];
		if (substr($arg,0,1) eq '-') {
			$arg = substr($arg,1);
			if (($arg eq '?')||(lc($arg) eq 'h')) {
				give_help();
			} elsif ($arg eq 'out') {
				need_arg(@av);
				shift @av;
				$out_file = $av[0];
				prt( "Set output to [$out_file] ...\n" );
			} else {
				prt( "Error: Unknown argument [$arg] ...\n" );
				give_help();
			}
		} else {
			$in_file = $arg;
			prt( "Set input file to [$in_file] ...\n" );
			$had_in = 1;
		}
		shift @av;
	}
	if ( !$had_in ) {
		prt( "ERROR: No input file found!\n" );
		give_help();
	}
}

# eof - unixit.pl

