#!/perl
# NAME: unlink.pl
# AIM: To do a simple test on built in function, unlink ... 
# Note no -w above, else get additional warnings ...
use strict;
use warnings;
use File::stat;
my $file = 'tempunlink1.txt';
my $cnt = 0;
print "$0 ... Hello, World ...\n";
sub check_file($) {
	my ($fil) = shift;
	my $sb = stat($file);
	# if ( -f $fil) {
	if ( defined $sb) {
		print "File $fil exists ... \n";
		print " Size = ". $sb->size . " bytes, dated " . scalar localtime $sb->mtime;
		print "\n";
		return 1;
	}
	print "File $fil DOES NOT EXIST!\n";
	return 0;
}
# main program
if ( ! check_file($file) ) {
	open OF, ">$file" or die "Unable to create file [$file] ...\n";
	print OF "Message to file ...\n";
	print OF "Another message to file ...\n";
	close OF
}
if ( check_file( $file ) ) {
	print "Testing unlink built in function ...\n";
	$cnt = unlink $file;
	if ($cnt) {
		print "File apppears successfully deleted ...\n";
	} else {
		print "Failed unlinked ... $! ...\n";
	}
	check_file( $file );
} else {
	print "File does NOT appear to EXIST! ...\n";
}
exit(0); # end program
# eof - unlink.pl
