#!/Perl
# AIM: To load FG vcproj files, and extract the SOURCE files in there ...
# =======================================================================
print "$0 ...Hello, World...\n";

my $root_dir = 'C:\\FG0910-1\\source\\';
my $write_log = 1;

# msvc8 stuff
my $mod_vcproj = 0;
my $dbg_on = 1;
my $dbg_on2 = 1;
my $dbg_on3 = 1;
my $vc8_root = 'projects\\VC8\\';
my $vc8_def_lib = $vc8_root.'FlightGearLib.vcproj';
my $vc8_def_main = $vc8_root.'FlightGear.vcproj';
# VC8 project files and lines
my $vc8_src_lib = $root_dir . $vc8_def_lib;
my $vc8_src_main = $root_dir . $vc8_def_main;
my @vc8_lib_lines = (); # storage of RAW lines
my @vc8_main_lines = ();
# VC8 information extracted from lines ...
# VC8 headers and sources
##############################################
my @vc8_main_hdrs = ();
my @vc8_main_srcs = ();
my @vc8_lib_hdrs = ();
my @vc8_lib_srcs = ();
# VC8 include path, libraries and library paths
###############################################
# MAIN storeage
# configuration stuff
my $main_msvc8_dintd = '';
my $main_msvc8_rintd = '';
# compiler stuff
my @main_msvc8_dincs = ();
my @main_msvc8_ddefs = ();
my @main_msvc8_rincs = ();
my @main_msvc8_rdefs = ();
# linker stuff
my @main_msvc8_dlibs = ();
my @main_msvc8_dpath = ();
my @main_msvc8_rlibs = ();
my @main_msvc8_rpath = ();
# other items
my $main_warn = '';
# LIBRARY storage
# configuration stuff
my $lib_msvc8_dintd = '';
my $lib_msvc8_rintd = '';
# compiler stuff
my @lib_msvc8_dincs = ();
my @lib_msvc8_ddefs = ();
my @lib_msvc8_rincs = ();
my @lib_msvc8_rdefs = ();
# linker stuff
my @lib_msvc8_dlibs = ();
my @lib_msvc8_dpath = ();
my @lib_msvc8_rlibs = ();
my @lib_msvc8_rpath = ();
# other items
my $lib_warn = '';
###############################################


# temporary collector variables
# configuration stuff
my $msvc8_dintd = '';
my $msvc8_rintd = '';
# compiler stuff
my @msvc8_dincs = ();
my @msvc8_ddefs = ();
my @msvc8_rincs = ();
my @msvc8_rdefs = ();
# linker stuff
my @msvc8_dlibs = ();
my @msvc8_dpath = ();
my @msvc8_rlibs = ();
my @msvc8_rpath = ();
# other items
my $warn = '';


my ($LOG);
my $outfile = 'templog5.txt';
if ( open $LOG, ">$outfile" ) {
	$write_log = 1;
} else {
	$write_log = 0;
	prt( "WARNING: Unable to open $outfile LOG ...\n" );
}

read_vcproj();
close($LOG);
system($outfile);
exit(0);

sub prt {
	my $msg = shift;
	print $msg;
	if ($write_log) {
		print $LOG $msg;
	}
}

sub mydie {
	my (@msg) = @_;
	prt( @msg );
	die "Aborting\n";
}

sub prt_list {
	my (@list) = @_;
	my $ind = '';
	foreach my $line (@list) {
		if ($line =~ /^</) {
			if ($line =~ /\/>/) {
				# end xml same line
			} elsif ($line =~ /^<\//) {
				$ind = substr($ind, 1) if (length($ind));
			} else {
				# $ind .= ' ';
			}
		}
		prt( $ind.$line."\n" );
		if ($line =~ /^</) {
			if ($line =~ /\/>/) {
				# end xml same line
			} elsif ($line =~ /^<\//) {
				# $ind = substr($ind, 1) if (length($ind));
			} else {
				$ind .= ' ';
			}
		}
	}
}

sub trim_line {
	my ($l) = shift;
	chomp $l;
	$l =~ s/\r$//; # and remove CR, if present
	$l =~ s/\t/ /g;
	$l =~ s/\s\s/ /g while ($l =~ /\s\s/);
	#$l = substr($l,1) while ($l =~ /^\s/);
	#$l = substr($l,0,length($l)-1) while (($l =~ /\s$/)&&(length($l)));
	for ($l) {
		s/^\s+//;
		s/\s+$//;
	}
	return $l;
}


sub find_item3 {
	my ($st1, $st2, $st3, $st31, $st3x, $stf, @ll) = @_;
	my @hdrs = ();
	my $ln1 = '';
	my $ln = '';
	my $lb = 0;
	my $le = 0;
	my $lc = 0;
	my $st = 0;
	my $lns = ''; # accumulate until stack closed
	my $tok = '';
	my $lnsb = 0;
	prt( "Got [".$st1."], [$st2], [$st3], [$st31], [$st3x], [$stf]... \n" ) if $dbg_on2;
	foreach $ln1 (@ll) {
		chomp $ln1;
		$ln1 =~ s/\r$//; # and remove CR, if present
		$ln .= $ln1; # accumulate line
		prt( "$lc [$ln1] state=$st [".trim_line($ln)."]\n" ) if ($dbg_on3 && ($st > 2));
		if ($ln1 =~ /</) {
			$lb = $lc;
		}
		if ($ln1 =~ />/) {
			$le = $lc; # xml ends on this line
		}
		if ($ln =~ />/) {
			if ($st == 0) {
				# searching for 'VisualStudioProject'
				#if ($ln =~ /<VisualStudioProject/) {
				if ($ln =~ /$st1/) {
					$st = 1;
				}
			} elsif ($st == 1) {
				# seraching for 'Files'
				if ($ln =~ /$st2/) {
					$st = 2;
				}
			} elsif ($st == 2) {
				# searching for 'Filter'
				if ($ln =~ /$st3/) {
					#if ($ln =~ /Name=\"Header Files\"/) {
					if ($ln =~ /$st31/) {
						prt( "Enter 3 ... found $st31 ... ".trim_line($ln)."\n") if $dbg_on2;
						$st = 3;
					}
				}
			} elsif ($st == 3) {
				#if ($ln =~ /<\/Filter/) {
				if ($ln =~ /$st3x/) {
					$st = 2;
				###} elsif ( $ln =~ /(<File)(\s+)(RelativePath=\")([\.\\\w-]+)(\")+(.)+/ ) {
				} elsif ( $ln =~ /$stf/ ) {
					$tok = $4;
					$lns = trim_line($ln);
					$lnsb = $lb;
					$st = 4;
					prt( "Found 1[$1] 2[$2] 3[$3] 4[$4] 5[$5] 6[$6] (".trim_line($ln).") st=$st\n" ) if $dbg_on2;
				} else {
					prt( "NOT FOUND 1[$1] 2[$2] 3[$3] 4[$4] 5[$5] 6[$6] (".trim_line($ln).")\n" ) if $dbg_on2;
				}
			} elsif ($st == 4) {
				$lns .= trim_line($ln);
				if ( $ln =~ /<\/File>/ ) {
					push(@hdrs, $tok . '|' . $lnsb . '-' . $le);
					prt( "End file $tok, $lnsb - $le (".trim_line($lns).")\n" ) if $dbg_on2;
					$st = 3; # back to level 3
					$lns = '';
				}
			} 
			$ln = ''; # restart line accumuation
		}
		$lc++; # bump line counter
	}
	return @hdrs;
}


sub find_headers {
	my (@ll) = @_;
	my $st1 = '<VisualStudioProject';
	my $st2 = '<Files';
	my $st3 = '<Filter';
	my $st31 = 'Name="Header Files"';
	my $st3x = '<\/Filter';
	my $stf = '(<File)(\\s+)(RelativePath=\\")([\\.\\\\\\w-]+)+(\\")+(.)+';
	prt( "Got [".$st1."], [$st2], [$st3], [$st31], [$st3x], [$stf]... \n" ) if $dbg_on3;
	my @hdrs = find_item3( $st1, $st2, $st3, $st31, $st3x, $stf, @ll );
	return @hdrs;
}

sub find_sources {
	my (@ll) = @_;
	my $st1 = '<VisualStudioProject';
	my $st2 = '<Files';
	my $st3 = '<Filter';
	my $st31 = 'Name="Source Files"';
	my $st3x = '<\/Filter';
	###my $stf = '(<File)+(\\s)+(RelativePath=\\")+([\\.\\\\\\w]+)+(\\")+(.)+';
	my $stf = '(<File)(\\s+)(RelativePath=\\")([\\.\\\\\\w-]+)+(\\")+(.)+';
	prt( "Got [".$st1."], [$st2], [$st3], [$st31], [$st3x], [$stf]... \n" ) if $dbg_on3;
	my @hdrs = find_item3( $st1, $st2, $st3, $st31, $st3x, $stf, @ll );
	return @hdrs;
}


sub find_hash3 {
	my ($st1, $st2, $st3, $st31, $st3x, $stf1, $stf2, @ll) = @_;
	my %hdrs = ();
	my $ln1 = '';
	my $ln = '';
	my $lb = 0;
	my $le = 0;
	my $lc = 0;
	my $st = 0;
	my $nm = '';
	prt( "Got [".$st1."], [$st2], [$st3], [$st31], [$st3x], [$stf1] [$stf2 ... \n" ) if $dbg_on2;
	foreach $ln1 (@ll) {
		chomp $ln1;
		$ln1 =~ s/\r$//; # and remove CR, if present
		$ln .= $ln1;
		if ($ln1 =~ /</) {
			$lb = $lc;
		}
		if ($ln1 =~ />/) {
			$le = $lc;
		}
		if ($ln =~ />/) {
			if ($st == 0) {
				# searching for 'VisualStudioProject'
				#if ($ln =~ /<VisualStudioProject/) {
				if ($ln =~ /$st1/) {
					$st = 1;
				}
			} elsif ($st == 1) {
				# searching for 'Configurations'
				if ($ln =~ /$st2/) {
					$st = 2;
				}
			} elsif ($st == 2) {
				# searching for 'Configuration'
				if ($ln =~ /$st3/) {
					#if ($ln =~ /Name=\"Debug|Win32\"/) {
					if ($ln =~ /$st31/) {
						prt( "Enter 3 ... found $st31 1[$1] 2[$2] 3[%3]... ".trim_line($ln)."\n") if $dbg_on2;
						$nm = $2 . '|'; # set the NAME
						if ($ln =~ /(IntermediateDirectory=\")(\w+?)(\")/) {
							$hdrs{$nm.'IntermediateDirectory'} = '' . $lb . '-' . $le;
							prt( "Got IntDir 1[$1] 2[$2] 3[$3] ...\n" ) if $dbg_on2;
						}
						$st = 3;
					}
				}
			} elsif ($st == 3) {
				my $tln = trim_line($ln);
				#if ($ln =~ /<\/Configuration/) {
				if ($tln =~ /$st3x/) {
					prt( "Exit 3 ... found $st3x ... ".trim_line($ln)."\n") if $dbg_on2;
					$st = 2;
				} elsif ( $tln =~ /(^<Tool)+(\s)+(Name=\"VCCLCompilerTool\")+(.+)+(>)/ ) {
				###} elsif ( $ln =~ /$stf/ ) {
					$hdrs{$nm.'VCCLCompilerTool'} = '' . $lb . '-' . $le;
					prt( "1[$1] 2[$2] 3[$3] 4[$4] 5[$5] 6[$6] \n(".trim_line($ln).")\n" ) if $dbg_on2;
				} elsif ( $tln =~ /(^<Tool)+(\s)+(Name=\"VCLinkerTool\")+(.+)+(>)/ ) {
					$hdrs{$nm.'VCLinkerTool'} = '' . $lb . '-' . $le;
					prt( "1[$1] 2[$2] 3[$3] 4[$4] 5[$5] 6[$6] \n(".trim_line($ln).")\n" ) if $dbg_on2;
				}
			} 
			$ln = ''; # restart line accumuation
		}
		$lc++; # bump line counter
	}
	return %hdrs;
}

##sub find_debug {
sub find_config {
	my (@ll) = @_;
	my $st1 = '<VisualStudioProject';
	my $st2 = '<Configurations';
	my $st3 = '<Configuration';
	my $st31 = '(Name=")(Debug|Release)(\|Win32")';
	my $st3x = '<\/Configuration';
	my $stf1 = '(<Tool)+(\\s)+(Name="VCCLCompilerTool")';
	my $stf2 = '(<Tool)+(\\s)+(Name="VCCLCompilerTool")';
	###prt( "Got [".$st1."], [$st2], [$st3], [$st31], [$st3x], [$stf1] [$stf2] ... \n" );
	my %hdrs = find_hash3( $st1, $st2, $st3, $st31, $st3x, $stf1, $stf2, @ll );
	return %hdrs;
}

# sub get_lines( $configd{$key}, @main_lines );
# extract a line, like 5-5, or set of lines, like 23-27
# from an array of lines - return 'massaged' single line
sub get_lines {
	my ($lns, @arr) = @_;
	my $rln = '';
	my @ft = split( /-/, $lns );
	my $cnt = scalar @arr;
	if (($ft[0] < $cnt)&&($ft[0] <= $ft[1])&&($ft[1] < $cnt)) {
		if ($ft[0] == $ft[1]) { # ONE line
			$rln = trim_line($arr[$ft[0]]);
		} else { # multiple lines
			for (my $i = $ft[0]; $i <= $ft[1]; $i++ ) {
				$rln .= trim_line( $arr[$i] );
				if ($rln =~ /\s$/) {
					# ok, got a space
				} elsif ($i < $ft[1]) {
					$rln .= ' ';
				}
			}
		}
	}
	return trim_line($rln);
}

sub clear_arrays {
	# configuration stuff
	$msvc8_dintd = '';
	$msvc8_rintd = '';
	# compiler stuff
	@msvc8_dincs = ();
	@msvc8_ddefs = ();
	@msvc8_rincs = ();
	@msvc8_rdefs = ();
	# linker stuff
	@msvc8_dlibs = ();
	@msvc8_dpath = ();
	@msvc8_rlibs = ();
	@msvc8_rpath = ();
	# other items
	$warn = '';
}

sub process_lines {
	my (@mlines) = @_;
	my ($key, $line, $nm, $tool, $msg, $item);
	clear_arrays();
	my %configd = find_config(@mlines);
	for my $key (keys %configd) {
		prt( "key = $key => value = " . $configd{$key} . "\n" ) if $dbg_on2;
		$line = get_lines( $configd{$key}, @mlines );
		my ($nm,$tool) = split( /\|/, $key );
		###prt( "line[$line]nm=$nm tool=$tool\n" );
		if ($tool eq 'VCCLCompilerTool') {
			if ($line =~ /(AdditionalIncludeDirectories)(=)(\")(.+?)(\")(.+)/) {
				$item = $4;
				$msg = "$nm Incs=4[$item] 5[$5] ";
				if ($nm eq 'Debug') {
					@msvc8_dincs = split(/;/, $item);
					$msg .= 'added to msvc8_dincs';
				} elsif ($nm eq 'Release') {
					@msvc8_rincs = split(/;/, $item);
					$msg .= 'added to msvc8_rincs';
				} else {
					prt( "WARNING: Unknown configuration ... $nm ???\n" );
					$warn .= "WARNING: Unknown configuration ... $nm ???\n";
				}
				prt( "$msg\n" ) if $dbg_on2;
			}
			if ($line =~ /(PreprocessorDefinitions)(=)(\")(.+?)(\")(.+)/) {
				$item = $4;
				$msg = "$nm Defs=4[$item] 5[$5] ";
				if ($nm eq 'Debug') {
					@msvc8_ddefs = split(/;/, $item);
					$msg .= 'added to msvc8_ddefs';
				} elsif ($nm eq 'Release') {
					@msvc8_rdefs = split(/;/, $item);
					$msg .= 'added to msvc8_rdefs';
				} else {
					prt( "WARNING: Unknown configuration ...$nm ???\n" );
					$warn .= "WARNING: Unknown configuration ...$nm ???\n";
				}
				prt( "$msg\n" ) if $dbg_on2;
			}

		} elsif ($tool eq 'VCLinkerTool') {
			if ($line =~ /(AdditionalDependencies)(=)(\")(.+?)(\")(.+)/) {
				$item = $4;
				$msg = "$nm Libs=4[$item] 5[$5] ";
				if ($nm eq 'Debug') {
					@msvc8_dlibs = split(/ /, $item);
					$msg .= 'added to msvc8_dlibs';
				} elsif ($nm eq 'Release') {
					@msvc8_rlibs = split(/ /, $item);
					$msg .= 'added to msvc8_rlibs';
				} else {
					prt( "WARNING: Unknown configuration ...$nm ???\n" );
					$warn .= "WARNING: Unknown configuration ...$nm ???\n";
				}
				prt( "$msg\n" ) if $dbg_on2;
			}
			if ($line =~ /(AdditionalLibraryDirectories)(=)(\")(.+?)(\")(.+)/) {
				$item = $4;
				###prt( "Paths=4[$4] 5[$5]\n" );
				$item =~ s/&quot;/\"/g;
				$msg = "$nm Paths=$item 5[$5] ";
				if ($nm eq 'Debug') {
					@msvc8_dpath = split(/;/, $item);
					$msg .= 'added to msvc8_dpath';
				} elsif ($nm eq 'Release') {
					@msvc8_rpath = split(/;/, $item);
					$msg .= 'added to msvc8_rpath';
				} else {
					prt( "WARNING: Unknown configuration ...$nm ???\n" );
					$warn .= "WARNING: Unknown configuration ...$nm ???\n";
				}
				prt( "$msg\n" ) if $dbg_on2;
			}
		} elsif ($tool = 'IntermediateDirectory') {
			if ($line =~ /(IntermediateDirectory)(=)(\")(.+?)(\")(.+)/) {
				$item = $4;
				$msg = "$nm Paths=$item 5[$5] ";
				if ($nm eq 'Debug') {
					$msvc8_dintd = $item;
					$msg .= 'added to msvc8_dintd';
				} elsif ($nm eq 'Release') {
					$msvc8_rintd = $item;
					$msg .= 'added to msvc8_rintd';
				} else {
					prt( "WARNING: Unknown configuration ...$nm ???\n" );
					$warn .= "WARNING: Unknown configuration ...$nm ???\n";
				}
				prt( "$msg\n" ) if $dbg_on2;
			}
		} else {
			prt( "WARNING: Unknown Tool [$tool] ...\n" );
			$warn .= "WARNING: Unknown Tool [$tool] ...\n";
		}
	}
}

sub copy_main_items {
	$main_msvc8_dintd = $msvc8_dintd;
	$main_msvc8_rintd = $msvc8_rintd;
	# compiler stuff
	@main_msvc8_dincs = @msvc8_dincs;
	@main_msvc8_ddefs = @msvc8_ddefs;
	@main_msvc8_rincs = @msvc8_rincs;
	@main_msvc8_rdefs = @msvc8_rdefs;
	# linker stuff
	@main_msvc8_dlibs = @msvc8_dlibs;
	@main_msvc8_dpath = @msvc8_dpath;
	@main_msvc8_rlibs = @msvc8_rlibs;
	@main_msvc8_rpath = @msvc8_rpath;
	$main_warn = $warn;
}

sub copy_lib_items {
	$lib_msvc8_dintd = $msvc8_dintd;
	$lib_msvc8_rintd = $msvc8_rintd;
	# compiler stuff
	@lib_msvc8_dincs = @msvc8_dincs;
	@lib_msvc8_ddefs = @msvc8_ddefs;
	@lib_msvc8_rincs = @msvc8_rincs;
	@lib_msvc8_rdefs = @msvc8_rdefs;
	# linker stuff
	@lib_msvc8_dlibs = @msvc8_dlibs;
	@lib_msvc8_dpath = @msvc8_dpath;
	@lib_msvc8_rlibs = @msvc8_rlibs;
	@lib_msvc8_rpath = @msvc8_rpath;
	$lib_warn = $warn;
}

sub show_arrays {
	my $line = '';
	prt( "\nDebug IntDir=$msvc8_dintd, and Release IntDir=$msvc8_rintd ...\n" );
	# compiler stuff
	prt( "\nDebug compiler includes ... msvc8_dincs\n" );
	foreach $line (@msvc8_dincs) {
		prt( "$line\n" );
	}
	prt( "\nDebug compiler DEFINES ... msvc8_ddefs\n" );
	foreach $line (@msvc8_ddefs) {
		prt( "$line\n" );
	}
	prt( "\nRelease compiler includes ... msvc8_rincs\n" );
	foreach $line (@msvc8_rincs) {
		prt( "$line\n" );
	}
	prt( "\nRelease compiler DEFINES ... msvc8_rdefs\n" );
	foreach $line (@msvc8_rdefs) {
		prt( "$line\n" );
	}
	# linker stuff
	prt( "\nDebug linker LIBS ... msvc8_dlibs\n" );
	foreach $line (@msvc8_dlibs) {
		prt( "$line\n" );
	}
	prt( "\nDebug linker PATHS ... msvc8_dpath\n" );
	foreach $line (@msvc8_dpath) {
		prt( "$line\n" );
	}
	prt( "\nRelease linker LIBS ... msvc8_rlibs\n" );
	foreach $line (@msvc8_rlibs) {
		prt( "$line\n" );
	}
	prt( "\nRelease linker PATHS ... msvc8_rpath\n" );
	foreach $line (@msvc8_rpath) {
		prt( "$line\n" );
	}
	prt( "\nWARNINGS, if any\n$warn\n" );
}

sub show_main_arrays {
	my $line = '';
	prt( "\nDebug IntDir=$main_msvc8_dintd, and Release IntDir=$main_msvc8_rintd ...\n" );
	# compiler stuff
	prt( "\nDebug compiler includes ...  main_msvc8_dincs\n" );
	foreach $line (@main_msvc8_dincs) {
		prt( "$line\n" );
	}
	prt( "\nDebug compiler DEFINES ...  main_msvc8_ddefs\n" );
	foreach $line (@main_msvc8_ddefs) {
		prt( "$line\n" );
	}
	prt( "\nRelease compiler includes ...  main_msvc8_rincs\n" );
	foreach $line (@main_msvc8_rincs) {
		prt( "$line\n" );
	}
	prt( "\nRelease compiler DEFINES ...  main_msvc8_rdefs\n" );
	foreach $line (@main_msvc8_rdefs) {
		prt( "$line\n" );
	}
	# linker stuff
	prt( "\nDebug linker LIBS ...  main_msvc8_dlibs\n" );
	foreach $line (@main_msvc8_dlibs) {
		prt( "$line\n" );
	}
	prt( "\nDebug linker PATHS ...  main_msvc8_dpath\n" );
	foreach $line (@main_msvc8_dpath) {
		prt( "$line\n" );
	}
	prt( "\nRelease linker LIBS ...  main_msvc8_rlibs\n" );
	foreach $line (@main_msvc8_rlibs) {
		prt( "$line\n" );
	}
	prt( "\nRelease linker PATHS ...  main_msvc8_rpath\n" );
	foreach $line (@main_msvc8_rpath) {
		prt( "$line\n" );
	}
	prt( "\nWARNINGS, if any\n$main_warn\n" );
}

sub show_lib_arrays {
	my $line = '';
	prt( "\nDebug IntDir=$lib_msvc8_dintd, and Release IntDir=$lib_msvc8_rintd ...\n" );
	# compiler stuff
	prt( "\nDebug compiler includes ...  lib_msvc8_dincs\n" );
	foreach $line (@lib_msvc8_dincs) {
		prt( "$line\n" );
	}
	prt( "\nDebug compiler DEFINES ...  lib_msvc8_ddefs\n" );
	foreach $line (@lib_msvc8_ddefs) {
		prt( "$line\n" );
	}
	prt( "\nRelease compiler includes ...  lib_msvc8_rincs\n" );
	foreach $line (@lib_msvc8_rincs) {
		prt( "$line\n" );
	}
	prt( "\nRelease compiler DEFINES ...  lib_msvc8_rdefs\n" );
	foreach $line (@lib_msvc8_rdefs) {
		prt( "$line\n" );
	}
	# linker stuff
	prt( "\nDebug linker LIBS ...  lib_msvc8_dlibs\n" );
	foreach $line (@lib_msvc8_dlibs) {
		prt( "$line\n" );
	}
	prt( "\nDebug linker PATHS ...  lib_msvc8_dpath\n" );
	foreach $line (@lib_msvc8_dpath) {
		prt( "$line\n" );
	}
	prt( "\nRelease linker LIBS ...  lib_msvc8_rlibs\n" );
	foreach $line (@lib_msvc8_rlibs) {
		prt( "$line\n" );
	}
	prt( "\nRelease linker PATHS ...  lib_msvc8_rpath\n" );
	foreach $line (@lib_msvc8_rpath) {
		prt( "$line\n" );
	}
	prt( "\nWARNINGS, if any\n$lib_warn\n" );
}

sub show_sh_lines {
	my ($t, @arr) = @_;
	my $cnt = 0;
	foreach my $ln (@arr) {
		$cnt++;
		prt( $ln."\n" );
		if ($dbg_on2) {
			my @sp = split( /\|/, $ln ); # get source, and LINE NUMBERS
			if (scalar @sp == 2) {
				if ($t == 1) {
					# @vc8_main_lines - headers
					prt( get_lines( $sp[1], @vc8_main_lines ) );
					prt( "\n" );
				} elsif ($t == 2) {
					# @vc8_main_lines - sources
					prt( get_lines( $sp[1], @vc8_main_lines ) );
					prt( "\n" );
				} elsif ($t == 3) {
					# @vc8_lib_lines - headers
					prt( get_lines( $sp[1], @vc8_lib_lines ) );
					prt( "\n" );
				} elsif ($t == 4) {
					# @vc8_lib_lines - sources
					prt( get_lines( $sp[1], @vc8_lib_lines ) );
					prt( "\n" );
				} else {
					prt( "\nWARNING: Can NOT pass [$t] to this service ...\n" );
				}
			} else {
				prt( "\nWARNING: Line is NOT name|lines format ...\n" );
			}
		}
	}
}

sub amend_vcproj {

}

sub slurp_files {

	open IF, "<$vc8_src_lib" or mydie( "Can not OPEN $vc8_src_lib!\n" );
	@vc8_lib_lines = <IF>; # slurp whole file, to an array of lines
	close(IF);

	open IF, "<$vc8_src_main" or mydie( "Can not OPEN $vc8_src_main!\n");
	@vc8_main_lines = <IF>; # slurp whole file, to an array of lines
	close(IF);

	my $lc_lib = scalar @vc8_lib_lines;
	my $lc_main = scalar @vc8_main_lines;

	prt( "Loaded $vc8_src_lib of $lc_lib lines ...\n" );
	prt( "Loaded $vc8_src_main of $lc_main lines ...\n" );

}

sub read_vcproj {

	my $cnt = 0;

	slurp_files();

	$cnt = scalar @vc8_lib_lines;
	prt( "Finding sources in \@vc8_lib_lines ... $cnt lines ...\n" );
	@vc8_lib_srcs = find_sources(@vc8_lib_lines);
	$cnt = scalar @vc8_main_lines;
	prt( "Finding sources in \@vc8_main_lines ... $cnt lines ...\n" );
	@vc8_main_srcs = find_sources(@vc8_main_lines);

	if ($dbg_on3) {
		$cnt = scalar @vc8_lib_srcs;
		prt( "\nShowing $cnt sources in \@vc8_lib_lines ...\n" );
		$cnt = show_sh_lines(4, @vc8_lib_srcs);
		prt( "Listed $cnt sources in vc8_lib_lines ...\n" );
		$cnt = scalar @vc8_main_srcs;
		prt( "\nShowing $cnt sources in \@vc8_main_lines ...\n" );
		$cnt = show_sh_lines(2, @vc8_main_srcs);
		prt( "Listed $cnt sources in vc8_main_lines ...\n" );
	}

}


sub read_vcproj_OK {
	### = $root_dir . 'projects\VC8\FlightGearLib.vcproj';
	### = $root_dir . 'projects\VC8\FlightGear.vcproj';
	my $line = '';
	my $line1 = '';
	my $cnt = 0;
	if ( ! -f $vc8_src_lib ) {
		prt( "AWK: Unable to locate [$vc8_src_lib] file ...\n" );
		return 1;
	}
	if ( ! -f $vc8_src_main ) {
		prt( "AWK: Unable to locate [$vc8_src_main] file ...\n" );
		return 2;
	}

	slurp_files();

	prt( "Finding headers in vc8_main_lines ...\n" );
	@vc8_main_hdrs = find_headers(@vc8_main_lines);
	if ($dbg_on3) {
		$cnt = show_sh_lines(1, @vc8_main_hdrs);
		prt( "Listed $cnt headers in vc8_main_lines ...\n" );
	}

	prt( "Finding source in vc8_main_lines ...\n" );
	@vc8_main_srcs = find_sources(@vc8_main_lines);
	if ($dbg_on3) {
		$cnt = show_sh_lines(2, @vc8_main_srcs);
		prt( "Listed $cnt sources in vc8_main_lines ...\n" );
	}

	prt( "Finding headers in lib_lines ...\n" );
	@vc8_lib_hdrs = find_headers(@vc8_lib_lines);
	if ($dbg_on3) {
		$cnt = show_sh_lines(3, @vc8_lib_hdrs);
		prt( "Listed $cnt headers in vc8_lib_lines ...\n" );
	}

	prt( "Finding source in vc8_lib_lines ...\n" );
	@vc8_lib_srcs = find_sources(@vc8_lib_lines);
	if ($dbg_on3) {
		$cnt = show_sh_lines(4, @vc8_lib_srcs);
		prt( "Listed $cnt sources in vc8_lib_lines ...\n" );
	}

	prt( "Processing vc8_main_lines ...\n" );
	process_lines(@vc8_main_lines);
	copy_main_items();
	show_main_arrays() if $dbg_on3;

	prt( "Processing vc8_lib_lines ...\n" );
	process_lines(@vc8_lib_lines);
	copy_lib_items();
	show_lib_arrays() if $dbg_on3;

	return 0;
}

