#!/Perl

print "Hello, World...\n";

# AIM: To read the INPUT directory, and generate a HTML file
# to allow down load of all the ZIPS files found there ...

my $verbose = 1;
my $verb2 = 1;
#my $my_folder = 'C:\HOMEPAGE\Max5\zips';
my $my_folder = shift || die "Must input a FOLDER name ...\n";
my @dirs = ($my_folder); # folders to process
my @dir_obj = (); # start with NONE
my $do_cnt = 0;
my $htm_fil = shift || 'indexall.htm';
my $HF;
my $d;
open $HF, ">$htm_fil" or die "Can NOT open HTML file $htm_fil!\n";

while ( scalar @dirs ) {
	local @dirs2 = @dirs;
	@dirs = ();
	local $dir;
	foreach $dir (@dirs2) {
		print '.' if !$verb2;
		process_dir($dir);
	}
	print "\n" if !$verb2;
}
$do_cnt = scalar @dir_obj;
if ($do_cnt) {
	print "Found $do_cnt zips ...\n";
	add_htm_head($HF, 'Zip File Listing');
	print $HF "<p>Click on the following links to download the ZIP file.</p>\n";
	print $HF "<p align=\"center\">\n";
	foreach $d (@dir_obj) {
		$msg = "<a href=\"$d\">$d</a>";
		print $HF "$msg<br>\n";
	}
	print $HF "</p>\n";
	print $HF "<p>Listed $do_cnt zips for download ...</p>\n";
	add_htm_tail($HF, "<!-- Max5.2005.11.29 geoff mclane - generated by $0 -->");
	close ($HF);
	system $htm_fil;
} else {
	print "WARNING: No zips found ...\n";
}
##################################
# end of program

#################################
### only subs below
#################################
sub add_htm_head {
	local ($fh, $tit) = @_;
	print $fh <<EOF;
<html>
<head>
<title>$tit</title>
</head>
<body>
<h1 align="center">$tit</h1>
EOF
}

sub add_htm_tail {
	local ($fh, $tit) = @_;
	print $fh <<EOF;
</body>
</html>
$tit
EOF
}

sub process_dir {
	local ($in_folder) = @_;
	print "Processing folder $in_folder ...\n" if $verb2;
	if( !( -d $in_folder ) ) {
		print "Folder $in_folder is NOT a directory! ... aborting ...\n" if $verbose;
		return 0;
	}

	if (! opendir(DIRH, $in_folder) ) {
		print "ERROR: Can NOT open directory $in_folder ... aborting ...\n" if $verbose;
		return 0;
	}

	local @files = readdir(DIRH);
	closedir(DIRH);
	local $fcnt = scalar @files;
	if ((! @files) || ($fcnt < 3)) {
		print "No files found in folder $in_folder ...\n" if $verb2;
		return 0;
	}

	local ($fn, $ffn);
	local $got_obj = 0;
	print "Found $fcnt items in folder ...\n" if $verb2;

	$got_obj = 0;
	foreach $fn (@files) {
		if ($in_folder eq '.') {
			$ffn = $fn;
		} else {
			$ffn = $in_folder . '\\' . $fn;
		}
		if ( -d $ffn ) {
			if (($fn eq '.') || ($fn eq '..')) {
				# do nothing
			} else {
				# do nothing
				###push(@dirs, $ffn);
				###print "Sub-directory $ffn ...\n" if $verb2;
			}
		} else {
			if ( $fn =~ /\.zip$/i) {
				print "ZIP File $ffn ...\n" if $verb2;
				$got_obj++;
				push(@dir_obj, $ffn);
			} else {
				print "File $ffn ...\n" if $verb2;
			}
		}
	}

	local $dcnt = scalar @dirs;
	if ($got_obj) {
		print "Found $got_obj zips in folder .../n" if $verb2;
	} else {
		print "Found NO zipd in folder ...\n" if $verb2;
	}
	if ($dcnt) {
		print "Found $dcnt directories to process ...\n" if $verb2;
	}
}

# eof - zipindex.pl
