#!/usr/bin/perl -w
#< isleapyear.pl - given a year, report if a leap year
# from : http://www.willmaster.com/blog/perl/calculate-leap-years.php
# Works for Julian calendar, established in 1582
# 21/08/2010 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;

my $ex = 2;
my $in_year = 0;
my $done = 0;

sub prt($) {
    print shift;
}

sub IsLeapYear($) {
   my ($year) = shift;
   return 0 if $year % 4;
   return 1 if $year % 100;
   return 0 if $year % 400;
   return 1;
}

if (@ARGV) {
    $in_year = shift @ARGV;
    if ($in_year =~ /^\d+$/) {
        my $last_ly = $in_year;
        my $next_ly = $in_year;
        if (IsLeapYear($in_year)) {
            prt("Yes, $in_year is a LEAP YEAR. ");
            $ex = 1;
            $last_ly--;
            $next_ly++;
        } else {
            prt("No, $in_year is NOT a LEAP YEAR. ");
            $ex = 0;
        }
        $last_ly -= 1 while (!IsLeapYear($last_ly));
        $next_ly += 1 while (!IsLeapYear($next_ly));
        prt("Previous is $last_ly, next is $next_ly\n");
        $done = 1;
    } else {
        prt("Entered YEAR ($in_year) is NOT a number...\n");
    }
}

prt("Enter a valid YEAR value to test...\n") if (!$done);
exit($ex);

# eof
