#!/perl -w
# NAME: ansi-console.pl
# AIM: Display some color, using Win32::Console::ANSI;
use strict;
use warnings;
use Win32::Console::ANSI;
#use Term::ANSIColor;

require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

my @array1 = ();
my @array2 = ();
my $colr1 = "\033[36;1m";
my $colrn = "\033[m";

fill_arrays( \@array1, \@array2 );
list_array( \@array1 );
list_array( \@array2 );

close_log($outfile,0);
exit(0);


sub list_array {
    my ($ar) = shift;

    foreach my $val (@$ar) {
        prt( "$colr1$val$colrn\n" );
    }
}

sub fill_arrays {
    my ($ar1, $ar2) = @_;

    push(@$ar1, "one");
    push(@$ar1, "two");
    push(@$ar1, "three");
    push(@$ar1, "four");

    push(@$ar2, "2one");
    push(@$ar2, "2two");
    push(@$ar2, "2three");
    push(@$ar2, "2four");

}

# eof
