#!/Perl
# Series: Automation Mocrosfot Word
# original from : http://msdn.microsoft.com/library/default.asp?url=/library/en-us/dv_wrcore/html/wrconwordobjectmodeloverview.asp
# purpose: To load and show the FULL enumeration of the Microsoft Word ?.? Object
# Library. Presently it only test for version 8.0, 9.0, and 10.0 ... maybe yours
# will be different. The enumeration is loaded into a HASH, and sorted, for the
# final output. At the base are some extracts from MS online HELP ...
# The LOG output is loaded into notepad, or whatever is associated with
# text files at the end, so the list can be reviewed ...
# author: geoff mclane - mailto: geoffair@hotmail.com - 2006-06-12
#
use Win32::OLE::Const;
# LOG FILE STUFF
my ($LOG);
my $write_log = 0;
my $outfile = "temp.$0.txt";
if ( open( $LOG, ">$outfile" ) ) {
    $write_log = 1;
} else {
    $write_log = 0;
    prt( "WARNING: Unable to open $outfile LOG ...\n" );
}

# try various versions ...
# NOTE: The 'version' installed can be found using the OLEVIEW.exe tool,
# from microsoft ... expand the tree - 'Type Libraries', and search
# down the long list to 'Microsoft Word ...' ...
prt( "Trying to locate, and load Microsoft Word ?.? Object Library ...\n" );
my $wd = Win32::OLE::Const->Load("Microsoft Word 8.0 Object Library");
if ($wd) {
	prt("Loaded 'Microsoft Word 8.0 Object Library' ...\n" );
} else {
	prt("Failed 8.0, try 9.0 ...\n" );
	$wd = Win32::OLE::Const->Load("Microsoft Word 9.0 Object Library");
	if ($wd) {
		prt("Loaded 'Microsoft Word 9.0 Object Library' ...\n" );
	} else {
		prt("Failed 9.0, try 10.0 ...\n" );
		$wd = Win32::OLE::Const->Load("Microsoft Word 10.0 Object Library");
		if ($wd) {
			prt("Loaded 'Microsoft Word 10.0 Object Library' ...\n" );
		} else {
			mydie( "Failed to load 8, 9, or 10 ... should try OTHER numbers ...\n" );
		}
	}
}

# got a version loaded ...
my $kcnt = keys(%$wd);
prt( "Output of $kcnt keys ...sorted alphbetically ...\n" );
foreach my $key (sort keys %$wd) {
	prt( "$key = $wd->{$key}\n" );
}

prt( "Just one example - wdGreen = " );
prt( $wd->{'wdGreen'} );
prt("\n");

close_log(); # close and load log using system()

exit(0);

################################
### output and log file
sub wlog {
	my $ml = shift;
	print $LOG $ml;
}

sub prt {
	my $m = shift;
	if ($write_log) {
		wlog($m);
	}
	print $m;
}

sub mydie {
	my $msg = shift;
	if ($write_log) {
		wlog($msg);
	}
	die $msg;
}

sub close_log {
	if ($write_log) {
		prt( "Closing LOG file, and passing to 'system($outfile)'\nMay need to CLOSE notepad to continue ...\n" );
		close( $LOG );
		system( $outfile );
	}
}

# Some notes from MS online help - MSDN 
# Application
# - Document
#    - Bookmarks - Range
#    - Range - Bookmarks
# - Selection
#    - Bookmarks - Range
#    - Document - Range
#               - Bookmarks
#    - Range - Bookmarks
# Application Object - 
# represents the Word application, and is the parent
# of all of the other objects. Its members usually 
# apply to Word as a whole. You can use its properties and 
# methods to control the Word environment.
# For more information, see Word Application Object.
# http://msdn.microsoft.com/library/default.asp?url=/library/en-us/dv_wrcore/html/wrgrfapplicationobject.asp
# Word Application Object Properties
# Active Window Property, ActiveDocument, ActivePrinter 
# ActiveWindow, AutoCorrect, Caption, CapsLock,
# DisplayAlerts, DisplayStatusBar, FileSearch,
# Path, Options, Selection, UserName, Visible 
# like
# $Word->{'DisplayAlerts'} = wdAlertsNone
# Application Methods -
# CheckSpelling Help Move Resize Quit SendFax 
# - Document Object
# Collections - Characters Words Sentences Paragraphs Sections HeadersFooters 

# eof - autword04.pl
