#!/Perl
# bin2hex02.pl
# AIM: Read a file in BINARY format, and prepare
# a hexadecimal display of the results ...
# base on
# bin2hex.pl by Chami.com
# http://www.chami.com/tips/
# added output to log file
# and if language is Perl, add the ASCII after the data
# geoff mclane - october, 2006
# site: http://geoffmclane.com/mperl/index.htm
require "logfile.pl" or die "Missing logfile.pl ...\n"; # my simple log file and some other utility subs
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
open_log($outfile);
prt( "$0 ... Hello, World...\n" );
# language id
# 0 = Perl (default)
# 1 = C / C++
# 2 = Pascal / Delphi
### $lang  = $ARGV[1];
### $in_file = $ARGV[0];
# number of characters per line
$chars_per_line = 15;
$add_ascii = 1; # set 0 for NO ASCII
# set your own DEFAULT file
$def_file = 'F:/FTEMP/Support/addrb2.dat';
# -----------------------------------------
$lang = 0;
$rem_begin  = "begin binary data:";
$rem_end    = "end binary data.";
if (@ARGV) {
	$in_file = pop @ARGV;
} else {
	$in_file = $def_file;
}
if (@ARGV) {
	$lang = pop @ARGV;
}

# initialize for Perl strings by default
$_var       = "# $rem_begin %d\n".
              "\$bin_data = <<\"EOF\";\n";
$_begin     = '';
$_end       = "\nEOF\n";
$_break     = "\n";
$_format    = "\x%02X";
$_separator = ",";
$_comment   = "# $rem_end ".
              "size = %d bytes";
$_sepascii  = ' | ';

# C / C++
if(1 == $lang) {
  $_var       = "/* $rem_begin */\n".
                "char bin_data[] = ".
                "/* %d */\n";
  $_begin     = "{";
  $_end       = "};\n";
  $_break     = "\n";
  $_format    = "0x%02X";
  $_separator = ",";
  $_comment   = "/* $rem_end ".
                "size = %d bytes */\n";
} elsif(2 == $lang) {
  $_var       = "{ $rem_begin }\n".
                "const bin_data : ".
                "array [1..%d] of ".
                "byte = \n";
  $_begin     = "(";
  $_end       = ");\n";
  $_break     = "\n";
  $_format    = "\$%02X";
  $_separator = ",";
  $_comment   = "{ $rem_end ".
                "size = %d bytes }\n";
} elsif (0 == $lang) {
  # default have been set	
} else {
	mydie( "ERROR: Unknown language value [$lang]! Only 0, 1, or 2 allowed.\n" );
}

if(open(F, "<$in_file")) {
  binmode(F);
  $bin = 0;
  $s = '';
  $i = 0;
  $a = '';
  $count = 0;
  $ch = '';
  $s .= $_begin;
  while(!eof(F)) {
    if( $i >= $chars_per_line ) {
		if ($add_ascii && ($lang == 0)) {
	      $s .= $_sepascii . $a;
		}
      $s .= $_break;
      $i = 0;	# restart line
	  $a = '';
    }
	$ch = getc(F);
	$bin = ord($ch);
	if (($bin < 32)||($bin >= 127)) {
		$ch = '.'; # use a DOT
	}
    $s .= sprintf($_format, $bin);	# get hex
	$a .= $ch;	# and ascii character
    ++$i;
    ++$count;
	$s .= $_separator;
  }
  close( F );

  # chop of last addition of separator
  $s = substr($s,0, length($s) - length($_separator));
  if ($add_ascii && ($lang == 0)) {
	  while ( $i < $chars_per_line ) {
		  $s .= '    ';
		  $i++;
	  }
	  $i = 0;
	  while ($i < length($_separator)) {
		  $s .= ' ';
		  $i++;
	  }
	  $s .= $_sepascii . $a;
  }
  $s .= $_end;
  $s .= sprintf( $_comment, $count );
  $s .= "\n";
  $s = "\n".sprintf($_var, $count).$s;
  prt( $s );
} else {
  prt( "FAILED to open [$in_file] ...\n".
    "bin2hex02.pl - based on bin2hex.pl by Chami.com\n".
    "usage:\n".
    "perl bin2hex02.pl <binary file> <language id>\n".
    "  <binary file> : path to the binary file\n".
    "  <language id> : 0 = Perl (default), 1 = C/C++/Java, 2 = Pascal/Delphin\n");
}
close_log($outfile,1);
exit(0);

### eof - bin2hex02.pl
