#!/perl -w
# NAME: chkatlaspal.pl
# AIM: Read Atlas palette file, and list colors, and material,
# and show colors NOT used.
# 22/01/2009 
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";

open_log($outfile);

my $in_file = 'C:\FG\27\Atlas\build\msvc\AtlasPalette';
my $htm_file = "tempatlas.htm";

my $loadlog = 0;
prt( "$0 ... Processing $in_file ...\n" );
my @Colors = ();
my @Materials = ();
my $matlen = 22;    # IntermittentReservoir 
process_file( $in_file );

my $ccnt = scalar @Colors;
my $mcnt = scalar @Materials;
prt( "Got $ccnt colors, and $mcnt materials ...\n" );
if ($ccnt && $mcnt) {
    process_mats();
    $loadlog = 1;
    gen_html_table( $htm_file );
}

close_log($outfile,$loadlog);
exit(0);
#########################################

sub get_YYYYMMDD_hhmmss {
    my ($t) = shift;
    my @f = (localtime($t))[0..5];
    my $m = sprintf( "%04d/%02d/%02d %02d:%02d:%02d",
        $f[5] + 1900, $f[4] +1, $f[3], $f[2], $f[1], $f[0]);
    return $m;
}

sub gen_html_table {
    my ($htm) = shift;
    my ($j, $cind, $red, $green, $blue, $cnt, $max);
    my ($hred, $hgreen, $hblue, $clrtxt, $hex);
    my ($tred, $tgreen, $tblue);
    my ($ored, $ogreen, $oblue, $txtclr, $txthex);
    my $wrap = 4;
    my $ccnt = 0;
    $max = scalar @Colors;
    prt( "Generating table of $max colors ...\n" );
    my $txt = get_html_head();
    $txt .= "<h1 align=\"center\">Table of Atlas Colors</h1>";
    $txt .= "<p>Table of $max colors from file $in_file</p>\n";
    $txt .= "<table align=\"center\"\n";
    $txt .= "       border=\"1\"\n";
    $txt .= "       cellpadding=\"2\"\n";
    $txt .= "       cellspacing=\"2\"\n";
    $txt .= "       summary=\"color table\">\n";
    for ($j = 0; $j < $max; $j++) {
        $cind = $Colors[$j][0];
        $red = $Colors[$j][1];
        $green = $Colors[$j][2];
        $blue = $Colors[$j][3];
        $cnt = $Colors[$j][4];
        $clrtxt = sprintf( "%0.3f,%0.3f,%0.3f", $red, $green, $blue );
        $hred = int(($red * 255) + 0.5);
        $hgreen = int(($green * 255) + 0.5);
        $hblue = int(($blue * 255) + 0.5);
        $hex = sprintf( "%02X%02X%02X", $hred, $hgreen, $hblue );
        $tred = 1.0 - $red;
        $tgreen = 1.0 - $green;
        $tblue = 1.0 - $blue;
        $ored = int(($tred * 255) + 0.5);
        $ogreen = int(($tgreen * 255) + 0.5);
        $oblue = int(($tblue * 255) + 0.5);
        $txthex = sprintf( "%02X%02X%02X", $ored, $ogreen, $oblue );

        $txt .= "<tr>\n" if ($ccnt == 0);
		$txt .= "<td bgcolor=\"#".$hex."\">\n";
		$txt .= "<a href=\"javascript:clk();\"\n";
		$txt .= "         onmouseover=\"sbgc('#".$hex."'); return true;\">";
        $txt .= "<font color=\"#$txthex\">";
		#$txt .= "<span class=\"fnt50\">";
        $txt .= "$red,$green,$blue\n";
        #$txt .= "</span>";
        $txt .= "</font>";
        $txt .= "</a>";
        $txt .= "</td>\n";
        $ccnt++;
        if ($ccnt == $wrap) {
            $txt .= "</tr>\n";
            $ccnt = 0;
        }
    }
    if ($ccnt) {
        while ($ccnt < $wrap) {
    		$txt .= "<td>\n";
            $txt .= "&nbsp;\n";
            $txt .= "</td>\n";
            $ccnt++;
        }
        $txt .= "</tr>\n";
    }

    $txt .= "</table>";
    $txt .= "<p>Generated ".get_YYYYMMDD_hhmmss(time())." by $pgmname.</p>\n";
    $txt .= "</body>\n";
    $txt .= "</html>\n";
    write2file($txt,$htm);
    prt( "Written file $htm\n" );
    system($htm);
}

sub get_html_head {
	my $head = <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
 <head>
  <title>
   Table of Atlas colors
  </title>
  <meta http-equiv="Content-Language"
        content="en-us">
  <meta http-equiv="Content-Type"
        content="text/html; charset=us-ascii">
  <meta name="keywords"
        content="web,html,html code,color chart,background colors,colorchart,charts,bgcolor,font colors,color numbers,hexidecimal,rgb,color code,colorcode,code,Atlas,Map">
  <meta name="description"
        content="geoffair.net Atlas color chart.">
  <link rel="stylesheet"
        href="cxx_nbg.css"
        type="text/css">
  <script language="JavaScript"
        type="text/javascript">
<!-- Begin
  // *** CROSS-BROWSER COMPATIBILITY ***
  var isDOM = (document.getElementById ? true : false); 
  var isIE4 = ((document.all && !isDOM) ? true : false);
  var isNS4 = (document.layers ? true : false);
  var isDyn = (isDOM || isIE4 || isNS4);
  var winWidth;
  var winHeight;
  var dnclick = 0;

  // get a reference
  function getRef(id)
  {
  if (isDOM) return document.getElementById(id);
  if (isIE4) return document.all[id];
  if (isNS4) return document.layers[id];
  }
  // get style
  function getSty(id)
  {
  return (isNS4 ? getRef(id) : getRef(id).style);
  }
  // change background
  function sbgc(hex) {
  document.bgColor=hex;
  }

  function clk() {
  if(dnclick)
  dnclick = 0;
  else
  dnclick = 1;
  }

  //  End -->
  </script>
  <style type="text/css">
  <!--
  a:link{ color:#004080; text-decoration:none; }
  a:hover{ color:#FF0000; background-color:#ffff66; }
  a:visited{ color:#004080; text-decoration:none; }
  .fnt70{ font-size : 70% }
  .fnt50{ font-size : 50% }
  // -->
  </style>
 </head>
 <body>
  <a name="top"
        id="top"></a>
EOF

    return $head;
}

sub process_mats {
    my ($i, $j, $name, $ind, $cind, $fnd, $red, $green, $blue, $cnt, $msg);
    my ($cind2, $red2, $green2, $blue2);
    my $maxfreq = 0;
    for ($i = 0; $i < $mcnt; $i++) {
        $name = $Materials[$i][0];
        $ind  = $Materials[$i][1];
        if ($ind == -1) {
            prt( "$name - Color by ALTITUDE\n" );
        } else {
            $fnd = 0;
            #  Colors        index    red      green    blue     use spare
            #  Colors        0        1        2        3        4   5
            #push(@Colors, [ $arr[1], $arr[2], $arr[3], $arr[4], 0,  0 ]);
            for ($j = 0; $j < $ccnt; $j++) {
                $cind = $Colors[$j][0];
                if ($ind == $cind) {
                    $fnd = 1;
                    $red = $Colors[$j][1];
                    $green = $Colors[$j][2];
                    $blue = $Colors[$j][3];
                    $Colors[$j][4]++;
                    $cnt = $Colors[$j][4];
                    last;
                }
            }
            if ($fnd) {
                $msg = $name;
                $msg .= " " while (length($msg) < $matlen);
                $msg .= " - r($red), g($green), b($blue) - index $ind - count $cnt";
                prt("$msg\n");
                $maxfreq = $cnt if ($cnt > $maxfreq);
            } else {
                prt( "$name - $ind NOT FOUND\n" );
            }
        }
    }

    # SHOW UNUSED (IF NOT 0, which is a default)
    $fnd = 0;
    for ($j = 0; $j < $ccnt; $j++) {
        $cind = $Colors[$j][0];
        $red = $Colors[$j][1];
        $green = $Colors[$j][2];
        $blue = $Colors[$j][3];
        $cnt = $Colors[$j][4];
        if (($cnt == 0)&&($cind != 0)) {
            prt( "Color $cind NOT USED! r($red), g($green), b($blue)\n" );
            $fnd++;
        }
    }
    if ($fnd) {
        prt( "Have $fnd colors NOT USED!\n" );
    } else {
        prt( "All colors used.\n" );
    }

    # COMPARE COLORS, and show EQUALS
    $fnd = 0;
    for ($j = 0; $j < $ccnt; $j++) {
        $cind = $Colors[$j][0];
        $red = $Colors[$j][1];
        $green = $Colors[$j][2];
        $blue = $Colors[$j][3];
        $cnt = $Colors[$j][4];
        $ind = $Colors[$j][5];
        if ($ind == 0) {
            for ($i = 0; $i < $ccnt; $i++) {
                $cind2 = $Colors[$i][0];
                if ($cind != $cind2) {
                    $red2 = $Colors[$i][1];
                    $green2 = $Colors[$i][2];
                    $blue2 = $Colors[$i][3];
                    if (($red == $red2)&&($green == $green2)&&($blue == $blue2)) {
                        prt( "Color $cind EQUALS $cind2 - r($red), g($green), b($blue)\n" );
                        $fnd++;
                        $Colors[$j][5] = $i + 1;
                        $Colors[$i][5] = $j + 1;
                    }
                }
            }
        }
    }
    if ($fnd) {
        prt( "Found $fnd with SAME colors\n" );
    } else {
        prt( "All colors unique.\n" );
    }

    # FREQUENCY
    $cnt = $maxfreq;
    while ($cnt) {
        $msg = "";
        for ($j = 0; $j < $ccnt; $j++) {
            $cind = $Colors[$j][0];
            #$red = $Colors[$j][1];
            #$green = $Colors[$j][2];
            #$blue = $Colors[$j][3];
            if ($cnt == $Colors[$j][4]) {
                $msg .= "$cind ";
            }
        }
        if (length($msg)) {
            prt( "Freq $cnt: Indexes: $msg\n" );
        } else {
            prt( "Freq $cnt: NO Indexes\n" );
        }
        $cnt--;
    }

    # what else to check

}

sub process_file {
    my ($inf) = shift;
    my ($max, @lines, $line, @arr);
    if (open INF, "<$inf") {
        @lines = <INF>;
        close INF;
        $max = scalar @lines;
        prt( "Processing $max lines from $inf ...\n" );

        foreach $line (@lines) {
            chomp $line;
            $line = trim_all($line);
            next if (length($line) == 0);
            next if ($line =~ /^#/);
            @arr = split(/\s/, $line);
            if ($line =~ /^Colour\s+/) {
                if (scalar @arr == 6) {
                    # Colors        index    red      green    blue     use spare
                    # Colors        0        1        2        3        4   5
                    push(@Colors, [ $arr[1], $arr[2], $arr[3], $arr[4], 0,  0 ]);
                } else {
                    prt( "ERROR: Color line [$line]\n" );
                }
            } elsif ($line =~ /^Material\s+/) {
                if (scalar @arr == 3) {
                    # Materials        name     index
                    push(@Materials, [ $arr[1], $arr[2], 0 ]);
                } else {
                    prt( "ERROR: Material line [$line]\n" );
                }
            } else {
                prt( "Unknown lines [$line]\n" );
            }
        }
    } else {
        prt( "ERROR: Unable to open file $inf ...\n" );
    }
}

# eof - chkatlaspal.pl
