#!/usr/bin/perl -w
# chkpath2.pl
use strict;
use warnings;

my ($dir,$sdir);
my $verbosity = 0;

sub VERB1() { return ($verbosity >= 1); }

sub prt($) { print shift; }

my $find_path = '';

foreach $dir (@ARGV) {
    if ($dir =~ /^-/) {
        $sdir = $dir;
        $sdir = substr($sdir,1) while ($sdir =~ /^-/);
        if ($sdir =~ /^v/) {
            while ($sdir =~ /^v/) {
                $verbosity++;
                $sdir = substr($sdir,1);
            }
        } else {
            prt("Unknown command [$dir]!\n");
        }
    } else {
        $find_path = $dir;
        prt("Finding path [$find_path]\n");
    }
}

my $ret = 0;
my $path_env = $ENV{"PATH"};
if (defined $path_env) {
	my @folds = split(/;/,$path_env);
	my $fcnt = scalar @folds;
	prt( "Got $fcnt directories...\n" );
    foreach $dir (@folds) {
        if (length($find_path)) {
            if ($dir =~ /$find_path/i) {
                $ret = 1;
                prt("Found [$dir]\n");
            }
        }
        if (VERB1()) {
            if (-d $dir) {
                prt("$dir [OK]\n");
            } else {
                prt("dir [NOT FOUND]\n");
            }
        }
    }
}

if (length($find_path) == 0) {
    prt("No path to find...\n");
}
prt("Exit with [$ret]\n");
exit $ret;

