#!/usr/bin/perl -w
# NAME: cmakesrcs.pl
# AIM: Given a folder, follow the CMakeLists.txt trail, and list projects and source
# 13/07/2013 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
require 'lib_cmakeread.pl' or die "Unable to load 'lib_cmakeread.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2013-03-17";
my $load_log = 0;
my $in_dir = '';
my $verbosity = 0;
my $out_file = '';
my $in_file = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'C:\FG\18\geomview';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_one_file($$);


sub get_sub_dir($) {
    my $line = shift;
    my $sd = '';
    if ($line =~ /\(\s*(.+)\s*\)/) {
        $sd = $1;
    }
    return $sd;
}

sub strip_brackets($) {
    my $txt = shift;
    $txt =~ s/^\(//;
    $txt =~ s/\)$//;
    $txt = trim_all($txt);
    return $txt;
}

sub process_one_file($$) {
    my ($inf,$rm) = @_;
    my %hash = ();
    my $rh = \%hash;
    $hash{'BASE_FILE'} = $inf;
    $hash{'CURR_WARNINGS'} = \@warnings;
    $hash{'CURR_DBG_FLAG'} = 0;
    load_cmake_script_file(\%hash);
    ##$hash{'CURR_DUMP_NAME'} = $temp_dir.$PATH_SEP."tempcmake.txt";
    ##dump_cmake2(\%hash);
    ${$rm}{$inf} = $rh;
    my $rclines = ${$rh}{"CLEAN_LINES"};
    my $cnt = scalar @{$rclines};
    my $bfile = ${$rh}{'BASE_FILE'};
    prt("Contents of [$bfile] $cnt 'cleaned' lines\n");
    my ($line,$sd,$ff,$rcln,$tag,$act,$lnn,$endln,@arr,$cnt,$i,$ra);
    my ($name,$dir) = fileparse($inf);
    ut_fix_directory(\$dir);
    my %h = ();
    foreach $rcln (@{$rclines}) {
        #                  0     1      2       3      4
        #push(@{$rclines},[$line,$ucdir,$action,$bgnln,$endln]);
        $line = ${$rcln}[0];
        $tag = ${$rcln}[1];
        $act = ${$rcln}[2];
        $lnn = ${$rcln}[3];
        $endln = ${$rcln}[4];
        if ($line =~ /^set/) {
            $sd = strip_brackets($act);
            @arr = space_split($sd);
            #prt("$line [$act] $sd\n");
            $cnt = scalar @arr;
            $act = $arr[0];
            $h{$act} = [];
            $ra = $h{$act};
            for ($i = 1; $i < $cnt; $i++) {
                push(@{$ra}, $arr[$i]);
            }

        }
    }
    foreach $rcln (@{$rclines}) {
        #                  0     1      2       3      4
        #push(@{$rclines},[$line,$ucdir,$action,$bgnln,$endln]);
        $line = ${$rcln}[0];
        $tag = ${$rcln}[1];
        $act = ${$rcln}[2];
        $lnn = ${$rcln}[3];
        $endln = ${$rcln}[4];
        if ($line =~ /^add_subdirectory/i) {
            $sd = strip_brackets($act);
            prt("$line [$act] $sd\n");
            $sd = get_sub_dir($line);
            $ff = $dir.$sd.$PATH_SEP.'CMakeLists.txt';
            if (-f $ff) {
                process_one_file($ff,$rm);
            } else {
                prtw("WARNING: Cn NOT locate file [$ff]!\n");
            }
        }
    }
}

sub process_the_file($) {
    my $inf = shift;
    my %h = ();
    process_one_file($inf,\%h);
    my @arr = keys %h;
    my $cnt = scalar @arr;
    prt("Processed $cnt cmake files...\n");

}



#########################################
### MAIN ###
parse_args(@ARGV);
process_the_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_dir = $arg;
            prt("Set input to [$in_dir]\n") if (VERB1());
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if ((length($in_dir) ==  0) && $debug_on) {
            $in_dir = $def_file;
            prt("Set DEFAULT input to [$in_dir]\n");
        }
    }
    if (length($in_dir) ==  0) {
        pgm_exit(1,"ERROR: No input directory found in command!\n");
    }
    if (! -d $in_dir) {
        pgm_exit(1,"ERROR: Unable to find in directory [$in_dir]! Check name, location...\n");
    }
    $sarg = $in_dir;
    ut_fix_directory(\$sarg);
    $sarg .= 'CMakeLists.txt';
    if (!-f $sarg) {
        pgm_exit(1,"ERROR: Unable to find cmake [$sarg]! Check name, location...\n");
    }
    $in_file = $sarg;
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
