#!/perl -w
# NAME: cmpcomp.pl
# AIM: Compare tow compiler strings ...
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my ($i1, $ch1, $tg1);
my ($i2, $ch2, $tg2);
my $comp1temp = '-c  -I.  -nologo -GF -W3 -MD -Zi -DNDEBUG -O1 -DWIN32 -D_CONSOLE '.
'-DNO_STRICT -DHAVE_DES_FCRYPT -DNO_HASH_SEED -DUSE_SITECUSTOMIZE -DPERL_IMPLICIT_CONTEXT '.
'-DPERL_IMPLICIT_SYS -DUSE_PERLIO -DPERL_MSVCRT_READFIX -MD -Zi -DNDEBUG -O1 '.
' -DVERSION=\"0.01\"  -DXS_VERSION=\"0.01\"  "-IC:\Perl\lib\CORE"';

my $comp1 = '-c  -IC:\Projects\tidy\tidycvs\include  -nologo -GF -W3 -MD -Zi '.
'-DNDEBUG -O1 -DWIN32 -D_CONSOLE -DNO_STRICT -DHAVE_DES_FCRYPT -DNO_HASH_SEED '.
'-DUSE_SITECUSTOMIZE -DPERL_IMPLICIT_CONTEXT -DPERL_IMPLICIT_SYS -DUSE_PERLIO '.
'-DPERL_MSVCRT_READFIX -MD -Zi -DNDEBUG -O1    -DVERSION=\"0.01\"  -DXS_VERSION=\"0.01\" '.
'-D_WINDOWS -D_USRDLL -DTIDYDLL_EXPORTS -D_WINDLL -D_CSTDIO_ -D_STD_USING '.
'-DSWIGRUNTIME_DEBUG -EHsc "-IC:\Perl\lib\CORE"';

my $comp2 = '/O1 /GL /I "C:\Perl\lib\CORE" /I "C:\Projects\tidy\tidycvs\include" '.
'/D "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_USRDLL" /D "TIDYDLL_EXPORTS" /D "NO_STRICT" '.
'/D "HAVE_DES_FCRYPT" /D "NO_HASH_SEED" /D "USE_SITECUSTOMIZE" /D "PERL_IMPLICIT_CONTEXT" '.
'/D "PERL_IMPLICIT_SYS" /D "USE_PERLIO" /D "PERL_MSVCRT_READFIX" /D "VERSION=\"0.01\"" '.
'/D "XS_VERSION=\\"0.01\\"" /D "_CSTDIO_" /D "_STD_USING" /D "_WINDLL" /FD /EHsc /MD '.
'/Fo"Release\\" /Fd"Release\vc80.pdb" /W3 /c /Zi /Gd /TP';

my $comp3 = '/W3 /IC:\Projects\tidy\tidycvs\include  /IC:\Perl\lib\CORE /D '.
' "WIN32" /D "NDEBUG" /D "_WINDOWS" /D "_USRDLL"  /D "TIDYDLL_EXPORTS" /D "NO_STRICT" '.
'/D "HAVE_DES_FCRYPT" /D "NO_HASH_SEED"  /D "USE_SITECUSTOMIZE" /D "PERL_IMPLICIT_CONTEXT" '.
'/D "PERL_IMPLICIT_SYS"  /D "USE_PERLIO" /D "PERL_MSVCRT_READFIX" '.
'/D "VERSION=\"0.01\""  /D "XS_VERSION=\"0.01\"" /D "_CSTDIO_" /D "_STD_USING" '.
'/D "_WINDLL" /FD /EHsc /MD /Zi /Gd /TP /c';

my @acomp1 = get_comp_arr( $comp1 );
my $c1cnt = scalar @acomp1;
prt( "Got $c1cnt items ...\n" );
my @acomp2 = get_comp_arr( $comp2 );
my $c2cnt = scalar @acomp2;
prt( "Got $c2cnt items ...\n" );

for ($i1 = 0; $i1 < $c1cnt; $i1++) {
	$ch1 = $acomp1[$i1][0];
	$tg1 = $acomp1[$i1][1];
	##prt( "$ch1 = $tg1\n" );
	for ($i2 = 0; $i2 < $c2cnt; $i2++) {
		$ch2 = $acomp2[$i2][0];
		$tg2 = $acomp2[$i2][1];
		##prt( "$ch2 = $tg2\n" );
		if (($ch1 eq $ch2)&&($tg1 eq $tg2)) {
			$acomp2[$i2][2] = $i1 + 1;
			$acomp1[$i1][2] = $i2 + 1;
		}
	}
}
# ======================================
prt( "\nPerl: 1 not found in 2 ...\n" );
for ($i1 = 0; $i1 < $c1cnt; $i1++) {
	$ch1 = $acomp1[$i1][0];
	$tg1 = $acomp1[$i1][1];
	if ($acomp1[$i1][2] == 0) {
		prt( "$ch1 = $tg1\n" );
	}
}

# ======================================
prt( "\nMSVC: n2 not found in 1 ...\n" );
for ($i2 = 0; $i2 < $c2cnt; $i2++) {
	$ch2 = $acomp2[$i2][0];
	$tg2 = $acomp2[$i2][1];
	if ($acomp2[$i2][2] == 0) {
		prt( "$ch2 = $tg2\n" );
	}
}
prt("\n");

close_log($outfile,0);
exit(0);

sub get_comp_arr {
	my ($txt) = shift;
	my $len = length($txt);
	my ($i, $ch, $sw, $tag, $tc);
	my @arr = ();
	for ($i = 0; $i < $len; $i++) {
		$sw = substr($txt,$i,1);
		if (($sw eq '/')||($sw eq '-')) {
			# start of a switch
			$i++;
			if ($i < $len) {
				$ch = substr($txt,$i,1);	# get NEXT after switch
				$tag = '';
				$i++;
				for ( ; $i < $len; $i++) {
					$tc = substr($txt,$i,1);	# get NEXT after switch
					if (($tc eq '/')||($tc eq '-')) {
						# start of NEXT switch
						$i--;	# back up one
						last;
					}
					if (($tc ne ' ')&&($tc ne '"')) {
						$tag .= $tc;	# build up tag
					}
				}
				push(@arr, [$ch, $tag, 0]);
			}
		}
	}
	return @arr;
}

# eof
