#!C:/Perl -w
#AIM: Test DATE/TIME functions
# see : http://www.perl.com/CPAN/modules/by-module/Date/
# see : http://www.perlhowto.com/node/26 - working with date/time 
# see : http://www.perl.com/cs/user/query/q/6?id_topic=73 - Date::Parse
# Converts date strings into Unix time values. (A Unix time value is the number of 
# seconds since January 1, 1970.) [pod]
# Not included in AcivePerl, and could not find Date::Parse
# using PPM installed Date-Calc in the hope ...
# from : ppm
# ppm install Date-Calc, got -
# Successfully installed Date-Calc version 5.4 in ActivePerl 5.8.6.811.
# this has the functions -   use Date::Calc qw(
# Days_in_Year Days_in_Month Weeks_in_Year leap_year check_date check_business_date
# Day_of_Year Date_to_Days Day_of_Week Week_Number Week_of_Year Monday_of_Week
# Nth_Weekday_of_Month_Year Standard_to_Business Business_to_Standard
# Delta_Days Delta_DHMS Add_Delta_Days Add_Delta_DHMS Add_Delta_YMD
# System_Clock Today Now Today_and_Now Easter_Sunday Decode_Month
# Decode_Day_of_Week Decode_Language Decode_Date_EU Decode_Date_US
# Compress Uncompress check_compressed Compressed_to_Text Date_to_Text
# Date_to_Text_Long English_Ordinal Calendar Month_to_Text Day_of_Week_to_Text
# Day_of_Week_Abbreviation Language_to_Text Language Languages Decode_Date_EU2
# Decode_Date_US2 Parse_Date );
# formats of output
# 1  English    :  "Wwwwww, Mmmmmm ddth yyyy"
# 2  French     :  "Wwwwww, le dd Mmmmmm yyyy"
# 3  German     :  "Wwwwww, den dd. Mmmmmm yyyy"
# 4  Spanish    :  "Wwwwww, dd de Mmmmmm de yyyy"
# 5  Portuguese :  "Wwwwww, dia dd de Mmmmmm de yyyy"
# 6  Dutch      :  "Wwwwww, dd. Mmmmmm yyyy"
# 7  Italian    :  "Wwwwww, dd Mmmmmm yyyy"
# Date_to_Days -
# This function returns the (absolute) number of the day of the given date, 
# where counting starts at the 1st of January of the year 1 A.D.
# thus $unixsecs = 	((Date_to_Days($year,$month,$day) -  Date_to_Days(1970,1,1)) * 24 * 60 * 60);
# Because counting starts at '1', you will actually have to subtract '1' from the 
# canonical date in order to get back the original date:
# eg $canonical = Date_to_Days($year,$month,$day);
#  ($year,$month,$day) = Add_Delta_Days(1,1,1, $canonical - 1);
use strict;
##use Date::Parse; # str2time strptime
use Date::Calc qw(:all);

my $dt1 = '1995:01:24T09:08:17.1823213'; # ISO-8601
my $dt2 = '1995-01-24T09:08:17.1823213'; #
my $dt3 = 'Wed, 16 Jun 94 07:29:35 CST'; # Comma and day name are optional 
my $dt4 = 'Thu, 13 Oct 94 10:13:13 -0700';
my $dt5 = 'Wed, 9 Nov 1994 09:50:32 -0500 (EST)'; # Text in ()'s will be ignored.
my $dt6 = '21 dec 17:05';                #  Will be parsed in the current time zone
my $dt7 = '21-dec 17:05';
my $dt8 = '21/dec 17:05';
my $dt9 = '21/dec/93 17:05';
my $dt10 = '1999 10:02:18 "GMT"';
my $dt11 = '16 Nov 94 22:28:20 PST';

my @usdates = ("1 3 64", "01/03/64", "Jan 3 '64", "Jan 3 1964", "===> January 3rd 1964 (birthday)",
	"Jan31964", "Jan364", "ja364", "1364" );

my @eudates64 = ("3.1.64", "3 1 64", "03.01.64", "03/01/64", "3. Jan 1964", "Birthday: 3. Jan '64 in Backnang/Germany",
	"03-Jan-64", "3.Jan1964", "3Jan64", "030164", "3ja64", "3164", "3.1.1964" );

my @eudates = ("12.9.2006", "12 9 06", "12.09.2006", "12/09/06", "12. Sep 2006", "Birthday: 12. Sep '06 in Backnang/Germany",
	"12-Sep-06", "12.Sep2006", "12Sep06", "120906", "12sep06", "12906", "12.9.2006" );

my ($year,$month,$day);
my ($hour,$min,$sec);
my ($days);

##my $date = $dt1;
##$time = str2time($date);
##($ss,$mm,$hh,$day,$month,$year,$zone) = strptime($date);
# Parse_Date

# Date::Calc
($year,$month,$day) = Today(); 
print "year=$year month=$month day=$day\n";
# This function returns a subset of the values returned by the 
# function ``System_Clock()'' (see above for details), namely the current year, month and day.
# A fatal ``not available on this system'' error message will appear if the 
# corresponding system calls are not supported by your current operating system.
($hour,$min,$sec) = Now(); 
print "hour=$hour min=$min sec=$sec\n";
# This function returns a subset of the values returned by the
# function ``System_Clock()'' (see above for details), namely the current 
# time (hours, minutes and full seconds).
# A fatal ``not available on this system'' error message will appear if the 
# corresponding system calls are not supported by your current operating system.
($year,$month,$day, $hour,$min,$sec) = Today_and_Now(); 
print "year=$year month=$month day=$day hour=$hour min=$min sec=$sec\n";
my $osecs = time();
$sec = $osecs;
my $date = localtime($sec);
print "$date = $sec seconds ...\n";
try_us_parse($date); # failed
###foreach my $ud (@usdates) {
###	try_us_parse($ud); # these all work
###}
foreach my $ud (@eudates) {
	try_eu_parse($ud); # these all work
}
###out_date_set($date);
exit(0);

sub try_us_parse {
	my ($dt) = shift;
	if (($year,$month,$day) = Decode_Date_US($dt)) {
		print "year=$year month=$month day=$day from [$dt]\n";
	} else {
		print "Parse US of [$dt] failed ...\n";
	}
}

sub try_eu_parse {
	my ($dt) = shift;
	if (($year,$month,$day) = Decode_Date_EU($dt)) {
		$days = Date_to_Days($year,$month,$day);
		my $udays = Date_to_Days(1970,1,1);
		###my $canonical = Date_to_Days($year,$month,$day);
		$sec = (($days - $udays) * 24 * 60 * 60);
		print "year=$year month=$month day=$day from [$dt] $days days $sec seconds ";
		my $tm = localtime($sec);
		if ($tm) {
			print " $tm";
		} else {
			$tm = localtime($osecs);
			###print " $tm\n" if ($tm);
		}
		print "\n";
		($year,$month,$day) = Add_Delta_Days(1,1,1, $days - 1);
		my $stg1 = Date_to_Text($year,$month,$day);
		my $stg2 = Date_to_Text_Long($year,$month,$day);
		print "Now year=$year month=$month day=$day $stg1 [$stg2]\n";
	} else {
		print "Parse US of [$dt] failed ...\n";
	}
}


sub try_parse($) {
	my ($dt) = shift;
	if (($year,$month,$day) = Parse_Date($dt)) {
		print "year=$year month=$month day=$day from [$dt]\n";
	} else {
		print "Parse of [$dt] failed ...\n";
	}
}

sub out_date_set() {
	my ($d) = shift;
	try_parse($d);
	try_parse($dt1);
	try_parse($dt2);
	try_parse($dt3);
	try_parse($dt4);
	try_parse($dt5);
	try_parse($dt6);
	try_parse($dt7);
	try_parse($dt8);
	try_parse($dt9);
	try_parse($dt10);
	try_parse($dt11);
}

# eof - datecalc.pl

