#!/bin/perl
# dms2ll.pl - Oct 2005 - geoff mclane
# AIM: To accept an input DEGREES MINUTES (SECONDS DECIMAL) [NSEW]
# and convert to a single decimal degrees ... 47 28 0 N
# 24/09/2013 - some improvements
# 21/07/2011 - Fix bug when entered 
# 12/11/2010 - Attempt to reconstitute the same FORM
# 20061206 - Later added conversion back to DEG MIN SECS as a check ...
use strict;
use warnings;
# print "Hello, World ... Arguments are ...\n";
my $g_argcnt = 0;
my $arg = '';
my $arg2 = '';
my $g_args = '';  # out of array, into string
my $degs = 0;
my $deg1 = 0;
my $quad = '';
my $g_degs = 0; # first argment

# functions
my $sdeg = ' ';

sub deg2dms2f {
    my ($pos, $neg, $deg) = @_;

    my $sign = $pos;
    if ($deg < 0) {
        $sign = $neg;
        $deg = -$deg;
    }
    my $d = int($deg * 360000 + 0.5);
    my $s = ($d % 6000) / 100;
    $d = int($d / 6000);
    my $m = $d % 60;
    $d = int($d / 60);

    return ($sign, $d, $m, $s);
}

sub deg2dm {
    my ($pos, $neg, $deg) = @_;

    my $sign = $pos;
    if ($deg < 0) {
        $sign = $neg;
        $deg = -$deg;
    }
    my $d = int($deg * 60 + 0.5);
    my $m = $d % 60;
    $d = int($d / 60);

    return ($sign, $d, $m);
}

sub coords2str {
    my ($lat, $lon) = @_;
    my $form ="%s%02d${sdeg}%02d'%05.2f\", %s%03d${sdeg}%02d'%05.2f\" (%.7f, %.7f)"; 
    sprintf($form,
            deg2dms2f('N', 'S', $lat), deg2dms2f('E', 'W', $lon), $lat, $lon);
}

sub lat2str {
    my ($lat) = @_;
    my $form ="%s%02d${sdeg}%02d'%05.2f\" (%.7f)"; 
    sprintf($form, deg2dms2f('N', 'S', $lat), $lat );
}

sub lon2str {
    my ($lon) = @_;
    my $form ="%s%02d${sdeg}%02d'%05.2f\" (%.7f)"; 
    sprintf($form, deg2dms2f('E', 'W', $lon), $lon );
}

sub lon2strdm {
    my ($md) = @_;
    my $form = "%s%d${sdeg}%02d' (%.2f)";
    sprintf($form, deg2dm('E', 'W', $md), $md);
}

sub lat2strdm {
    my ($md) = @_;
    my $form = "%s%d${sdeg}%02d' (%.2f)";
    sprintf($form, deg2dm('N', 'S', $md), $md);
}


foreach $arg (@ARGV) {
	$g_args .= ' ' if ($g_argcnt);
	$g_args .= $arg;
	$g_argcnt++;
	if ($g_argcnt == 1) {
        if ($arg =~ /^\d/) {
            # start with a number
        } else {
            $arg = substr($arg,1) if ($arg =~ /^\w/);
        }
        $arg = substr($arg,0,length($arg)-1) if ($arg =~ /\D$/);
		$deg1 = $arg;
		$degs += $arg;
		print "Arg 1 Degrees = $arg ($deg1) = $degs\n";
        $g_degs = $arg;
	} elsif ($g_argcnt == 2) {
        $arg = substr($arg,0,length($arg)-1) if ($arg =~ /\D$/);
		$arg2 = $arg;
		$arg2 =~ s/\'//;
		$degs += ($arg2 / 60);
		$deg1 = ($arg2 / 60);
		print "Arg 2 Minutes = $arg ($deg1) = $degs\n";
	} elsif ($g_argcnt == 3) {
		$arg2 = $arg;
		$arg2 =~ s/\"//;
        $arg2 = substr($arg2,0,length($arg2)-1) while ($arg2 =~ /\D$/);
        $arg2 = substr($arg2,0,length($arg2)-1) while ($arg2 =~ /\s$/);
		$degs += ($arg2 / (60*60));
		$deg1 = ($arg2 / (60*60));
		print "Arg 3 Seconds = $arg ($deg1) = $degs\n";
	} else {
        if (($arg eq 'N')||($arg eq 'S')||($arg eq 'E')||($arg eq 'W')) {
            $quad = $arg;
            if ($quad =~ /(S|W)/) {
            	print "Quadrant: $quad ...(negative) ";
            	$degs *= -1;
            } else {
            	print "Quadrant: $quad ... ";
            }
            print "$degs\n";
        } else {
    		###$deg1 = 0;
            print "Arg $g_argcnt: Unknown argument [$arg]...\n";
            #exit(1);
        }
	}
}

print "Found $g_argcnt arguments ... [$g_args]\n";

if (length($quad)==0) {
    if ($g_args =~ /(N|E)/i) {
        # nothing
        $quad = $1;
        print "Quadrant: $quad ...\n";
    } elsif ($g_args =~ /(S|W)/i) {
        $degs *= -1;
        $quad = $1;
        print "Quadrant: $quad ...(negative)\n";
    } else {
        print "No quadrant NSEW found ... assumed positive ...[$g_args]\n";
    }
}

print "Degrees = $degs\n";
# now to convert is back
my $nquad = 'N|E';
if ($degs < 0) {
	$nquad = 'S|W';
	$degs *= -1;
}
my $idegs = int($degs);
my $rmins = ($degs - $idegs) * 60;
my $imins = int($rmins);
my $rsecs = ($rmins - $imins) * 60;
if ($g_argcnt == 1) {
    print "dms = [$g_degs $nquad] ... from [$g_args]\n";
} elsif ($g_argcnt == 2) {
    print "dms = [$idegs $rmins $nquad] ... from [$g_args]\n";
} elsif ($g_argcnt == 3) {
    print "dms = [$idegs $imins $rsecs $nquad] ... from [$g_args]\n";
} else {
    print "dms = [$idegs $imins $rsecs $nquad] ... from [$g_args]\n";
}

if (($quad eq 'N')||($quad eq 'S')) {
    print "Latitude: dms=".lat2str($degs)." dm=".lat2strdm($degs)."\n";
} elsif (($arg eq 'E')||($arg eq 'W')) {
    print "Longitude: dms=".lon2str($degs)." dm:".lon2strdm($degs)."\n";
}
exit(0);

# eof = dms2ll.pl
