#!/Perl
use strict;
use warnings;
use Encode;
require 'logfile.pl' or die "ERROR: Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
my $item = '';
my $cnt = 0;
my $msg = '';
open_log($outfile);
prt(  "$0... Hello, World...\n" );

my @list = Encode->encodings();
my @all_encodings = Encode->encodings(":all");
$cnt = scalar @list;
prt( "Have $cnt encodings ...\n" );
$cnt = 0;
foreach $item (@list) {
	$cnt++;
	$msg = sprintf( "% 6d) [%s] ...", $cnt, $item );
	prt( "$msg\n" );
}
prt( "Done $cnt list ...\n" );
$cnt = scalar @all_encodings;
prt( "Have $cnt ALL encodings ...\n" );
$cnt = 0;
foreach $item (@all_encodings) {
	$cnt++;
	$msg = sprintf( "% 6d) [%s] ...", $cnt, $item );
	prt( "$msg\n" );
}
prt( "Done $cnt list ...\n" );

close_log($outfile, 1);
exit(0);

# eof - encode01.pl
